/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.compiler.artifact.ChooseKeyDialog;
import org.jetbrains.android.compiler.artifact.NewKeyStoreDialog;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUiUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.android.util.AndroidUiUtil");

    private AndroidUiUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<String> loadExistingKeys(@NotNull ApkSigningSettingsForm form) {
        String errorPrefix = "Cannot load key store: ";
        InputStream is = null;
        try {
            is = new FileInputStream(new File(form.getKeyStorePathField().getText().trim()));
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, form.getKeyStorePasswordField().getPassword());
            List<String> list = AndroidUtils.toList(keyStore.aliases());
            return list;
        }
        catch (KeyStoreException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (FileNotFoundException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (CertificateException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (NoSuchAlgorithmException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    public static void initSigningSettingsForm(final @NotNull Project project, final @NotNull ApkSigningSettingsForm form) {
        form.getLoadKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultPath = form.getKeyStorePathField().getText().trim();
                VirtualFile defaultFile = LocalFileSystem.getInstance().findFileByPath(defaultPath);
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)form.getPanel(), (Project)project, (VirtualFile)defaultFile);
                if (file != null) {
                    form.getKeyStorePathField().setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
        });
        form.getCreateKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewKeyStoreDialog dialog = new NewKeyStoreDialog(project, form.getKeyStorePathField().getText());
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    form.getKeyStorePathField().setText(dialog.getKeyStorePath());
                    form.getKeyStorePasswordField().setText(String.valueOf(dialog.getKeyStorePassword()));
                    form.getKeyAliasField().setText(dialog.getKeyAlias());
                    form.getKeyPasswordField().setText(String.valueOf(dialog.getKeyPassword()));
                }
            }
        });
        form.getKeyAliasField().getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List keys = AndroidUiUtil.loadExistingKeys(form);
                if (keys == null) {
                    return;
                }
                ChooseKeyDialog dialog = new ChooseKeyDialog(project, form.getKeyStorePathField().getText().trim(), form.getKeyStorePasswordField().getPassword(), keys, form.getKeyAliasField().getText().trim());
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    char[] password;
                    String chosenKey = dialog.getChosenKey();
                    if (chosenKey != null) {
                        form.getKeyAliasField().setText(chosenKey);
                    }
                    if ((password = dialog.getChosenKeyPassword()) != null) {
                        form.getKeyPasswordField().setText(String.valueOf(password));
                    }
                }
            }
        });
    }
}

