/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.io.FileOpUtils;
import com.android.repository.io.impl.FileSystemFileOp;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Set;

public class MockFileOp
extends FileSystemFileOp {
    private FileSystem mFileSystem = MockFileOp.createFileSystem();

    public MockFileOp() {
        this.mIsWindows = FileOpUtils.create().isWindows();
    }

    private static FileSystem createFileSystem() {
        Configuration config = Configuration.unix();
        config = config.toBuilder().setWorkingDirectory("/").setAttributeViews("posix", new String[0]).build();
        return Jimfs.newFileSystem((Configuration)config);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.mFileSystem;
    }

    public void reset() {
        this.mFileSystem = MockFileOp.createFileSystem();
    }

    @Override
    public void deleteOnExit(File file) {
    }

    public void setIsWindows(boolean isWindows) {
        this.mIsWindows = isWindows;
    }

    @Override
    public boolean canWrite(File file) {
        try {
            return !Sets.intersection(Files.getPosixFilePermissions(this.toPath(new File(this.getAgnosticAbsPath(file))), new LinkOption[0]), (Set)ImmutableSet.of((Object)((Object)PosixFilePermission.OTHERS_WRITE), (Object)((Object)PosixFilePermission.GROUP_WRITE), (Object)((Object)PosixFilePermission.OWNER_WRITE))).isEmpty();
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getAgnosticAbsPath(File file) {
        return this.getAgnosticAbsPath(file.getAbsolutePath());
    }

    public String getAgnosticAbsPath(String path) {
        if (this.isWindows()) {
            path = path.replace('\\', '/');
            path = path.replaceAll("^[A-Z]:", "");
        }
        return path;
    }

    public void recordExistingFile(File file) {
        this.recordExistingFile(this.getAgnosticAbsPath(file), 0L, (byte[])null);
    }

    public void recordExistingFile(String absFilePath) {
        this.recordExistingFile(absFilePath, 0L, (byte[])null);
    }

    public void recordExistingFile(String absFilePath, byte[] inputStream) {
        this.recordExistingFile(absFilePath, 0L, inputStream);
    }

    public void recordExistingFile(String absFilePath, String content) {
        this.recordExistingFile(absFilePath, 0L, content.getBytes(Charsets.UTF_8));
    }

    public void recordExistingFile(String absFilePath, long lastModified, byte[] inputStream) {
        block2: {
            try {
                Path path = this.mFileSystem.getPath(this.getAgnosticAbsPath(absFilePath), new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, inputStream == null ? new byte[]{} : inputStream, new OpenOption[0]);
                Files.setLastModifiedTime(path, FileTime.fromMillis(lastModified));
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
    }

    public void recordExistingFile(String absFilePath, long lastModified, String content) {
        this.recordExistingFile(absFilePath, lastModified, content.getBytes(Charsets.UTF_8));
    }

    public void recordExistingFolder(File folder) {
        this.recordExistingFolder(this.getAgnosticAbsPath(folder));
    }

    public void recordExistingFolder(String absFolderPath) {
        block2: {
            try {
                Files.createDirectories(this.mFileSystem.getPath(this.getAgnosticAbsPath(absFolderPath), new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
    }

    public boolean hasRecordedExistingFolder(File folder) {
        return this.exists(folder) && this.isDirectory(folder);
    }

    public String[] getExistingFiles() {
        ArrayList result = new ArrayList();
        this.mFileSystem.getRootDirectories().forEach(path -> {
            block2: {
                try {
                    Files.find(path, 100, (p, a) -> true, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).forEach(p -> result.add(p.toString()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        });
        return result.toArray(new String[result.size()]);
    }

    public String[] getExistingFolders() {
        ArrayList result = new ArrayList();
        this.mFileSystem.getRootDirectories().forEach(path -> {
            block2: {
                try {
                    Files.find(path, 100, (p, a) -> true, new FileVisitOption[0]).filter(p -> Files.isDirectory(p, new LinkOption[0])).forEach(p -> result.add(p.toString()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        });
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File ensureRealFile(File in) throws IOException {
        if (!this.exists(in)) {
            return in;
        }
        File result = File.createTempFile("MockFileOp", null);
        result.deleteOnExit();
        try (FileOutputStream os = new FileOutputStream(result);){
            ByteStreams.copy((InputStream)this.newFileInputStream(in), (OutputStream)os);
        }
        return result;
    }

    public byte[] getContent(File file) {
        try {
            return Files.readAllBytes(this.toPath(file));
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public Path toPath(File file) {
        return this.getFileSystem().getPath(this.getAgnosticAbsPath(file.getPath()), new String[0]);
    }
}

