/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf3jarjar;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    private static final long ARRAY_BASE_OFFSET = UnsafeUtil.byteArrayBaseOffset();
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.field(Buffer.class, "address"));

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static long getArrayBaseOffset() {
        return ARRAY_BASE_OFFSET;
    }

    static byte getByte(byte[] target, long offset) {
        return UNSAFE.getByte(target, offset);
    }

    static void putByte(byte[] target, long offset, byte value) {
        UNSAFE.putByte(target, offset, value);
    }

    static void copyMemory(byte[] src, long srcOffset, byte[] target, long targetOffset, long length) {
        UNSAFE.copyMemory(src, srcOffset, target, targetOffset, length);
    }

    static long getLong(byte[] target, long offset) {
        return UNSAFE.getLong(target, offset);
    }

    static byte getByte(long address) {
        return UNSAFE.getByte(address);
    }

    static void putByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    static long getLong(long address) {
        return UNSAFE.getLong(address);
    }

    static void copyMemory(long srcAddress, long targetAddress, long length) {
        UNSAFE.copyMemory(srcAddress, targetAddress, length);
    }

    static long addressOffset(ByteBuffer buffer) {
        return UNSAFE.getLong(buffer, BUFFER_ADDRESS_OFFSET);
    }

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static boolean supportsUnsafeArrayOperations() {
        boolean supported = false;
        if (UNSAFE != null) {
            try {
                Class<?> clazz = UNSAFE.getClass();
                clazz.getMethod("arrayBaseOffset", Class.class);
                clazz.getMethod("getByte", Object.class, Long.TYPE);
                clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                clazz.getMethod("getLong", Object.class, Long.TYPE);
                clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                supported = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return supported;
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        boolean supported = false;
        if (UNSAFE != null) {
            try {
                Class<?> clazz = UNSAFE.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                clazz.getMethod("getByte", Long.TYPE);
                clazz.getMethod("getLong", Object.class, Long.TYPE);
                clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
                clazz.getMethod("getLong", Long.TYPE);
                clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
                supported = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return supported;
    }

    private static int byteArrayBaseOffset() {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? UNSAFE.arrayBaseOffset(byte[].class) : -1;
    }

    private static long fieldOffset(Field field) {
        return field == null || UNSAFE == null ? -1L : UNSAFE.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Throwable t) {
            field = null;
        }
        return field;
    }
}

