/*
 * Decompiled with CFR 0.152.
 */
package io.nettyjarjar.handler.codec.http2;

import io.nettyjarjar.buffer.ByteBuf;
import io.nettyjarjar.handler.codec.http2.DefaultHttp2Headers;
import io.nettyjarjar.handler.codec.http2.Http2Error;
import io.nettyjarjar.handler.codec.http2.Http2Exception;
import io.nettyjarjar.handler.codec.http2.Http2HeaderTable;
import io.nettyjarjar.handler.codec.http2.Http2Headers;
import io.nettyjarjar.handler.codec.http2.Http2HeadersDecoder;
import io.nettyjarjar.handler.codec.http2.internal.hpack.Decoder;
import io.nettyjarjar.util.internal.ObjectUtil;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private static final float HEADERS_COUNT_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_COUNT_WEIGHT_HISTORICAL = 0.8f;
    private final Decoder decoder;
    private final Http2HeaderTable headerTable;
    private final boolean validateHeaders;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    public DefaultHttp2HeadersDecoder(boolean validateHeaders) {
        this(validateHeaders, new Decoder());
    }

    public DefaultHttp2HeadersDecoder(boolean validateHeaders, int initialHuffmanDecodeCapacity) {
        this(validateHeaders, new Decoder(initialHuffmanDecodeCapacity));
    }

    DefaultHttp2HeadersDecoder(boolean validateHeaders, Decoder decoder) {
        this.decoder = ObjectUtil.checkNotNull(decoder, "decoder");
        this.headerTable = new Http2HeaderTableDecoder();
        this.validateHeaders = validateHeaders;
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    @Override
    public Http2Headers decodeHeaders(int streamId, ByteBuf headerBlock) throws Http2Exception {
        try {
            DefaultHttp2Headers headers = new DefaultHttp2Headers(this.validateHeaders, (int)this.headerArraySizeAccumulator);
            this.decoder.decode(streamId, headerBlock, headers);
            this.headerArraySizeAccumulator = 0.2f * (float)headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return headers;
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, e.getMessage(), new Object[0]);
        }
    }

    private final class Http2HeaderTableDecoder
    implements Http2HeaderTable {
        private Http2HeaderTableDecoder() {
        }

        @Override
        public void maxHeaderTableSize(long max) throws Http2Exception {
            DefaultHttp2HeadersDecoder.this.decoder.setMaxHeaderTableSize(max);
        }

        @Override
        public long maxHeaderTableSize() {
            return DefaultHttp2HeadersDecoder.this.decoder.getMaxHeaderTableSize();
        }

        @Override
        public void maxHeaderListSize(long max) throws Http2Exception {
            DefaultHttp2HeadersDecoder.this.decoder.setMaxHeaderListSize(max);
        }

        @Override
        public long maxHeaderListSize() {
            return DefaultHttp2HeadersDecoder.this.decoder.getMaxHeaderListSize();
        }
    }
}

