/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangeProviderContext;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnRecursiveStatusWalker;
import org.jetbrains.idea.svn.SvnScopeZipper;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;

public class SvnChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangeProvider");
    public static final String PROPERTY_LAYER = "Property";
    private static final NotNullFactory<Map<String, File>> NAME_TO_FILE_MAP_FACTORY = new NotNullFactory<Map<String, File>>(){

        @NotNull
        public Map<String, File> create() {
            return ContainerUtil.newHashMap();
        }
    };
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final VcsContextFactory myFactory;
    @NotNull
    private final SvnFileUrlMappingImpl mySvnFileUrlMapping;

    public SvnChangeProvider(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        this.myFactory = VcsContextFactory.SERVICE.getInstance();
        this.mySvnFileUrlMapping = (SvnFileUrlMappingImpl)vcs.getSvnFileUrlMapping();
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        SvnScopeZipper zipper = new SvnScopeZipper(dirtyScope);
        zipper.run();
        Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap = zipper.getNonRecursiveDirs();
        ISVNStatusFileProvider fileProvider = SvnChangeProvider.createFileProvider(nonRecursiveMap);
        try {
            SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, progress);
            NestedCopiesBuilder nestedCopiesBuilder = new NestedCopiesBuilder(this.myVcs, this.mySvnFileUrlMapping);
            EventDispatcher statusReceiver = EventDispatcher.create(StatusReceiver.class);
            statusReceiver.addListener((EventListener)context);
            statusReceiver.addListener((EventListener)nestedCopiesBuilder);
            SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, (StatusReceiver)statusReceiver.getMulticaster(), progress);
            for (FilePath path : zipper.getRecursiveDirs()) {
                walker.go(path, Depth.INFINITY);
            }
            walker.setFileProvider(fileProvider);
            for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
                walker.go(item.getDir(), Depth.IMMEDIATES);
            }
            ((StatusReceiver)statusReceiver.getMulticaster()).finish();
            this.processCopiedAndDeleted(context, dirtyScope);
            SvnChangeProvider.processUnsaved(dirtyScope, addGate, context);
            Set<NestedCopyInfo> nestedCopies = nestedCopiesBuilder.getCopies();
            this.mySvnFileUrlMapping.acceptNestedData(nestedCopies);
            SvnChangeProvider.putAdministrative17UnderVfsListener(nestedCopies);
        }
        catch (SvnExceptionWrapper e) {
            LOG.info((Throwable)e);
            throw new VcsException(e.getCause());
        }
        catch (SVNException e) {
            if (e.getCause() != null) {
                throw new VcsException(e.getMessage() + " " + e.getCause().getMessage(), (Throwable)e);
            }
            throw new VcsException((Throwable)e);
        }
    }

    private static void putAdministrative17UnderVfsListener(Set<NestedCopyInfo> pointInfos) {
        if (!SvnVcs.ourListenToWcDb) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (NestedCopyInfo info : pointInfos) {
            if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat()) || NestedCopyType.switched.equals((Object)info.getType())) continue;
            VirtualFile root = info.getFile();
            lfs.refreshIoFiles(Collections.singletonList(SvnUtil.getWcDb(new File(root.getPath()))), true, false, null);
        }
    }

    private static void processUnsaved(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangeListManagerGate addGate, @NotNull SvnChangeProviderContext context) throws SVNException {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : fileDocumentManager.getUnsavedDocuments()) {
            FileStatus status;
            VirtualFile file = fileDocumentManager.getFile(unsavedDocument);
            if (file == null || !dirtyScope.belongsTo(VcsUtil.getFilePath((VirtualFile)file)) || !fileDocumentManager.isFileModified(file) || (status = addGate.getStatus(file)) != null && !FileStatus.NOT_CHANGED.equals(status)) continue;
            context.addModifiedNotSavedChange(file);
        }
    }

    @NotNull
    private static ISVNStatusFileProvider createFileProvider(@NotNull Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap) {
        final HashMap result = ContainerUtil.newHashMap();
        for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
            File file = item.getDir().getIOFile();
            Map fileMap = (Map)ContainerUtil.getOrCreate((Map)result, (Object)file.getAbsolutePath(), NAME_TO_FILE_MAP_FACTORY);
            for (FilePath path : item.getChildrenList()) {
                fileMap.put(path.getName(), path.getIOFile());
            }
            if (file.getParentFile() == null) continue;
            Map parentMap = (Map)ContainerUtil.getOrCreate((Map)result, (Object)file.getParentFile().getAbsolutePath(), NAME_TO_FILE_MAP_FACTORY);
            parentMap.put(file.getName(), file);
        }
        return new ISVNStatusFileProvider(){

            public Map<String, File> getChildrenFiles(File parent) {
                return (Map)result.get(parent.getAbsolutePath());
            }
        };
    }

    private void processCopiedAndDeleted(@NotNull SvnChangeProviderContext context, @Nullable VcsDirtyScope dirtyScope) throws SVNException {
        for (SvnChangedFile copiedFile : context.getCopiedFiles()) {
            context.checkCanceled();
            this.processCopiedFile(copiedFile, context, dirtyScope);
        }
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            context.checkCanceled();
            context.processStatus(deletedFile.getFilePath(), deletedFile.getStatus());
        }
    }

    public void getChanges(@NotNull FilePath path, boolean recursive, @NotNull ChangelistBuilder builder) throws SVNException, SvnBindException {
        SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, null);
        SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, context, ProgressManager.getInstance().getProgressIndicator());
        walker.go(path, recursive ? Depth.INFINITY : Depth.IMMEDIATES);
        this.processCopiedAndDeleted(context, null);
    }

    private void processCopiedFile(@NotNull SvnChangedFile copiedFile, @NotNull SvnChangeProviderContext context, @Nullable VcsDirtyScope dirtyScope) throws SVNException {
        File file;
        boolean foundRename = false;
        Status copiedStatus = copiedFile.getStatus();
        String copyFromURL = (String)ObjectUtils.assertNotNull((Object)copiedFile.getCopyFromURL());
        HashSet<SvnChangedFile> deletedToDelete = new HashSet<SvnChangedFile>();
        for (SvnChangedFile svnChangedFile : context.getDeletedFiles()) {
            Status deletedStatus = svnChangedFile.getStatus();
            if (deletedStatus.getURL() == null || !Comparing.equal((String)copyFromURL, (String)deletedStatus.getURL().toString())) continue;
            String clName = SvnUtil.getChangelistName(copiedFile.getStatus());
            this.applyMovedChange(context, copiedFile.getFilePath(), dirtyScope, deletedToDelete, svnChangedFile, copiedStatus, clName);
            for (SvnChangedFile deletedChild : context.getDeletedFiles()) {
                Status childStatus = deletedChild.getStatus();
                SVNURL childUrl = childStatus.getURL();
                if (childUrl == null) continue;
                String childURL = childUrl.toDecodedString();
                if (!StringUtil.startsWithConcatenation((String)childURL, (String[])new String[]{copyFromURL, "/"})) continue;
                String relativePath = childURL.substring(copyFromURL.length());
                File newPath = new File(copiedFile.getFilePath().getIOFile(), relativePath);
                FilePath newFilePath = this.myFactory.createFilePathOn(newPath);
                if (context.isDeleted(newFilePath)) continue;
                this.applyMovedChange(context, newFilePath, dirtyScope, deletedToDelete, deletedChild, context.getTreeConflictStatus(newPath), clName);
            }
            foundRename = true;
            break;
        }
        List<SvnChangedFile> deletedFiles = context.getDeletedFiles();
        for (SvnChangedFile file2 : deletedToDelete) {
            deletedFiles.remove(file2);
        }
        if (!foundRename && copiedStatus.getURL() != null && (file = this.myVcs.getSvnFileUrlMapping().getLocalPath(copyFromURL)) != null) {
            Status status;
            try {
                status = this.myVcs.getFactory(file).createStatusClient().doStatus(file, false);
            }
            catch (SvnBindException ex) {
                LOG.info((Throwable)((Object)ex));
                status = null;
            }
            if (status != null && status.is(StatusType.STATUS_DELETED)) {
                FilePath filePath = this.myFactory.createFilePathOnDeleted(file, false);
                SvnContentRevision beforeRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, status.getRevision());
                ContentRevision afterRevision = CurrentContentRevision.create((FilePath)copiedFile.getFilePath());
                context.getBuilder().processChangeInList(context.createMovedChange(beforeRevision, afterRevision, copiedStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                foundRename = true;
            }
        }
        if (!foundRename) {
            LOG.info("Rename not found for " + copiedFile.getFilePath().getPresentableUrl());
            context.processStatus(copiedFile.getFilePath(), copiedStatus);
        }
    }

    private void applyMovedChange(@NotNull SvnChangeProviderContext context, @NotNull FilePath oldPath, final @Nullable VcsDirtyScope dirtyScope, @NotNull Set<SvnChangedFile> deletedToDelete, @NotNull SvnChangedFile deletedFile, @Nullable Status copiedStatus, @Nullable String clName) throws SVNException {
        boolean isUnder;
        final Change change = context.createMovedChange(this.createBeforeRevision(deletedFile, true), CurrentContentRevision.create((FilePath)oldPath), copiedStatus, deletedFile.getStatus());
        boolean bl = isUnder = dirtyScope == null ? true : (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ChangeListManagerImpl.isUnder((Change)change, (VcsDirtyScope)dirtyScope);
            }
        });
        if (isUnder) {
            context.getBuilder().removeRegisteredChangeFor(oldPath);
            context.getBuilder().processChangeInList(change, clName, SvnVcs.getKey());
            deletedToDelete.add(deletedFile);
        }
    }

    @NotNull
    private SvnContentRevision createBeforeRevision(@NotNull SvnChangedFile changedFile, boolean forDeleted) {
        Status status = changedFile.getStatus();
        FilePath path = changedFile.getFilePath();
        return SvnContentRevision.createBaseRevision(this.myVcs, forDeleted ? VcsUtil.getFilePath((File)status.getFile(), (boolean)path.isDirectory()) : path, status.getRevision());
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(@NotNull List<VirtualFile> files) {
        new CleanupWorker(this.myVcs, files).execute();
    }
}

