/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffAction;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.history.SimplePropertyRevision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnChangeProviderContext");
    @NotNull
    private final ChangelistBuilder myChangelistBuilder;
    @NotNull
    private final List<SvnChangedFile> myCopiedFiles = ContainerUtil.newArrayList();
    @NotNull
    private final List<SvnChangedFile> myDeletedFiles = ContainerUtil.newArrayList();
    @NotNull
    private final Map<String, Status> myTreeConflicted = ContainerUtil.newHashMap();
    @NotNull
    private final Map<FilePath, String> myCopyFromURLs = ContainerUtil.newHashMap();
    @NotNull
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    @NotNull
    private final List<File> filesToRefresh = ContainerUtil.newArrayList();
    @Nullable
    private final ProgressIndicator myProgress;

    public SvnChangeProviderContext(@NotNull SvnVcs vcs, @NotNull ChangelistBuilder changelistBuilder, @Nullable ProgressIndicator progress) {
        this.myVcs = vcs;
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, Status status) throws SVNException {
        if (status != null) {
            this.processStatusFirstPass(path, status);
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
        this.myChangelistBuilder.processIgnoredFile(vFile);
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
        this.myChangelistBuilder.processUnversionedFile(vFile);
    }

    @Override
    public void processCopyRoot(VirtualFile file, SVNURL url, WorkingCopyFormat format, SVNURL rootURL) {
    }

    @Override
    public void bewareRoot(VirtualFile vf, SVNURL url) {
    }

    @Override
    public void finish() {
        LocalFileSystem.getInstance().refreshIoFiles(this.filesToRefresh, true, false, null);
    }

    @NotNull
    public ChangelistBuilder getBuilder() {
        return this.myChangelistBuilder;
    }

    public void reportTreeConflict(@NotNull Status status) {
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public Status getTreeConflictStatus(@NotNull File file) {
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        return this.myCopiedFiles;
    }

    @NotNull
    public List<SvnChangedFile> getDeletedFiles() {
        return this.myDeletedFiles;
    }

    public boolean isDeleted(@NotNull FilePath path) {
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    @Nullable
    public String getParentCopyFromURL(@NotNull FilePath filePath) {
        FilePath parent;
        String result = null;
        for (parent = filePath; parent != null && !this.myCopyFromURLs.containsKey(parent); parent = parent.getParentPath()) {
        }
        if (parent != null) {
            String copyFromUrl = this.myCopyFromURLs.get(parent);
            result = parent == filePath ? copyFromUrl : SvnUtil.appendMultiParts(copyFromUrl, FileUtil.getRelativePath((File)parent.getIOFile(), (File)filePath.getIOFile()));
        }
        return result;
    }

    public void addCopiedFile(@NotNull FilePath filePath, @NotNull Status status, @NotNull String copyFromURL) {
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        ContainerUtil.putIfNotNull((Object)filePath, (Object)status.getCopyFromURL(), this.myCopyFromURLs);
    }

    void processStatusFirstPass(@NotNull FilePath filePath, @NotNull Status status) throws SVNException {
        if (status.getRemoteLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getRemoteLock().toLogicalLock(false));
        }
        if (status.getLocalLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getLocalLock().toLogicalLock(true));
        }
        if (filePath.isDirectory() && status.isLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if ((status.is(StatusType.STATUS_ADDED) || StatusType.STATUS_MODIFIED.equals((Object)status.getNodeStatus())) && status.getCopyFromURL() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromURL());
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            String parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(@NotNull FilePath filePath, @NotNull Status status) throws SVNException {
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(filePath.getIOFile());
        if (!WorkingCopyFormat.UNKNOWN.equals((Object)format) && format.less(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            this.loadEntriesFile(filePath);
        }
        FileStatus fStatus = SvnStatusConvertor.convertStatus(status);
        StatusType statusType = status.getContentsStatus();
        if (status.is(StatusType.STATUS_UNVERSIONED, StatusType.UNKNOWN)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null) {
                this.myChangelistBuilder.processUnversionedFile(file);
            }
        } else if (status.is(StatusType.STATUS_ADDED)) {
            this.processChangeInList(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status);
        } else if (status.is(StatusType.STATUS_CONFLICTED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED) || status.isProperty(StatusType.STATUS_MODIFIED, StatusType.STATUS_CONFLICTED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), fStatus, status);
            this.checkSwitched(filePath, status, fStatus);
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), null, fStatus, status);
        } else if (status.is(StatusType.STATUS_MISSING)) {
            this.myChangelistBuilder.processLocallyDeletedFile((LocallyDeletedChange)new SvnLocallyDeletedChange(filePath, this.getState(status)));
        } else if (status.is(StatusType.STATUS_IGNORED)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file == null) {
                file = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath.getPath());
            }
            if (file == null) {
                LOG.error("No virtual file for ignored file: " + filePath.getPresentableUrl() + ", isNonLocal: " + filePath.isNonLocal());
            } else if (!this.myVcs.isWcRoot(filePath)) {
                this.myChangelistBuilder.processIgnoredFile(filePath.getVirtualFile());
            }
        } else if ((fStatus == FileStatus.NOT_CHANGED || fStatus == FileStatus.SWITCHED) && statusType != StatusType.STATUS_NONE) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status);
            } else if (status.getTreeConflict() != null) {
                this.myChangelistBuilder.processChange(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnVcs.getKey());
            }
            this.checkSwitched(filePath, status, fStatus);
        }
    }

    public void addModifiedNotSavedChange(@NotNull VirtualFile file) throws SVNException {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Info svnInfo = this.myVcs.getInfo(file);
        if (svnInfo != null) {
            Status svnStatus = new Status();
            svnStatus.setRevision(svnInfo.getRevision());
            svnStatus.setKind(NodeKind.from(filePath.isDirectory()));
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnInfo.getRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, svnStatus);
        }
    }

    private void processChangeInList(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, @NotNull FileStatus fileStatus, @NotNull Status status) throws SVNException {
        Change change = this.createChange(beforeRevision, afterRevision, fileStatus, status);
        this.myChangelistBuilder.processChangeInList(change, SvnUtil.getChangelistName(status), SvnVcs.getKey());
    }

    private void checkSwitched(@NotNull FilePath filePath, @NotNull Status status, @NotNull FileStatus convertedStatus) {
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String switchUrl = status.getURL().toString();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                this.myChangelistBuilder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl : baseUrl, true);
            }
        }
    }

    private void loadEntriesFile(@NotNull FilePath filePath) {
        FilePath parentPath = filePath.getParentPath();
        if (parentPath == null) {
            return;
        }
        this.refreshDotSvnAndEntries(parentPath);
        if (filePath.isDirectory()) {
            this.refreshDotSvnAndEntries(filePath);
        }
    }

    private void refreshDotSvnAndEntries(@NotNull FilePath filePath) {
        File svn = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME);
        this.filesToRefresh.add(svn);
        this.filesToRefresh.add(new File(svn, "entries"));
    }

    @NotNull
    Change createMovedChange(@NotNull ContentRevision before, @NotNull ContentRevision after, @Nullable Status copiedStatus, @NotNull Status deletedStatus) throws SVNException {
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
        change.setBeforeDescription(deletedStatus.getTreeConflict());
        if (copiedStatus != null) {
            change.setAfterDescription(copiedStatus.getTreeConflict());
            this.patchWithPropertyChange(change, copiedStatus, deletedStatus);
        }
        return change;
    }

    @NotNull
    private Change createChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull FileStatus fStatus, @NotNull Status svnStatus) throws SVNException {
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, fStatus, this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
        change.setIsPhantom(StatusType.STATUS_DELETED.equals((Object)svnStatus.getNodeStatus()) && !svnStatus.getRevision().isValid());
        change.setBeforeDescription(svnStatus.getTreeConflict());
        this.patchWithPropertyChange(change, svnStatus, null);
        return change;
    }

    private void patchWithPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) throws SVNException {
        if (svnStatus.isProperty(StatusType.STATUS_CONFLICTED, StatusType.CHANGED, StatusType.STATUS_ADDED, StatusType.STATUS_DELETED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED, StatusType.MERGED)) {
            change.addAdditionalLayerElement("Property", this.createPropertyChange(change, svnStatus, deletedStatus));
        }
    }

    @NotNull
    private Change createPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) throws SVNException {
        File ioFile = ChangesUtil.getFilePath((Change)change).getIOFile();
        File beforeFile = deletedStatus != null ? deletedStatus.getFile() : ioFile;
        ContentRevision beforeRevision = !svnStatus.isProperty(StatusType.STATUS_ADDED) || deletedStatus != null ? this.createPropertyRevision(change, beforeFile, true) : null;
        ContentRevision afterRevision = !svnStatus.isProperty(StatusType.STATUS_DELETED) ? this.createPropertyRevision(change, ioFile, false) : null;
        FileStatus status = deletedStatus != null ? FileStatus.MODIFIED : SvnStatusConvertor.convertPropertyStatus(svnStatus.getPropertiesStatus());
        return new Change(beforeRevision, afterRevision, status);
    }

    @Nullable
    private ContentRevision createPropertyRevision(@NotNull Change change, @NotNull File file, boolean isBeforeRevision) throws SVNException {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        ContentRevision contentRevision = isBeforeRevision ? change.getBeforeRevision() : change.getAfterRevision();
        SVNRevision revision = isBeforeRevision ? SVNRevision.BASE : SVNRevision.WORKING;
        return new SimplePropertyRevision(ShowPropertiesDiffAction.getPropertyList(this.myVcs, file, revision), path, SvnChangeProviderContext.getRevisionNumber(contentRevision));
    }

    @Nullable
    private static String getRevisionNumber(@Nullable ContentRevision revision) {
        return revision != null ? revision.getRevisionNumber().asString() : null;
    }

    @NotNull
    private ConflictState getState(@Nullable Status svnStatus) {
        ConflictState result;
        ConflictState conflictState = result = svnStatus != null ? ConflictState.from(svnStatus) : ConflictState.none;
        if (result.isTree()) {
            this.reportTreeConflict(svnStatus);
        }
        return result;
    }
}

