/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBinaryContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnContentRevision
extends SvnBaseContentRevision
implements ByteBackedContentRevision {
    @NotNull
    private final SVNRevision myRevision;
    private final boolean myUseBaseRevision;

    protected SvnContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull SVNRevision revision, boolean useBaseRevision) {
        super(vcs, file);
        this.myRevision = revision;
        this.myUseBaseRevision = useBaseRevision;
    }

    @NotNull
    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Status status) {
        SVNRevision revision = status.getRevision().isValid() ? status.getRevision() : status.getCommittedRevision();
        return SvnContentRevision.createBaseRevision(vcs, file, revision);
    }

    @NotNull
    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull SVNRevision revision) {
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, true);
        }
        return new SvnContentRevision(vcs, file, revision, true);
    }

    @NotNull
    public static SvnContentRevision createRemote(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull SVNRevision revision) {
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, false);
        }
        return new SvnContentRevision(vcs, file, revision, false);
    }

    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.myFile, null);
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        try {
            if (this.myUseBaseRevision) {
                return (byte[])ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsKey)this.myVcs.getKeyInstanceMethod(), (CurrentRevisionProvider)new CurrentRevisionProvider(){

                    public VcsRevisionNumber getCurrentRevision() throws VcsException {
                        return SvnContentRevision.this.getRevisionNumber();
                    }

                    public Pair<VcsRevisionNumber, byte[]> get() throws VcsException, IOException {
                        return Pair.create((Object)SvnContentRevision.this.getRevisionNumber(), (Object)SvnContentRevision.this.getUpToDateBinaryContent());
                    }
                }).getSecond();
            }
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, () -> this.getUpToDateBinaryContent());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] getUpToDateBinaryContent() throws VcsException {
        File file = this.myFile.getIOFile();
        File lock = new File(file.getParentFile(), SvnUtil.PATH_TO_LOCK_FILE);
        if (lock.exists()) {
            throw new VcsException("Can not access file base revision contents: administrative area is locked");
        }
        return SvnUtil.getFileContents(this.myVcs, SvnTarget.fromFile((File)file), this.myUseBaseRevision ? SVNRevision.BASE : this.myRevision, SVNRevision.UNDEFINED);
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return new SvnRevisionNumber(this.myRevision);
    }

    @NonNls
    public String toString() {
        return this.myFile.getPath();
    }
}

