/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SvnScopeZipper
implements Runnable {
    @NotNull
    private final VcsDirtyScope myIn;
    @NotNull
    private final List<FilePath> myRecursiveDirs;
    @NotNull
    private final Map<String, MyDirNonRecursive> myNonRecursiveDirs;

    public SvnScopeZipper(@NotNull VcsDirtyScope in) {
        this.myIn = in;
        this.myRecursiveDirs = ContainerUtil.newArrayList((Iterable)in.getRecursivelyDirtyDirectories());
        this.myNonRecursiveDirs = ContainerUtil.newHashMap();
    }

    @Override
    public void run() {
        Set files = this.myIn.getDirtyFilesNoExpand();
        for (FilePath file : files) {
            if (file.isDirectory()) {
                VirtualFile vFile = file.getVirtualFile();
                MyDirNonRecursive me = this.createOrGet(file);
                if (vFile == null || !vFile.isValid()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    me.add(VcsUtil.getFilePath((VirtualFile)child));
                }
                continue;
            }
            FilePath parent = file.getParentPath();
            if (parent == null) continue;
            MyDirNonRecursive item = this.createOrGet(parent);
            item.add(file);
        }
    }

    @NotNull
    private MyDirNonRecursive createOrGet(@NotNull FilePath parent) {
        String key = SvnScopeZipper.getKey(parent);
        MyDirNonRecursive result = this.myNonRecursiveDirs.get(key);
        if (result == null) {
            result = new MyDirNonRecursive(parent);
            this.myNonRecursiveDirs.put(key, result);
        }
        return result;
    }

    @NotNull
    public List<FilePath> getRecursiveDirs() {
        return this.myRecursiveDirs;
    }

    @NotNull
    public Map<String, MyDirNonRecursive> getNonRecursiveDirs() {
        return this.myNonRecursiveDirs;
    }

    public static String getKey(@NotNull FilePath path) {
        return path.getPresentableUrl();
    }

    static class MyDirNonRecursive {
        @NotNull
        private final FilePath myDir;
        @NotNull
        private final Map<String, FilePath> myChildren;

        private MyDirNonRecursive(@NotNull FilePath dir) {
            this.myDir = dir;
            this.myChildren = ContainerUtil.newHashMap();
        }

        public void add(@NotNull FilePath path) {
            this.myChildren.put(SvnScopeZipper.getKey(path), path);
        }

        @NotNull
        public Collection<FilePath> getChildrenList() {
            return this.myChildren.values();
        }

        @NotNull
        public FilePath getDir() {
            return this.myDir;
        }
    }
}

