/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URI;
import java.nio.channels.NonWritableChannelException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SVNFileUtil.getAdminDirectoryName();
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String WC_DB_FILE_NAME = "wc.db";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    public static final int DEFAULT_PORT_INDICATOR = -1;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnUtil");
    public static final Pattern ERROR_PATTERN = Pattern.compile("^svn: (E(\\d+)): (.*)$", 8);
    public static final Pattern WARNING_PATTERN = Pattern.compile("^svn: warning: (W(\\d+)): (.*)$", 8);
    private static final Pair<SVNURL, WorkingCopyFormat> UNKNOWN_REPOSITORY_AND_FORMAT = Pair.create(null, (Object)((Object)WorkingCopyFormat.UNKNOWN));

    private SvnUtil() {
    }

    @Nullable
    public static SVNErrorMessage parseWarning(@NotNull String text) {
        Matcher matcher = WARNING_PATTERN.matcher(text);
        SVNErrorMessage error = null;
        if (matcher.find()) {
            error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.getErrorCode((int)Integer.parseInt(matcher.group(2))), (String)matcher.group(3), (int)1);
        }
        return error;
    }

    public static boolean isSvnVersioned(@NotNull SvnVcs vcs, @NotNull File file) {
        return vcs.getInfo(file) != null;
    }

    @NotNull
    public static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull File path, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path);
        return file != null ? SvnUtil.crawlWCRoots(vcs, file, callback, progress) : Collections.emptyList();
    }

    @NotNull
    private static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile parent;
        HashSet result = ContainerUtil.newHashSet();
        VirtualFile virtualFile = parent = !file.isDirectory() || !file.isValid() ? file.getParent() : file;
        if (SvnUtil.isSvnVersioned(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)parent))) {
            SvnUtil.checkCanceled(progress);
            callback.handleWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)file), progress);
            SvnUtil.checkCanceled(progress);
            result.add(parent);
        } else if (file.isDirectory()) {
            SvnUtil.checkCanceled(progress);
            for (VirtualFile child : parent.getChildren()) {
                SvnUtil.checkCanceled(progress);
                if (!child.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(vcs, child, callback, progress));
            }
        }
        return result;
    }

    private static void checkCanceled(@Nullable ProgressIndicator progress) {
        if (progress != null && progress.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    public static String getExactLocation(SvnVcs vcs, File path) {
        Info info = vcs.getInfo(path);
        return info != null && info.getURL() != null ? info.getURL().toString() : null;
    }

    @NotNull
    public static File[] toIoFiles(@NotNull VirtualFile[] files) {
        return (File[])ContainerUtil.map2Array((Object[])files, File.class, VfsUtilCore::virtualToIoFile);
    }

    public static void doLockFiles(Project project, final SvnVcs activeVcs, final @NotNull File[] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        if (activeVcs.getCheckoutOptions().getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles.length > 1);
            if (!dialog.showAndGet()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        final VcsException[] exception = new VcsException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.LOCK_FAILED) {
                    failedLocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                        }
                        activeVcs.getFactory(ioFile).createLockClient().lock(ioFile, force, lockMessage, eventHandler);
                    }
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            StringBuilder sb = new StringBuilder(SvnBundle.message("message.text.files.lock.failed", failedFiles.length == 1 ? 0 : 1));
            for (VcsException vcsException : exceptions) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(vcsException.getMessage());
            }
            throw new VcsException(sb.toString());
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static void doUnlockFiles(Project project, final SvnVcs activeVcs, final File[] ioFiles) throws VcsException {
        boolean force = true;
        final VcsException[] exception = new VcsException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.UNLOCK_FAILED) {
                    failedUnlocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                        }
                        activeVcs.getFactory(ioFile).createLockClient().unlock(ioFile, true, eventHandler);
                    }
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    @NotNull
    public static MultiMap<Pair<SVNURL, WorkingCopyFormat>, Change> splitChangesIntoWc(@NotNull SvnVcs vcs, @NotNull List<Change> changes) {
        return SvnUtil.splitIntoRepositoriesMap(vcs, changes, new Convertor<Change, FilePath>(){

            public FilePath convert(@NotNull Change change) {
                return ChangesUtil.getFilePath((Change)change);
            }
        });
    }

    @NotNull
    public static <T> MultiMap<Pair<SVNURL, WorkingCopyFormat>, T> splitIntoRepositoriesMap(final @NotNull SvnVcs vcs, @NotNull Collection<T> items, final @NotNull Convertor<T, FilePath> converter) {
        return ContainerUtil.groupBy(items, (NullableFunction)new NotNullFunction<T, Pair<SVNURL, WorkingCopyFormat>>(){

            @NotNull
            public Pair<SVNURL, WorkingCopyFormat> fun(@NotNull T item) {
                RootUrlInfo path = vcs.getSvnFileUrlMapping().getWcRootForFilePath(((FilePath)converter.convert(item)).getIOFile());
                return path == null ? UNKNOWN_REPOSITORY_AND_FORMAT : Pair.create((Object)path.getRepositoryUrlUrl(), (Object)((Object)path.getFormat()));
            }
        });
    }

    @NotNull
    public static WorkingCopyFormat getFormat(File path) {
        WorkingCopyFormat result = null;
        File dbFile = SvnUtil.resolveDatabase(path);
        if (dbFile != null && (result = (WorkingCopyFormat)((Object)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)(Registry.is((String)"svn.use.sqlite.jdbc") ? new SqLiteJdbcWorkingCopyFormatOperation(dbFile) : new WorkingCopyFormatOperation(dbFile))))) == null) {
            SvnUtil.notifyDatabaseError();
        }
        return result != null ? result : WorkingCopyFormat.UNKNOWN;
    }

    private static void close(@Nullable SqlJetDb db) {
        if (db != null) {
            try {
                db.close();
            }
            catch (SqlJetException e) {
                SvnUtil.notifyDatabaseError();
            }
        }
    }

    private static void notifyDatabaseError() {
        VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification("Some errors occurred while accessing svn working copy database.", NotificationType.ERROR).notify(null);
    }

    private static File resolveDatabase(File path) {
        File dbFile = SvnUtil.getWcDb(path);
        File result = null;
        try {
            if (dbFile.exists() && dbFile.isFile()) {
                result = dbFile;
            }
        }
        catch (SecurityException e) {
            LOG.error("Failed to access working copy database", (Throwable)e);
        }
        return result;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryUUID() : null;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, SVNURL url) {
        try {
            Info info = vcs.getInfo(url, SVNRevision.UNDEFINED);
            return info == null ? null : info.getRepositoryUUID();
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryRootURL() : null;
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SvnUtil.createUrl(url));
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, SVNURL url) throws SvnBindException {
        Info info = vcs.getInfo(url, SVNRevision.HEAD);
        return info == null ? null : info.getRepositoryRootURL();
    }

    public static boolean isWorkingCopyRoot(File file) {
        return FileUtil.filesEqual((File)file, (File)SvnUtil.getWorkingCopyRootNew(file));
    }

    @Nullable
    public static File getWorkingCopyRoot(File inFile) {
        File file;
        for (file = inFile; file != null && (file.isFile() || !file.exists()); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        File workingCopyRoot = null;
        try {
            workingCopyRoot = SVNWCUtil.getWorkingCopyRoot((File)file, (boolean)true);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (workingCopyRoot == null) {
            workingCopyRoot = SvnUtil.getWcCopyRootIf17(file, null);
        }
        return workingCopyRoot;
    }

    @NotNull
    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return new File(baseDir, part);
    }

    public static VirtualFile getVirtualFile(String filePath) {
        final String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(path);
            }
        });
    }

    @Nullable
    public static SVNURL getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull String urlValue) {
        SVNURL url = null;
        try {
            url = SvnUtil.createUrl(urlValue);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return url != null ? SvnUtil.getBranchForUrl(vcs, vcsRoot, url) : null;
    }

    @Nullable
    public static SVNURL getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull SVNURL url) {
        SVNURL result = null;
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
        try {
            result = configuration.getWorkingBranch(url);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    public static boolean checkRepositoryVersion15(@NotNull SvnVcs vcs, @NotNull String url) {
        boolean result = false;
        try {
            result = vcs.getFactory().createRepositoryFeaturesClient().supportsMergeTracking(SvnUtil.createUrl(url));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    @Nullable
    public static Status getStatus(@NotNull SvnVcs vcs, @NotNull File file) {
        try {
            return vcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @NotNull
    public static Depth getDepth(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null && info.getDepth() != null ? info.getDepth() : Depth.UNKNOWN;
    }

    public static boolean seemsLikeVersionedDir(VirtualFile file) {
        String adminName = SVNFileUtil.getAdminDirectoryName();
        VirtualFile child = file.findChild(adminName);
        return child != null && child.isDirectory();
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static SVNURL getUrl(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info == null ? null : info.getURL();
    }

    public static boolean remoteFolderIsEmpty(@NotNull SvnVcs vcs, @NotNull String url) throws VcsException {
        SvnTarget target = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(url));
        final Ref result = new Ref((Object)true);
        DirectoryEntryConsumer handler = new DirectoryEntryConsumer(){

            public void consume(DirectoryEntry entry) throws SVNException {
                if (entry != null) {
                    result.set((Object)false);
                }
            }
        };
        vcs.getFactory(target).createBrowseClient().list(target, null, Depth.IMMEDIATES, handler);
        return (Boolean)result.get();
    }

    public static File getWcDb(File file) {
        return new File(file, SVN_ADMIN_DIR_NAME + "/wc.db");
    }

    @Nullable
    public static File getWcCopyRootIf17(File file, @Nullable File upperBound) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return null;
        }
        while (current != null) {
            try {
                SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)current, (boolean)false);
                if (SvnWcGeneration.V17.equals((Object)svnWcGeneration)) {
                    return current;
                }
                if (SvnWcGeneration.V16.equals((Object)svnWcGeneration)) {
                    return null;
                }
                if (upperBound != null && FileUtil.filesEqual((File)upperBound, (File)current)) {
                    return null;
                }
                current = current.getParentFile();
            }
            catch (SVNException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static File getWorkingCopyRootNew(File file) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return SvnUtil.getWorkingCopyRoot(file);
        }
        WorkingCopyFormat format = SvnUtil.getFormat(current);
        return format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? current : SvnUtil.getWorkingCopyRoot(file);
    }

    private static File getParentWithDb(File file) {
        File current;
        boolean wcDbFound = false;
        for (current = file; current != null; current = current.getParentFile()) {
            File wcDb = SvnUtil.getWcDb(current);
            if (!wcDb.exists() || wcDb.isDirectory()) continue;
            wcDbFound = true;
            break;
        }
        if (!wcDbFound) {
            return null;
        }
        return current;
    }

    public static String getRelativeUrl(@NotNull String parentUrl, @NotNull String childUrl) {
        return FileUtilRt.getRelativePath((String)parentUrl, (String)childUrl, (char)'/', (boolean)true);
    }

    public static String getRelativePath(@NotNull String parentPath, @NotNull String childPath) {
        return FileUtilRt.getRelativePath((String)FileUtil.toSystemIndependentName((String)parentPath), (String)FileUtil.toSystemIndependentName((String)childPath), (char)'/');
    }

    @NotNull
    @Contract(pure=true)
    public static String ensureStartSlash(@NotNull String path) {
        return StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path : '/' + path;
    }

    @NotNull
    public static String join(String ... parts) {
        return StringUtil.join((String[])parts, (String)"/");
    }

    public static String appendMultiParts(@NotNull String base, @NotNull String subPath) {
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        String result = base;
        for (String part : parts) {
            result = SVNPathUtil.append((String)result, (String)part);
        }
        return result;
    }

    public static SVNURL appendMultiParts(@NotNull SVNURL base, @NotNull String subPath) throws SVNException {
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        SVNURL result = base;
        for (String part : parts) {
            result = result.appendPath(part, false);
        }
        return result;
    }

    @NotNull
    public static SVNURL removePathTail(@NotNull SVNURL url) throws SvnBindException {
        return SvnUtil.createUrl(SVNPathUtil.removeTail((String)url.toDecodedString()));
    }

    @NotNull
    public static SVNRevision getHeadRevision(@NotNull SvnVcs vcs, @NotNull SVNURL url) throws SvnBindException {
        Info info = vcs.getInfo(url, SVNRevision.HEAD);
        if (info == null) {
            throw new SvnBindException("Could not get info for " + url);
        }
        if (info.getRevision() == null) {
            throw new SvnBindException("Could not get revision for " + url);
        }
        return info.getRevision();
    }

    public static byte[] getFileContents(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNRevision pegRevision) throws VcsException {
        return vcs.getFactory(target).createContentClient().getContent(target, revision, pegRevision);
    }

    public static boolean hasDefaultPort(@NotNull SVNURL result) {
        return !result.hasPort() || SVNURL.getDefaultPortNumber((String)result.getProtocol()) == result.getPort();
    }

    public static int resolvePort(@NotNull SVNURL url) {
        return !SvnUtil.hasDefaultPort(url) ? url.getPort() : -1;
    }

    @NotNull
    public static SVNURL createUrl(@NotNull String url) throws SvnBindException {
        return SvnUtil.createUrl(url, true);
    }

    @NotNull
    public static SVNURL createUrl(@NotNull String url, boolean encoded) throws SvnBindException {
        try {
            SVNURL result;
            SVNURL sVNURL = result = encoded ? SVNURL.parseURIEncoded((String)url) : SVNURL.parseURIDecoded((String)url);
            if (result.hasPort() && SvnUtil.hasDefaultPort(result)) {
                result = SVNURL.create((String)result.getProtocol(), (String)result.getUserInfo(), (String)result.getHost(), (int)-1, (String)result.getURIEncodedPath(), (boolean)true);
            }
            return result;
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    public static SVNURL parseUrl(@NotNull String url) {
        try {
            return SVNURL.parseURIEncoded((String)url);
        }
        catch (SVNException e) {
            throw SvnUtil.createIllegalArgument(e);
        }
    }

    @NotNull
    public static SVNURL append(@NotNull SVNURL parent, @NotNull String child) throws SvnBindException {
        try {
            return parent.appendPath(child, false);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    public static IllegalArgumentException createIllegalArgument(SVNException e) {
        IllegalArgumentException runtimeException = new IllegalArgumentException();
        runtimeException.initCause(e);
        return runtimeException;
    }

    @Nullable
    public static String getChangelistName(@NotNull Status status) {
        return status.getKind().isFile() ? status.getChangelistName() : null;
    }

    public static boolean isUnversionedOrNotFound(@NotNull SvnBindException e) {
        return e.contains(SVNErrorCode.WC_PATH_NOT_FOUND) || e.contains(SVNErrorCode.UNVERSIONED_RESOURCE) || e.contains(SVNErrorCode.WC_NOT_WORKING_COPY) || e.contains(SVNErrorCode.ILLEGAL_TARGET) || StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"(not a versioned resource)");
    }

    @NotNull
    public static SvnTarget append(@NotNull SvnTarget target, @NotNull String path) throws SvnBindException {
        return SvnUtil.append(target, path, false);
    }

    @NotNull
    public static SvnTarget append(@NotNull SvnTarget target, @NotNull String path, boolean checkAbsolute) throws SvnBindException {
        SvnTarget result;
        if (target.isFile()) {
            result = SvnTarget.fromFile((File)SvnUtil.resolvePath(target.getFile(), path));
        } else {
            try {
                result = SvnTarget.fromURL((SVNURL)(checkAbsolute && URI.create(path).isAbsolute() ? SVNURL.parseURIEncoded((String)path) : target.getURL().appendPath(path, false)));
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
        }
        return result;
    }

    @NotNull
    public static File resolvePath(@NotNull File base, @NotNull String path) {
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = ".".equals(path) ? base : new File(base, path);
        }
        return result;
    }

    @NotNull
    public static String toDecodedString(@NotNull SvnTarget target) {
        return target.isFile() ? target.getFile().getPath() : target.getURL().toDecodedString();
    }

    private static class SqLiteDb
    extends SqlJetDb {
        private SqLiteDb(@NotNull File file, boolean writable) {
            super(file, writable);
        }

        @NotNull
        public static SqLiteDb open(@NotNull File file, boolean write) throws SqlJetException {
            SqLiteDb db = new SqLiteDb(file, write);
            db.open();
            return db;
        }

        private int getUserVersion() {
            int result = 0;
            ISqlJetOptions options = this.dbHandle.getOptions();
            if (options != null) {
                try {
                    result = options.getUserVersion();
                }
                catch (SqlJetException sqlJetException) {
                    // empty catch block
                }
            }
            return result;
        }

        @NotNull
        private String getDbSchema() {
            String result = "";
            try {
                result = (String)this.runSynchronized(new ISqlJetEngineSynchronized(){

                    public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                        btree.enter();
                        try {
                            String string = this.readDbSchema();
                            return string;
                        }
                        finally {
                            btree.leave();
                        }
                    }
                });
            }
            catch (SqlJetException sqlJetException) {
                // empty catch block
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private String readDbSchema() throws SqlJetException {
            StringBuilder result = new StringBuilder();
            try (SqlJetBtreeSchemaTable table = new SqlJetBtreeSchemaTable(this.btree, false);){
                table.lock();
                try {
                    table.first();
                    while (!table.eof()) {
                        String sql = table.getSqlField();
                        if (sql != null) {
                            result.append(sql);
                            result.append("\n");
                        }
                        table.next();
                    }
                }
                finally {
                    table.unlock();
                }
            }
            return result.toString();
        }
    }

    private static class SqLiteJdbcWorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        @NotNull
        private final File myDbFile;

        public SqLiteJdbcWorkingCopyFormatOperation(@NotNull File dbFile) {
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            Connection connection = null;
            int userVersion = 0;
            try {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + FileUtil.toSystemIndependentName((String)this.myDbFile.getPath()));
                ResultSet resultSet = connection.createStatement().executeQuery("pragma user_version");
                if (resultSet.next()) {
                    userVersion = resultSet.getInt(1);
                } else {
                    LOG.info("No result while getting user version for " + this.myDbFile.getPath());
                }
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            catch (ClassNotFoundException | SQLException e) {
                LOG.info((Throwable)e);
            }
            finally {
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            WorkingCopyFormat format = WorkingCopyFormat.getInstance(userVersion);
            return !WorkingCopyFormat.UNKNOWN.equals((Object)format) ? format : null;
        }

        private static void close(@Nullable Connection connection) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    SvnUtil.notifyDatabaseError();
                }
            }
        }
    }

    private static class WorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        @NotNull
        private final File myDbFile;

        public WorkingCopyFormatOperation(@NotNull File dbFile) {
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            SqLiteDb db = null;
            int userVersion = 0;
            try {
                db = SqLiteDb.open(this.myDbFile, true);
                userVersion = db.getOptions().getUserVersion();
            }
            catch (NonWritableChannelException e) {
                LOG.info((Throwable)e);
                SvnUtil.close(db);
            }
            catch (SqlJetException e2) {
                block6: {
                    LOG.info((Throwable)e2);
                    if (db == null) break block6;
                    userVersion = db.getUserVersion();
                    LOG.debug("Working copy database schema: " + db.getDbSchema());
                    {
                        catch (Throwable throwable) {
                            SvnUtil.close(db);
                            throw throwable;
                        }
                    }
                }
                SvnUtil.close(db);
            }
            SvnUtil.close(db);
            WorkingCopyFormat format = WorkingCopyFormat.getInstance(userVersion);
            return !WorkingCopyFormat.UNKNOWN.equals((Object)format) ? format : null;
        }
    }
}

