/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class RemoveFromIgnoreListAction
extends BasicAction {
    private String myActionName;
    private final boolean myUseCommonExtension;
    @NotNull
    private final IgnoreInfoGetter myInfoGetter;

    public RemoveFromIgnoreListAction(boolean useCommonExtension, @NotNull IgnoreInfoGetter getter) {
        this.myUseCommonExtension = useCommonExtension;
        this.myInfoGetter = getter;
    }

    public void setActionText(String name) {
        this.myActionName = name;
    }

    @Override
    @NotNull
    protected String getActionName() {
        return SvnBundle.message("action.name.undo.ignore.files", new Object[0]);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(true);
        presentation.setText(this.myActionName);
        presentation.setDescription(SvnBundle.message("action.Subversion.UndoIgnore.description", new Object[0]));
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return true;
    }

    @Override
    protected void doVcsRefresh(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)vcs.getProject());
        if (file.getParent() != null) {
            vcsDirtyScopeManager.fileDirty(file.getParent());
        }
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) throws VcsException {
        SvnPropertyService.doRemoveFromIgnoreProperty(vcs, this.myUseCommonExtension, files, this.myInfoGetter);
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

