/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class ShowPropertiesDiffAction
extends AnAction
implements DumbAware {
    private static final String ourPropertiesDelimiter = "\n";

    public void update(@NotNull AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        boolean showAction = ShowPropertiesDiffAction.checkThatChangesAreUnderSvn(changes);
        e.getPresentation().setVisible(changes != null && showAction);
        e.getPresentation().setEnabled(showAction);
    }

    private static boolean checkThatChangesAreUnderSvn(@Nullable Change[] changes) {
        return changes != null && ContainerUtil.exists((Object[])changes, change -> ShowPropertiesDiffAction.isUnderSvn(change.getBeforeRevision()) || ShowPropertiesDiffAction.isUnderSvn(change.getAfterRevision()));
    }

    private static boolean isUnderSvn(@Nullable ContentRevision revision) {
        return revision instanceof SvnBaseContentRevision;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGE_LEAD_SELECTION);
        if (ShowPropertiesDiffAction.checkThatChangesAreUnderSvn(changes)) {
            new CalculateAndShow(e.getProject(), changes[0], e.getPresentation().getText()).queue();
        }
    }

    @NotNull
    private static SVNRevision getBeforeRevisionValue(@NotNull Change change) throws SVNException {
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null) {
            return ((SvnRevisionNumber)beforeRevision.getRevisionNumber()).getRevision();
        }
        return SVNRevision.create((long)(((SvnRevisionNumber)((ContentRevision)ObjectUtils.notNull((Object)change.getAfterRevision())).getRevisionNumber()).getRevision().getNumber() - 1L));
    }

    @NotNull
    private static SVNRevision getAfterRevisionValue(@NotNull Change change) throws SVNException {
        ContentRevision afterRevision = change.getAfterRevision();
        if (afterRevision != null) {
            return afterRevision instanceof CurrentContentRevision ? SVNRevision.WORKING : ((SvnRevisionNumber)afterRevision.getRevisionNumber()).getRevision();
        }
        return SVNRevision.create((long)(((SvnRevisionNumber)((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getRevisionNumber()).getRevision().getNumber() + 1L));
    }

    @NotNull
    private static String getDiffWindowTitle(@NotNull Change change) {
        if (change.isMoved() || change.isRenamed()) {
            FilePath beforeFilePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterFilePath = ChangesUtil.getAfterPath((Change)change);
            String beforePath = beforeFilePath == null ? "" : beforeFilePath.getPath();
            String afterPath = afterFilePath == null ? "" : afterFilePath.getPath();
            return SvnBundle.message("action.Subversion.properties.difference.diff.for.move.title", beforePath, afterPath);
        }
        return SvnBundle.message("action.Subversion.properties.difference.diff.title", ChangesUtil.getFilePath((Change)change).getPath());
    }

    private static int compareRevisions(@NotNull SVNRevision revision1, @NotNull SVNRevision revision2) {
        if (revision1.equals((Object)revision2)) {
            return 0;
        }
        if (SVNRevision.WORKING.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.WORKING.equals((Object)revision2)) {
            return -1;
        }
        if (SVNRevision.HEAD.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.HEAD.equals((Object)revision2)) {
            return -1;
        }
        return revision1.getNumber() > revision2.getNumber() ? 1 : -1;
    }

    @NotNull
    private static String revisionToString(@Nullable SVNRevision revision) {
        return revision == null ? "not exists" : revision.toString();
    }

    @NotNull
    private static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @Nullable ContentRevision contentRevision, @Nullable SVNRevision revision) throws SVNException, VcsException {
        SvnTarget target;
        if (contentRevision == null) {
            return Collections.emptyList();
        }
        if (contentRevision instanceof SvnRepositoryContentRevision) {
            SvnRepositoryContentRevision svnRevision = (SvnRepositoryContentRevision)contentRevision;
            target = SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)svnRevision.getFullPath()), (SVNRevision)revision);
        } else {
            File ioFile = contentRevision.getFile().getIOFile();
            target = SvnTarget.fromFile((File)ioFile, (SVNRevision)revision);
        }
        return ShowPropertiesDiffAction.getPropertyList(vcs, target, revision);
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull SVNURL url, @Nullable SVNRevision revision) throws VcsException {
        return ShowPropertiesDiffAction.getPropertyList(vcs, SvnTarget.fromURL((SVNURL)url, (SVNRevision)revision), revision);
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull File ioFile, @Nullable SVNRevision revision) throws SVNException {
        try {
            return ShowPropertiesDiffAction.getPropertyList(vcs, SvnTarget.fromFile((File)ioFile, (SVNRevision)revision), revision);
        }
        catch (VcsException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (Throwable)e), (Throwable)e);
        }
    }

    @NotNull
    private static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable SVNRevision revision) throws VcsException {
        ArrayList<PropertyData> lines = new ArrayList<PropertyData>();
        PropertyConsumer propertyHandler = ShowPropertiesDiffAction.createHandler(revision, lines);
        vcs.getFactory(target).createPropertyClient().list(target, revision, Depth.EMPTY, propertyHandler);
        return lines;
    }

    @NotNull
    private static PropertyConsumer createHandler(SVNRevision revision, final @NotNull List<PropertyData> lines) {
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        return new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }

            private void registerProperty(@NotNull PropertyData property) {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }
        };
    }

    @NotNull
    public static String toSortedStringPresentation(@NotNull List<PropertyData> lines) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(lines, Comparator.comparing(PropertyData::getName));
        for (PropertyData line : lines) {
            ShowPropertiesDiffAction.addPropertyPresentation(line, sb);
        }
        return sb.toString();
    }

    private static void addPropertyPresentation(@NotNull PropertyData property, @NotNull StringBuilder sb) {
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(StringUtil.notNullize((String)PropertyValue.toString(property.getValue())));
    }

    private static class CalculateAndShow
    extends Task.Backgroundable {
        private final Change myChange;
        private List<PropertyData> myBeforeContent;
        private List<PropertyData> myAfterContent;
        private SVNRevision myBeforeRevisionValue;
        private SVNRevision myAfterRevision;
        private Exception myException;
        private final String myErrorTitle;

        private CalculateAndShow(@Nullable Project project, Change change, String errorTitle) {
            super(project, SvnBundle.message("fetching.properties.contents.progress.title", new Object[0]), true, PerformInBackgroundOption.DEAF);
            this.myChange = change;
            this.myErrorTitle = errorTitle;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            try {
                this.myBeforeRevisionValue = ShowPropertiesDiffAction.getBeforeRevisionValue(this.myChange);
                this.myAfterRevision = ShowPropertiesDiffAction.getAfterRevisionValue(this.myChange);
                this.myBeforeContent = ShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getBeforeRevision(), this.myBeforeRevisionValue);
                indicator.checkCanceled();
                this.myAfterContent = ShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getAfterRevision(), this.myAfterRevision);
            }
            catch (VcsException | SVNException exc) {
                this.myException = exc;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                Messages.showErrorDialog((String)this.myException.getMessage(), (String)this.myErrorTitle);
                return;
            }
            if (this.myBeforeContent != null && this.myAfterContent != null && this.myBeforeRevisionValue != null && this.myAfterRevision != null) {
                SvnPropertiesDiffRequest diffRequest = ShowPropertiesDiffAction.compareRevisions(this.myBeforeRevisionValue, this.myAfterRevision) > 0 ? new SvnPropertiesDiffRequest(ShowPropertiesDiffAction.getDiffWindowTitle(this.myChange), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myAfterContent), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myBeforeContent), ShowPropertiesDiffAction.revisionToString(this.myAfterRevision), ShowPropertiesDiffAction.revisionToString(this.myBeforeRevisionValue)) : new SvnPropertiesDiffRequest(ShowPropertiesDiffAction.getDiffWindowTitle(this.myChange), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myBeforeContent), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myAfterContent), ShowPropertiesDiffAction.revisionToString(this.myBeforeRevisionValue), ShowPropertiesDiffAction.revisionToString(this.myAfterRevision));
                DiffManager.getInstance().showDiff(this.myProject, (DiffRequest)diffRequest);
            }
        }
    }
}

