/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.VcsAnnotation;
import com.intellij.openapi.vcs.annotate.VcsCacheableAnnotationProvider;
import com.intellij.openapi.vcs.annotate.VcsLineAnnotationData;
import com.intellij.openapi.vcs.annotate.VcsRareLineAnnotationData;
import com.intellij.openapi.vcs.annotate.VcsUsualLineAnnotationData;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.annotate.AnnotationConsumer;
import org.jetbrains.idea.svn.annotate.BaseSvnFileAnnotation;
import org.jetbrains.idea.svn.annotate.SvnFileAnnotation;
import org.jetbrains.idea.svn.annotate.SvnRemoteFileAnnotation;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnAnnotationProvider
implements AnnotationProvider,
VcsCacheableAnnotationProvider {
    private static final Object MERGED_KEY = new Object();
    private final SvnVcs myVcs;

    public SvnAnnotationProvider(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public FileAnnotation annotate(VirtualFile file) throws VcsException {
        SvnDiffProvider provider = (SvnDiffProvider)this.myVcs.getDiffProvider();
        SVNRevision currentRevision = ((SvnRevisionNumber)provider.getCurrentRevision(file)).getRevision();
        VcsRevisionDescription lastChangedRevision = provider.getCurrentRevisionDescription(file);
        if (lastChangedRevision == null) {
            throw new VcsException("Can not get current revision for file " + file.getPath());
        }
        SVNRevision svnRevision = ((SvnRevisionNumber)lastChangedRevision.getRevisionNumber()).getRevision();
        if (!svnRevision.isValid()) {
            throw new VcsException("Can not get last changed revision for file: " + file.getPath() + "\nPlease run svn info for this file and file an issue.");
        }
        return this.annotate(file, new SvnFileRevision(this.myVcs, currentRevision, currentRevision, null, null, null, null, null), lastChangedRevision.getRevisionNumber(), true);
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision revision) throws VcsException {
        return this.annotate(file, revision, revision.getRevisionNumber(), false);
    }

    private FileAnnotation annotate(final VirtualFile file, final VcsFileRevision revision, final VcsRevisionNumber lastChangedRevision, final boolean loadExternally) throws VcsException {
        if (file.isDirectory()) {
            throw new VcsException(SvnBundle.message("exception.text.cannot.annotate.directory", new Object[0]));
        }
        final FileAnnotation[] annotation = new FileAnnotation[1];
        final VcsException[] exception = new VcsException[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                File ioFile = new File(file.getPath()).getAbsoluteFile();
                Info info = null;
                try {
                    String contents;
                    if (loadExternally) {
                        byte[] data = SvnUtil.getFileContents(SvnAnnotationProvider.this.myVcs, SvnTarget.fromFile((File)ioFile), SVNRevision.BASE, SVNRevision.UNDEFINED);
                        contents = LoadTextUtil.getTextByBinaryPresentation((byte[])data, (VirtualFile)file, (boolean)false, (boolean)false).toString();
                    } else {
                        byte[] bytes = VcsHistoryUtil.loadRevisionContent((VcsFileRevision)revision);
                        contents = LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (VirtualFile)file, (boolean)false, (boolean)false).toString();
                    }
                    SvnFileAnnotation result = new SvnFileAnnotation(SvnAnnotationProvider.this.myVcs, file, contents, lastChangedRevision);
                    info = SvnAnnotationProvider.this.myVcs.getInfo(ioFile);
                    if (info == null) {
                        exception[0] = new VcsException((Throwable)new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"File ''{0}'' is not under version control", (Object)ioFile)));
                        return;
                    }
                    String url = info.getURL() == null ? null : info.getURL().toString();
                    SVNRevision endRevision = ((SvnFileRevision)revision).getRevision();
                    if (SVNRevision.WORKING.equals((Object)endRevision)) {
                        endRevision = info.getRevision();
                    }
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.computing.annotation", file.getName()));
                    }
                    AnnotationConsumer annotateHandler = SvnAnnotationProvider.createAnnotationHandler(progress, result);
                    boolean calculateMergeinfo = SvnAnnotationProvider.this.myVcs.getSvnConfiguration().isShowMergeSourcesInAnnotate() && SvnUtil.checkRepositoryVersion15(SvnAnnotationProvider.this.myVcs, url);
                    MySteppedLogGetter logGetter = new MySteppedLogGetter(SvnAnnotationProvider.this.myVcs, ioFile, progress, SvnAnnotationProvider.this.myVcs.getFactory(ioFile).createHistoryClient(), endRevision, result, url, calculateMergeinfo, file.getCharset());
                    logGetter.go();
                    LinkedList<SVNRevision> rp = logGetter.getRevisionPoints();
                    AnnotateClient annotateClient = SvnAnnotationProvider.this.myVcs.getFactory(ioFile).createAnnotateClient();
                    for (int i = 0; i < rp.size() - 1; ++i) {
                        annotateClient.annotate(SvnTarget.fromFile((File)ioFile), rp.get(i + 1), rp.get(i), calculateMergeinfo, SvnAnnotationProvider.getLogClientOptions(SvnAnnotationProvider.this.myVcs), annotateHandler);
                    }
                    if (rp.get(1).getNumber() > 0L) {
                        result.setFirstRevision(rp.get(1));
                    }
                    annotation[0] = result;
                }
                catch (IOException e) {
                    exception[0] = new VcsException((Throwable)e);
                }
                catch (VcsException e) {
                    if (e.getCause() instanceof SVNException) {
                        SvnAnnotationProvider.this.handleSvnException(ioFile, info, (SVNException)e.getCause(), file, revision, annotation, exception);
                    }
                    exception[0] = e;
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("action.text.annotate", new Object[0]), false, this.myVcs.getProject());
        } else {
            command.run();
        }
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
        return annotation[0];
    }

    private void handleSvnException(File ioFile, Info info, SVNException e, VirtualFile file, VcsFileRevision revision, FileAnnotation[] annotation, VcsException[] exception) {
        if (SVNErrorCode.FS_NOT_FOUND.equals((Object)e.getErrorMessage().getErrorCode())) {
            CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> provider = this.myVcs.getCommittedChangesProvider();
            try {
                Pair pair = provider.getOneList(file, revision.getRevisionNumber());
                if (pair != null && info != null && pair.getSecond() != null && !Comparing.equal((Object)((FilePath)pair.getSecond()).getIOFile(), (Object)ioFile)) {
                    annotation[0] = this.annotateNonExisting((Pair<SvnChangeList, FilePath>)pair, revision, info, file.getCharset(), file);
                    return;
                }
            }
            catch (VcsException e1) {
                exception[0] = e1;
            }
            catch (IOException | SVNException e1) {
                exception[0] = new VcsException((Throwable)e);
            }
        }
        exception[0] = new VcsException((Throwable)e);
    }

    public static File getCommonAncestor(File file1, File file2) throws IOException {
        if (FileUtil.filesEqual((File)file1, (File)file2)) {
            return file1;
        }
        File can1 = file1.getCanonicalFile();
        File can2 = file2.getCanonicalFile();
        List parts1 = StringUtil.split((String)can1.getPath(), (String)File.separator, (boolean)true);
        List parts2 = StringUtil.split((String)can2.getPath(), (String)File.separator, (boolean)true);
        for (int cnt = 0; parts1.size() > cnt && parts2.size() > cnt; ++cnt) {
            if (((String)parts1.get(cnt)).equals(parts2.get(cnt))) continue;
            if (cnt > 0) {
                return new File(StringUtil.join(parts1.subList(0, cnt), (String)File.separator));
            }
            return null;
        }
        if (parts1.size() > parts2.size()) {
            return file2;
        }
        return file1;
    }

    private SvnRemoteFileAnnotation annotateNonExisting(Pair<SvnChangeList, FilePath> pair, VcsFileRevision revision, Info info, Charset charset, VirtualFile current) throws VcsException, SVNException, IOException {
        String[] strings;
        File wasFile = ((FilePath)pair.getSecond()).getIOFile();
        File root = SvnAnnotationProvider.getCommonAncestor(wasFile, info.getFile());
        if (root == null) {
            throw new VcsException("Can not find relative path for " + wasFile.getPath() + "@" + revision.getRevisionNumber().asString());
        }
        String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)wasFile.getPath(), (char)File.separatorChar);
        if (relativePath == null) {
            throw new VcsException("Can not find relative path for " + wasFile.getPath() + "@" + revision.getRevisionNumber().asString());
        }
        Info wcRootInfo = this.myVcs.getInfo(root);
        if (wcRootInfo == null || wcRootInfo.getURL() == null) {
            throw new VcsException("Can not find relative path for " + wasFile.getPath() + "@" + revision.getRevisionNumber().asString());
        }
        SVNURL wasUrl = wcRootInfo.getURL();
        for (String string : strings = relativePath.replace('\\', '/').split("/")) {
            wasUrl = wasUrl.appendPath(string, true);
        }
        SVNRevision svnRevision = ((SvnRevisionNumber)revision.getRevisionNumber()).getRevision();
        byte[] data = SvnUtil.getFileContents(this.myVcs, SvnTarget.fromURL((SVNURL)wasUrl), svnRevision, svnRevision);
        String contents = LoadTextUtil.getTextByBinaryPresentation((byte[])data, (Charset)(charset == null ? CharsetToolkit.UTF8_CHARSET : charset)).toString();
        SvnRemoteFileAnnotation result = new SvnRemoteFileAnnotation(this.myVcs, contents, revision.getRevisionNumber(), current);
        AnnotationConsumer annotateHandler = SvnAnnotationProvider.createAnnotationHandler(ProgressManager.getInstance().getProgressIndicator(), result);
        boolean calculateMergeinfo = this.myVcs.getSvnConfiguration().isShowMergeSourcesInAnnotate() && SvnUtil.checkRepositoryVersion15(this.myVcs, wasUrl.toString());
        AnnotateClient client = this.myVcs.getFactory().createAnnotateClient();
        client.annotate(SvnTarget.fromURL((SVNURL)wasUrl, (SVNRevision)svnRevision), SVNRevision.create((long)1L), svnRevision, calculateMergeinfo, SvnAnnotationProvider.getLogClientOptions(this.myVcs), annotateHandler);
        return result;
    }

    @NotNull
    private static AnnotationConsumer createAnnotationHandler(final @Nullable ProgressIndicator progress, final @NotNull BaseSvnFileAnnotation result) {
        return new AnnotationConsumer(){

            @Override
            public void consume(int lineNumber, @NotNull CommitInfo info, @Nullable CommitInfo mergeInfo) throws SVNException {
                if (progress != null) {
                    progress.checkCanceled();
                }
                result.setLineInfo(lineNumber, info, mergeInfo != null && info.getRevision() > mergeInfo.getRevision() ? mergeInfo : null);
            }
        };
    }

    public VcsAnnotation createCacheable(FileAnnotation fileAnnotation) {
        if (!(fileAnnotation instanceof SvnFileAnnotation)) {
            return null;
        }
        SvnFileAnnotation svnFileAnnotation = (SvnFileAnnotation)fileAnnotation;
        AnnotationSourceSwitcher annotationSourceSwitcher = svnFileAnnotation.getAnnotationSourceSwitcher();
        if (annotationSourceSwitcher != null) {
            annotationSourceSwitcher.switchTo(AnnotationSource.LOCAL);
        }
        int size = svnFileAnnotation.getLineCount();
        VcsUsualLineAnnotationData lineAnnotationData = new VcsUsualLineAnnotationData(size);
        for (int i = 0; i < size; ++i) {
            VcsRevisionNumber revisionNumber = svnFileAnnotation.getLineRevisionNumber(i);
            lineAnnotationData.put(i, revisionNumber);
        }
        VcsAnnotation vcsAnnotation = new VcsAnnotation(VcsUtil.getFilePath((VirtualFile)svnFileAnnotation.getFile()), (VcsLineAnnotationData)lineAnnotationData, (VcsRevisionNumber)svnFileAnnotation.getFirstRevisionNumber());
        if (annotationSourceSwitcher != null) {
            VcsRareLineAnnotationData merged = new VcsRareLineAnnotationData(size);
            HashMap<VcsRevisionNumber, SvnFileRevision> addMap = new HashMap<VcsRevisionNumber, SvnFileRevision>();
            annotationSourceSwitcher.switchTo(AnnotationSource.MERGE);
            for (int i = 0; i < size; ++i) {
                VcsRevisionNumber number;
                if (!annotationSourceSwitcher.mergeSourceAvailable(i) || (number = svnFileAnnotation.getLineRevisionNumber(i)) == null) continue;
                merged.put(i, number);
                addMap.put(number, svnFileAnnotation.getRevision(((SvnRevisionNumber)number).getRevision().getNumber()));
            }
            if (!merged.isEmpty()) {
                vcsAnnotation.addAnnotation(MERGED_KEY, (VcsLineAnnotationData)merged);
                vcsAnnotation.addCachedOtherRevisions(addMap);
            }
        }
        return vcsAnnotation;
    }

    @Nullable
    public FileAnnotation restore(@NotNull VcsAnnotation vcsAnnotation, @NotNull VcsAbstractHistorySession session, @NotNull String annotatedContent, boolean forCurrentRevision, VcsRevisionNumber revisionNumber) {
        SvnFileAnnotation annotation = new SvnFileAnnotation(this.myVcs, vcsAnnotation.getFilePath().getVirtualFile(), annotatedContent, revisionNumber);
        VcsLineAnnotationData basicAnnotation = vcsAnnotation.getBasicAnnotation();
        VcsLineAnnotationData data = (VcsLineAnnotationData)vcsAnnotation.getAdditionalAnnotations().get(MERGED_KEY);
        Map historyAsMap = session.getHistoryAsMap();
        Map cachedOtherRevisions = vcsAnnotation.getCachedOtherRevisions();
        for (int i = 0; i < basicAnnotation.getNumLines(); ++i) {
            VcsRevisionNumber revision = basicAnnotation.getRevision(i);
            VcsRevisionNumber mergedData = data == null ? null : data.getRevision(i);
            SvnFileRevision fileRevision = (SvnFileRevision)historyAsMap.get(revision);
            if (fileRevision == null) {
                return null;
            }
            if (mergedData == null) {
                annotation.setLineInfo(i, fileRevision.getCommitInfo(), null);
                continue;
            }
            SvnFileRevision mergedRevision = (SvnFileRevision)cachedOtherRevisions.get(mergedData);
            if (mergedRevision == null) {
                return null;
            }
            annotation.setLineInfo(i, fileRevision.getCommitInfo(), mergedRevision.getCommitInfo());
        }
        if (vcsAnnotation.getFirstRevision() != null) {
            annotation.setFirstRevision(((SvnRevisionNumber)vcsAnnotation.getFirstRevision()).getRevision());
        }
        for (VcsRevisionNumber revision : session.getRevisionList()) {
            annotation.setRevision(((SvnRevisionNumber)revision.getRevisionNumber()).getRevision().getNumber(), (SvnFileRevision)revision);
        }
        return annotation;
    }

    @Nullable
    private static DiffOptions getLogClientOptions(@NotNull SvnVcs vcs) {
        return vcs.getSvnConfiguration().isIgnoreSpacesInAnnotate() ? new DiffOptions(true, true, true) : null;
    }

    private static class MySteppedLogGetter {
        private final LinkedList<SVNRevision> myRevisionPoints;
        private final SvnVcs myVcs;
        private final File myIoFile;
        private final ProgressIndicator myProgress;
        private final HistoryClient myClient;
        private final SVNRevision myEndRevision;
        private final boolean myCalculateMergeinfo;
        private final SvnFileAnnotation myResult;
        private final String myUrl;
        private final Charset myCharset;

        private MySteppedLogGetter(SvnVcs vcs, File ioFile, ProgressIndicator progress, HistoryClient client, SVNRevision endRevision, SvnFileAnnotation result, String url, boolean calculateMergeinfo, Charset charset) {
            this.myVcs = vcs;
            this.myIoFile = ioFile;
            this.myProgress = progress;
            this.myClient = client;
            this.myEndRevision = endRevision;
            this.myCalculateMergeinfo = calculateMergeinfo;
            this.myResult = result;
            this.myUrl = url;
            this.myCharset = charset;
            this.myRevisionPoints = new LinkedList();
        }

        public void go() throws VcsException {
            int maxAnnotateRevisions = this.myVcs.getSvnConfiguration().getMaxAnnotateRevisions();
            boolean longHistory = true;
            if (maxAnnotateRevisions == -1) {
                longHistory = false;
            } else if (this.myEndRevision.getNumber() < (long)maxAnnotateRevisions) {
                longHistory = false;
            }
            if (!longHistory) {
                this.doLog(this.myCalculateMergeinfo, null, 0);
                this.putDefaultBounds();
            } else {
                this.doLog(false, null, 0);
                List<VcsFileRevision> fileRevisionList = this.myResult.getRevisions();
                if (fileRevisionList.size() < maxAnnotateRevisions) {
                    this.putDefaultBounds();
                    if (this.myCalculateMergeinfo) {
                        this.doLog(true, null, 0);
                    }
                    return;
                }
                this.myRevisionPoints.add(((SvnRevisionNumber)fileRevisionList.get(0).getRevisionNumber()).getRevision());
                SVNRevision truncateTo = ((SvnRevisionNumber)fileRevisionList.get(maxAnnotateRevisions - 1).getRevisionNumber()).getRevision();
                this.myRevisionPoints.add(truncateTo);
                if (this.myCalculateMergeinfo) {
                    this.doLog(true, truncateTo, maxAnnotateRevisions);
                }
            }
        }

        private void putDefaultBounds() {
            this.myRevisionPoints.add(this.myEndRevision);
            this.myRevisionPoints.add(SVNRevision.create((long)0L));
        }

        private void doLog(boolean includeMerged, SVNRevision truncateTo, int max) throws VcsException {
            this.myClient.doLog(SvnTarget.fromFile((File)this.myIoFile), this.myEndRevision, truncateTo == null ? SVNRevision.create((long)1L) : truncateTo, false, false, includeMerged, max, null, new LogEntryConsumer(){

                public void consume(LogEntry logEntry) {
                    if (SVNRevision.UNDEFINED.getNumber() == logEntry.getRevision()) {
                        return;
                    }
                    if (myProgress != null) {
                        myProgress.checkCanceled();
                        myProgress.setText2(SvnBundle.message("progress.text2.revision.processed", logEntry.getRevision()));
                    }
                    myResult.setRevision(logEntry.getRevision(), new SvnFileRevision(myVcs, SVNRevision.UNDEFINED, logEntry, myUrl, ""));
                }
            });
        }

        public LinkedList<SVNRevision> getRevisionPoints() {
            return this.myRevisionPoints;
        }
    }
}

