/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.auth.AbstractAuthenticator;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;

class CredentialsAuthenticator
extends AbstractAuthenticator {
    private String myKind;
    private String myRealm2;
    private SVNAuthentication myAuthentication;

    CredentialsAuthenticator(@NotNull AuthenticationService authenticationService, @NotNull SVNURL url, @Nullable String realm) {
        super(authenticationService, url, realm == null ? url.getHost() : realm);
    }

    public boolean tryAuthenticate(boolean passwordRequest) {
        List<String> kinds = AuthenticationService.getKinds(this.myUrl, passwordRequest);
        Iterator<String> iterator = kinds.iterator();
        while (iterator.hasNext()) {
            String kind;
            this.myKind = kind = iterator.next();
            if (this.tryAuthenticate()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean getWithPassive(SvnAuthenticationManager passive) throws SVNException {
        this.myAuthentication = this.getWithPassiveImpl(passive);
        if (this.myAuthentication != null && !this.checkAuthOk(this.myAuthentication)) {
            this.myAuthenticationService.clearPassiveCredentials(this.myRealm, this.myUrl, this.myAuthentication instanceof SVNPasswordAuthentication);
            this.myAuthentication = null;
        }
        return this.myAuthentication != null;
    }

    private SVNAuthentication getWithPassiveImpl(SvnAuthenticationManager passive) throws SVNException {
        try {
            return passive.getFirstAuthentication(this.myKind, this.myRealm, this.myUrl);
        }
        catch (SVNCancelException e) {
            return null;
        }
    }

    private boolean checkAuthOk(SVNAuthentication authentication) {
        if (authentication instanceof SVNPasswordAuthentication && StringUtil.isEmptyOrSpaces((String)authentication.getUserName())) {
            return false;
        }
        return !(authentication instanceof SVNSSLAuthentication) || !StringUtil.isEmptyOrSpaces((String)((SVNSSLAuthentication)authentication).getPassword());
    }

    @Override
    protected boolean getWithActive(SvnAuthenticationManager active) throws SVNException {
        if ("svn.ssl.client-passphrase".equals(this.myKind) && super.getWithActive(active)) {
            return true;
        }
        this.myAuthentication = active.getProvider().requestClientAuthentication(this.myKind, this.myUrl, this.myRealm, null, null, true);
        this.myStoreInUsual = this.myAuthenticationService.getTempDirectory() == null && this.myAuthentication != null && this.myAuthentication.isStorageAllowed();
        return this.myAuthentication != null;
    }

    @Override
    public void requestClientAuthentication(SVNURL url, String realm, SVNAuthentication authentication) {
        if (!this.myUrl.equals((Object)url)) {
            return;
        }
        this.myAuthentication = authentication;
        this.myRealm2 = realm;
        this.myStoreInUsual = this.myAuthentication != null && this.myAuthentication.isStorageAllowed();
    }

    @Override
    protected boolean afterAuthCall() {
        return this.myAuthentication != null;
    }

    @Override
    protected boolean acknowledge(SvnAuthenticationManager manager) throws SVNException {
        if (!StringUtil.isEmptyOrSpaces((String)this.myRealm2) && !this.myRealm2.equals(this.myRealm)) {
            CredentialsAuthenticator.storeCredentials(manager, this.myAuthentication, this.myRealm2);
        }
        return CredentialsAuthenticator.storeCredentials(manager, this.myAuthentication, this.myRealm);
    }
}

