/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;

public class SvnLoadedBranchesStorage {
    private final Object myLock;
    private SmallMapSerializer<String, Map<String, Collection<SvnBranchItem>>> myState;
    private final File myFile;
    private final Project myProject;

    public SvnLoadedBranchesStorage(Project project) {
        this.myProject = project;
        File vcsFile = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcsFile, "svn_branches");
        file.mkdirs();
        this.myFile = new File(file, project.getLocationHash());
        this.myLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Collection<SvnBranchItem> get(String url) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == null) {
                return null;
            }
            Map<String, Collection<SvnBranchItem>> map = this.myState.get("");
            Collection<SvnBranchItem> collection = map == null ? null : map.get(SvnBranchConfigurationNew.ensureEndSlash(url));
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.myLock;
        synchronized (object) {
            this.myState = new SmallMapSerializer(this.myFile, EnumeratorStringDescriptor.INSTANCE, this.createExternalizer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        HashMap branchLocationToBranchItemsMap = ContainerUtil.newHashMap();
        SvnBranchConfigurationManager manager = SvnBranchConfigurationManager.getInstance(this.myProject);
        Map<VirtualFile, SvnBranchConfigurationNew> mapCopy = manager.getSvnBranchConfigManager().getMapCopy();
        for (Map.Entry<VirtualFile, SvnBranchConfigurationNew> entry : mapCopy.entrySet()) {
            Map<String, InfoStorage<List<SvnBranchItem>>> branchMap = entry.getValue().getBranchMap();
            for (Map.Entry<String, InfoStorage<List<SvnBranchItem>>> storageEntry : branchMap.entrySet()) {
                branchLocationToBranchItemsMap.put(storageEntry.getKey(), storageEntry.getValue().getValue());
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myState.put("", branchLocationToBranchItemsMap);
            this.myState.force();
            this.myState = null;
        }
    }

    private DataExternalizer<Map<String, Collection<SvnBranchItem>>> createExternalizer() {
        return new DataExternalizer<Map<String, Collection<SvnBranchItem>>>(){

            public void save(@NotNull DataOutput out, Map<String, Collection<SvnBranchItem>> value) throws IOException {
                out.writeInt(value.size());
                ArrayList<String> keys = new ArrayList<String>(value.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    out.writeUTF(key);
                    ArrayList<SvnBranchItem> list = new ArrayList<SvnBranchItem>(value.get(key));
                    Collections.sort(list, SerializationComparator.getInstance());
                    out.writeInt(list.size());
                    for (SvnBranchItem item : list) {
                        out.writeUTF(item.getUrl());
                        out.writeLong(item.getCreationDateMillis());
                        out.writeLong(item.getRevision());
                    }
                }
            }

            public Map<String, Collection<SvnBranchItem>> read(@NotNull DataInput in) throws IOException {
                HashMap<String, Collection<SvnBranchItem>> map = new HashMap<String, Collection<SvnBranchItem>>();
                int mapSize = in.readInt();
                for (int i = 0; i < mapSize; ++i) {
                    String key = in.readUTF();
                    int size = in.readInt();
                    ArrayList<SvnBranchItem> list = new ArrayList<SvnBranchItem>(size);
                    for (int j = 0; j < size; ++j) {
                        String url = in.readUTF();
                        long creation = in.readLong();
                        long revision = in.readLong();
                        list.add(new SvnBranchItem(url, new Date(creation), revision));
                    }
                    map.put(key, list);
                }
                return map;
            }
        };
    }

    private static class SerializationComparator
    implements Comparator<SvnBranchItem> {
        private static final SerializationComparator ourInstance = new SerializationComparator();

        private SerializationComparator() {
        }

        public static SerializationComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(SvnBranchItem o1, SvnBranchItem o2) {
            return o1.getUrl().compareToIgnoreCase(o2.getUrl());
        }
    }
}

