/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable DirectoryEntryConsumer handler) throws VcsException {
        this.assertUrl(target);
        SVNLogClient client = this.getLogClient();
        ISVNDirEntryHandler wrappedHandler = SvnKitBrowseClient.wrapHandler(handler);
        client.setIgnoreExternals(true);
        try {
            if (target.isFile()) {
                client.doList(target.getFile(), target.getPegRevision(), SvnKitBrowseClient.notNullize(revision), true, SvnKitBrowseClient.toDepth(depth), -1, wrappedHandler);
            } else {
                client.doList(target.getURL(), target.getPegRevision(), SvnKitBrowseClient.notNullize(revision), true, SvnKitBrowseClient.toDepth(depth), -1, wrappedHandler);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public long createDirectory(@NotNull SvnTarget target, @NotNull String message, boolean makeParents) throws VcsException {
        this.assertUrl(target);
        try {
            SVNCommitInfo commitInfo = this.myVcs.getSvnKitManager().createCommitClient().doMkDir(new SVNURL[]{target.getURL()}, message, null, makeParents);
            return commitInfo.getNewRevision();
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private SVNLogClient getLogClient() {
        SvnAuthenticationManager authManager = this.myIsActive ? this.myVcs.getSvnConfiguration().getInteractiveManager(this.myVcs) : this.myVcs.getSvnConfiguration().getPassiveAuthenticationManager(this.myVcs);
        return this.myVcs.getSvnKitManager().createLogClient((ISVNAuthenticationManager)authManager);
    }

    @Nullable
    private static ISVNDirEntryHandler wrapHandler(@Nullable DirectoryEntryConsumer handler) {
        return handler == null ? null : new SkipEmptyNameDirectoriesHandler(handler);
    }

    public static class SkipEmptyNameDirectoriesHandler
    implements ISVNDirEntryHandler {
        @NotNull
        private final DirectoryEntryConsumer handler;

        public SkipEmptyNameDirectoriesHandler(@NotNull DirectoryEntryConsumer handler) {
            this.handler = handler;
        }

        public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
            if (!SkipEmptyNameDirectoriesHandler.isEmptyNameDirectory(dirEntry)) {
                this.handler.consume(DirectoryEntry.create(dirEntry));
            }
        }

        private static boolean isEmptyNameDirectory(@NotNull SVNDirEntry dirEntry) {
            return SVNNodeKind.DIR.equals(dirEntry.getKind()) && StringUtil.isEmpty((String)dirEntry.getName());
        }
    }
}

