/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;
import org.jetbrains.idea.svn.commandLine.WinTerminalExecutor;

public class TerminalExecutor
extends CommandExecutor {
    private final List<InteractiveCommandListener> myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public TerminalExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        super(exePath, command);
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener) {
        this.myInteractiveListeners.add(listener);
    }

    @Override
    public Boolean wasError() {
        return Boolean.FALSE;
    }

    @Override
    protected void startHandlingStreams() {
        for (InteractiveCommandListener listener : this.myInteractiveListeners) {
            ((TerminalProcessHandler)this.myHandler).addInteractiveListener(listener);
        }
        super.startHandlingStreams();
    }

    @Override
    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        return new TerminalProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString(), this.needsUtf8Output(), false);
    }

    @Override
    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        if (this instanceof WinTerminalExecutor) {
            return super.getBinaryOutput();
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] outputBytes = CharsetToolkit.getUtf8Bytes((String)this.getOutput());
        result.write(outputBytes, 0, outputBytes.length);
        return result;
    }

    @Override
    @NotNull
    protected GeneralCommandLine createCommandLine() {
        return new PtyCommandLine();
    }

    @Override
    @NotNull
    protected Process createProcess() throws ExecutionException {
        List<String> parameters = this.escapeArguments(this.buildParameters());
        return this.createProcess(parameters);
    }

    @NotNull
    protected List<String> buildParameters() {
        return CommandLineUtil.toCommandLine((String)this.myCommandLine.getExePath(), (List)this.myCommandLine.getParametersList().getList());
    }

    @NotNull
    protected Process createProcess(@NotNull List<String> parameters) throws ExecutionException {
        try {
            return ((PtyCommandLine)this.myCommandLine).startProcessWithPty(parameters, false);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Override
    public void logCommand() {
        super.logCommand();
        LOG.info("Terminal output " + ((TerminalProcessHandler)this.myHandler).getTerminalOutput());
    }

    @NotNull
    protected List<String> escapeArguments(@NotNull List<String> arguments) {
        return arguments;
    }
}

