/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;

public class TerminalProcessHandler
extends SvnProcessHandler {
    private final List<InteractiveCommandListener> myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final CapturingProcessAdapter terminalOutputCapturer = new CapturingProcessAdapter();
    private final StringBuilder outputLine = new StringBuilder();
    private final StringBuilder errorLine = new StringBuilder();

    public TerminalProcessHandler(@NotNull Process process, @NotNull String commandLine, boolean forceUtf8, boolean forceBinary) {
        super(process, commandLine, forceUtf8, forceBinary);
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener) {
        this.myInteractiveListeners.add(listener);
    }

    protected boolean processHasSeparateErrorStream() {
        return false;
    }

    protected void destroyProcessImpl() {
        Process process = this.getProcess();
        process.destroy();
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return BaseOutputReader.Options.BLOCKING;
    }

    public void notifyTextAvailable(String text, Key outputType) {
        if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
            super.notifyTextAvailable(text, outputType);
        } else {
            this.terminalOutputCapturer.onTextAvailable(new ProcessEvent((ProcessHandler)this, text), outputType);
            text = this.filterText(text);
            if (!StringUtil.isEmpty((String)text)) {
                StringBuilder lastLine = this.getLastLineFor(outputType);
                String currentLine = lastLine.append(text).toString();
                lastLine.setLength(0);
                currentLine = this.filterCombinedText(currentLine);
                boolean handled = this.handlePrompt(currentLine, outputType);
                if (!handled) {
                    this.notify(currentLine, outputType, lastLine);
                }
            }
        }
    }

    protected boolean handlePrompt(String text, Key outputType) {
        boolean shouldHandleWithListeners = !this.processHasSeparateErrorStream() || ProcessOutputTypes.STDERR.equals((Object)outputType);
        return shouldHandleWithListeners && this.handlePromptWithListeners(text, outputType);
    }

    private boolean handlePromptWithListeners(String text, Key outputType) {
        boolean result = false;
        for (InteractiveCommandListener listener : this.myInteractiveListeners) {
            result |= listener.handlePrompt(text, outputType);
        }
        return result;
    }

    @NotNull
    protected String filterCombinedText(@NotNull String currentLine) {
        return currentLine;
    }

    @NotNull
    protected String filterText(@NotNull String text) {
        return text;
    }

    private void notify(@NotNull String text, @NotNull Key outputType, @NotNull StringBuilder lastLine) {
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            super.notifyTextAvailable(text, this.resolveOutputType(text, outputType));
        } else {
            lastLine.append(text);
        }
    }

    @NotNull
    protected Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        Key result = outputType;
        if (!ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
            Matcher errorMatcher = SvnUtil.ERROR_PATTERN.matcher(line);
            Matcher warningMatcher = SvnUtil.WARNING_PATTERN.matcher(line);
            result = errorMatcher.find() || warningMatcher.find() ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        }
        return result;
    }

    @NotNull
    private StringBuilder getLastLineFor(Key outputType) {
        if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
            return this.errorLine;
        }
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
            return this.outputLine;
        }
        throw new IllegalArgumentException("Unknown process output type " + outputType);
    }

    public String getTerminalOutput() {
        return this.terminalOutputCapturer.getOutput().getStdout();
    }
}

