/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.BaseOutputReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;

public class WinTerminalProcessHandler
extends TerminalProcessHandler {
    private static final String NON_CSI_ESCAPE_CODE = "\u001b.[@-_]";
    private static final String CSI_ESCAPE_CODE = "\u001b\\[(.*?)[@-~]";

    public WinTerminalProcessHandler(@NotNull Process process, @NotNull String commandLine, boolean forceUtf8, boolean forceBinary) {
        super(process, commandLine, forceUtf8, forceBinary);
    }

    @Override
    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return BaseOutputReader.Options.NON_BLOCKING;
    }

    @Override
    @NotNull
    protected String filterCombinedText(@NotNull String currentLine) {
        return WinTerminalProcessHandler.removeAllBeforeCaretReturn(currentLine);
    }

    @Override
    @NotNull
    protected String filterText(@NotNull String text) {
        text = text.replaceAll(CSI_ESCAPE_CODE, "").replaceAll(NON_CSI_ESCAPE_CODE, "");
        text = StringUtil.trimLeading((String)text, (char)'\r');
        return text;
    }

    @Override
    @NotNull
    protected Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        return outputType;
    }

    @NotNull
    private static String removeAllBeforeCaretReturn(@NotNull String line) {
        int caretReturn = line.lastIndexOf("\r");
        while (caretReturn >= 0) {
            if (caretReturn + 1 < line.length() && line.charAt(caretReturn + 1) != '\n') {
                line = line.substring(caretReturn + 1);
                break;
            }
            caretReturn = line.lastIndexOf("\r", caretReturn - 1);
        }
        return line;
    }
}

