/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class AddRepositoryLocationDialog
extends DialogWrapper {
    @NotNull
    private final List<String> myPreviousLocations;
    private JComboBox myCombo;
    private String mySelected;
    private JTextField myComboField;

    public AddRepositoryLocationDialog(@NotNull Project project, @NotNull List<String> values) {
        super(project, true);
        this.myPreviousLocations = ContainerUtil.sorted(values);
        this.setTitle(this.getTitle());
        this.init();
        this.myComboField.setText(this.initText());
    }

    public String getTitle() {
        return SvnBundle.message("repository.browser.add.location.title", new Object[0]);
    }

    protected String initText() {
        return "http://";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(SvnBundle.message("repository.browser.add.location.prompt", new Object[0]));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridy;
        this.myCombo = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(this.myPreviousLocations));
        this.myCombo.setEditable(true);
        this.myCombo.setMinimumSize((Dimension)JBUI.size((int)250, (int)20));
        gb.fill = 2;
        mainPanel.add((Component)this.myCombo, gb);
        gb.fill = 0;
        this.myComboField = (JTextField)this.myCombo.getEditor().getEditorComponent();
        this.myComboField.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                AddRepositoryLocationDialog.this.validateMe();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
                AddRepositoryLocationDialog.this.validateMe();
            }
        });
        this.myComboField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }
        });
        this.myCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }
        });
        this.validateMe();
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        wrapper.setPreferredSize((Dimension)JBUI.size((int)400, (int)70));
        return wrapper;
    }

    private void validateMe() {
        this.setOKActionEnabled(AddRepositoryLocationDialog.isUrlValid(this.myComboField.getText()));
    }

    private static boolean isUrlValid(@Nullable String inputString) {
        if (inputString == null) {
            return false;
        }
        try {
            SvnUtil.createUrl(inputString.trim(), false);
            return true;
        }
        catch (SvnBindException ignore) {
            return false;
        }
    }

    protected void doOKAction() {
        this.mySelected = this.myComboField.getText().trim();
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    public String getSelected() {
        return this.mySelected;
    }
}

