/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;

public class ChangeFormatDialog
extends UpgradeFormatDialog {
    private final boolean myWcRootIsAbove;

    public ChangeFormatDialog(Project project, File path, boolean canBeParent, boolean wcRootIsAbove) {
        super(project, path, canBeParent, false);
        this.myWcRootIsAbove = wcRootIsAbove;
        this.setTitle(SvnBundle.message("action.change.wcopy.format.task.title", new Object[0]));
        this.init();
    }

    @Override
    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Override
    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        if (!this.myWcRootIsAbove) {
            return null;
        }
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel iconLabel = new JLabel(Messages.getWarningIcon());
        result.add((Component)iconLabel, gb);
        ++gb.gridx;
        JLabel warningLabel = new JLabel(SvnBundle.message("label.working.copy.root.outside.text", new Object[0]));
        warningLabel.setFont(warningLabel.getFont().deriveFont(1));
        warningLabel.setUI((LabelUI)new MultiLineLabelUI());
        result.add(warningLabel);
        return result;
    }

    @Override
    protected String getTopMessage(String label) {
        return SvnBundle.message("label.configure.change.label", this.myPath.getAbsolutePath());
    }

    @Override
    protected String getMiddlePartOfResourceKey(boolean adminPathIsDirectory) {
        return "change";
    }

    @Override
    protected boolean showHints() {
        return false;
    }
}

