/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SelectCreateExternalTargetDialog
extends RepositoryBrowserDialog {
    private String mySelectedURL;
    private boolean myCheckout;
    private JTextField myFolderName;
    private boolean myFollowRemoteTarget;
    private final Set<String> myUsedNames;

    public SelectCreateExternalTargetDialog(Project project, VirtualFile below) {
        super(project, true, "Point to repository location");
        VirtualFile[] children = below.getChildren();
        this.myUsedNames = new HashSet();
        int maxCnt = 1000;
        for (VirtualFile child : children) {
            this.myUsedNames.add(child.getName());
            if (--maxCnt <= 0) break;
        }
    }

    protected void init() {
        super.init();
        this.myFollowRemoteTarget = true;
        this.setTitle("Select Target For External");
        this.setOKButtonText("Select");
        this.getRepositoryBrowser().addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (SelectCreateExternalTargetDialog.this.getOKAction() != null) {
                    String selectedURL = SelectCreateExternalTargetDialog.this.getRepositoryBrowser().getSelectedURL();
                    if (SelectCreateExternalTargetDialog.this.myFollowRemoteTarget && selectedURL != null) {
                        SelectCreateExternalTargetDialog.this.myFolderName.setText(SVNPathUtil.tail((String)selectedURL));
                    }
                    SelectCreateExternalTargetDialog.this.checkEnabled();
                }
            }
        });
        this.getOKAction().setEnabled(this.getRepositoryBrowser().getSelectedURL() != null);
    }

    private void checkEnabled() {
        boolean enabled;
        String selectedURL = this.getRepositoryBrowser().getSelectedURL();
        String text = this.myFolderName.getText();
        boolean contains = this.myUsedNames.contains(text);
        boolean bl = enabled = selectedURL != null && !StringUtil.isEmptyOrSpaces((String)text) && !contains;
        if (contains) {
            this.setErrorText("Target File Already Exists", this.myFolderName);
        } else {
            this.setErrorText(null);
        }
        this.getOKAction().setEnabled(enabled);
    }

    @Override
    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected void doOKAction() {
        this.mySelectedURL = this.getRepositoryBrowser().getSelectedURL();
        super.doOKAction();
    }

    @Override
    public String getSelectedURL() {
        return this.mySelectedURL;
    }

    @Override
    protected JPopupMenu createPopup(boolean toolWindow) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = new DefaultActionGroup("_New", true);
        RepositoryBrowserComponent browser = this.getRepositoryBrowser();
        newGroup.add((AnAction)new RepositoryBrowserDialog.AddLocationAction(browser));
        newGroup.add((AnAction)new RepositoryBrowserDialog.MkDirAction(browser));
        group.add((AnAction)newGroup);
        group.addSeparator();
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(browser));
        group.add((AnAction)new RepositoryBrowserDialog.DiscardLocationAction(browser));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
        return menu.getComponent();
    }

    @Override
    public JComponent createCenterPanel() {
        JComponent repositoryPanel = super.createCenterPanel();
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, (Insets)JBUI.insets((int)1), 0, 0);
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.gridwidth = 2;
        wrapper.add((Component)repositoryPanel, gb);
        ++gb.gridy;
        gb.fill = 0;
        gb.weightx = 0.0;
        gb.weighty = 0.0;
        gb.gridwidth = 1;
        this.myFolderName = new JTextField();
        gb.insets.top = 5;
        gb.anchor = 17;
        wrapper.add((Component)new JLabel("Local Target:"), gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.fill = 2;
        wrapper.add((Component)this.myFolderName, gb);
        gb.insets.top = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.gridx = 0;
        ++gb.gridy;
        this.myFolderName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SelectCreateExternalTargetDialog.this.myFollowRemoteTarget = false;
                SelectCreateExternalTargetDialog.this.myFolderName.removeFocusListener(this);
            }
        });
        this.myFolderName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectCreateExternalTargetDialog.this.checkEnabled();
            }
        });
        this.myFolderName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                SelectCreateExternalTargetDialog.this.checkEnabled();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        final JCheckBox checkout = new JCheckBox("Checkout");
        checkout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCreateExternalTargetDialog.this.myCheckout = checkout.isSelected();
            }
        });
        wrapper.add((Component)checkout, gb);
        return wrapper;
    }

    public boolean isCheckout() {
        return this.myCheckout;
    }

    public String getLocalTarget() {
        return this.myFolderName.getText();
    }
}

