/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;

public class ShareDialog
extends RepositoryBrowserDialog {
    private String mySelectedURL;
    private static final String ourExisting = "At selected repository location";
    private static final String ourProject = "In new \"{0}\" folder at selected repository location";
    private static final String ourStandart = "In new \"{0}/trunk\" folder at selected repository location";
    private final String myName;
    private JRadioButton myExisting;
    private JRadioButton mySameNameAsLocal;
    private JRadioButton myTrunk;
    private JCheckBox myCreateStandard;
    private CommitMessage myCommitMessage;
    private JComponent myPrefferedFocused;

    public ShareDialog(Project project, String name) {
        super(project, false, "Point to repository location");
        this.myName = name;
        this.updateOptionsTexts(null);
        this.myExisting.setToolTipText(ourExisting);
        this.mySameNameAsLocal.setToolTipText(MessageFormat.format(ourProject, this.myName));
        this.myTrunk.setToolTipText(MessageFormat.format(ourStandart, this.myName));
        this.myRepositoriesLabel.setFont(this.myRepositoriesLabel.getFont().deriveFont(1));
        this.myPrefferedFocused = (JComponent)this.getRepositoryBrowser().getPreferredFocusedComponent();
    }

    public void init() {
        super.init();
        this.setTitle("Select Share Target");
        this.setOKButtonText("Share");
        this.getRepositoryBrowser().addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ShareDialog.this.getOKAction() != null) {
                    String selectedURL = ShareDialog.this.getRepositoryBrowser().getSelectedURL();
                    ShareDialog.this.updateOptionsTexts(selectedURL);
                    ShareDialog.this.getOKAction().setEnabled(selectedURL != null);
                }
            }
        });
        this.getOKAction().setEnabled(this.getRepositoryBrowser().getSelectedURL() != null);
        ((RepositoryTreeModel)this.getRepositoryBrowser().getRepositoryTree().getModel()).setShowFiles(false);
        this.getRepositoryBrowser().getPreferredFocusedComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ShareDialog.this.myPrefferedFocused = (JComponent)ShareDialog.this.getRepositoryBrowser().getPreferredFocusedComponent();
            }
        });
    }

    private void updateOptionsTexts(String selectedURL) {
        boolean enabled;
        boolean bl = enabled = selectedURL != null;
        if (!enabled) {
            this.myExisting.setText(ourExisting);
            this.mySameNameAsLocal.setText(MessageFormat.format(ourProject, this.myName));
            this.myTrunk.setText(MessageFormat.format(ourStandart, this.myName));
        } else {
            this.myExisting.setText(selectedURL);
            String corrected = selectedURL.endsWith("/") || selectedURL.endsWith("\\") ? selectedURL : selectedURL + "/";
            this.mySameNameAsLocal.setText(corrected + this.myName);
            this.myTrunk.setText(corrected + this.myName + "/trunk");
        }
        this.myExisting.setEnabled(enabled);
        this.mySameNameAsLocal.setEnabled(enabled);
        this.myTrunk.setEnabled(enabled);
        this.myCreateStandard.setEnabled(enabled && this.myTrunk.isSelected());
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myPrefferedFocused;
    }

    @Override
    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doOKAction() {
        this.mySelectedURL = this.getRepositoryBrowser().getSelectedURL();
        super.doOKAction();
    }

    @Override
    public String getSelectedURL() {
        return this.mySelectedURL;
    }

    @Override
    protected JPopupMenu createPopup(boolean toolWindow) {
        ActionPopupMenu menu = ShareDialog.createShortPopupForRepositoryDialog(this.getRepositoryBrowser());
        return menu.getComponent();
    }

    public static ActionPopupMenu createShortPopupForRepositoryDialog(RepositoryBrowserComponent browserComponent) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = new DefaultActionGroup("_New", true);
        newGroup.add((AnAction)new RepositoryBrowserDialog.AddLocationAction(browserComponent));
        newGroup.add((AnAction)new RepositoryBrowserDialog.MkDirAction(browserComponent));
        group.add((AnAction)newGroup);
        group.addSeparator();
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(browserComponent));
        group.add((AnAction)new RepositoryBrowserDialog.DiscardLocationAction(browserComponent));
        group.add((AnAction)new RepositoryBrowserDialog.DeleteAction(browserComponent));
        return ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
    }

    @Override
    public JComponent createCenterPanel() {
        JComponent repositoryPanel = super.createCenterPanel();
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, (Insets)JBUI.insets((int)1), 0, 0);
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        wrapper.add((Component)repositoryPanel, gb);
        ++gb.gridy;
        gb.fill = 0;
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.fill = 2;
        wrapper.add((Component)this.createFolderPanel(), gb);
        return wrapper;
    }

    @NotNull
    public ShareTarget getShareTarget() {
        if (this.myExisting.isSelected()) {
            return ShareTarget.useSelected;
        }
        if (this.mySameNameAsLocal.isSelected()) {
            return ShareTarget.useProjectName;
        }
        return ShareTarget.trunkUnderProjectName;
    }

    public boolean createStandardStructure() {
        return this.myCreateStandard.isSelected();
    }

    @NotNull
    public String getCommitText() {
        return this.myCommitMessage.getComment();
    }

    private JComponent createFolderPanel() {
        Project project = this.myVCS.getProject();
        this.myCommitMessage = new CommitMessage(project){

            public Dimension getPreferredSize() {
                Dimension superValue = super.getPreferredSize();
                return new Dimension(superValue.width, superValue.height > 90 ? superValue.height : 90);
            }

            public void addNotify() {
                super.addNotify();
                ShareDialog.this.myCommitMessage.getEditorField().getFocusTarget().addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        ShareDialog.this.myPrefferedFocused = (JComponent)ShareDialog.this.myCommitMessage.getEditorField();
                    }
                });
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
        gb.insets.top = 5;
        JLabel label = new JLabel("Define share target");
        label.setFont(label.getFont().deriveFont(1));
        panel.add((Component)label, gb);
        gb.insets.top = 1;
        ButtonGroup bg = new ButtonGroup();
        this.myExisting = new JRadioButton();
        this.mySameNameAsLocal = new JRadioButton();
        this.myTrunk = new JRadioButton();
        bg.add(this.myExisting);
        bg.add(this.mySameNameAsLocal);
        bg.add(this.myTrunk);
        gb.insets.top = 1;
        ++gb.gridy;
        panel.add((Component)this.myExisting, gb);
        ++gb.gridy;
        panel.add((Component)this.mySameNameAsLocal, gb);
        ++gb.gridy;
        gb.insets.top = 5;
        panel.add((Component)this.myTrunk, gb);
        this.myCreateStandard = new JCheckBox("Create /tags and /branches");
        this.myTrunk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShareDialog.this.myCreateStandard.setEnabled(ShareDialog.this.myTrunk.isSelected());
            }
        });
        this.myCreateStandard.setSelected(true);
        ++gb.gridy;
        gb.insets.top = 0;
        gb.insets.left = 10;
        panel.add((Component)this.myCreateStandard, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.insets.top = 1;
        gb.insets.left = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        LocalChangeList list = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        String text = list.getComment();
        text = StringUtil.isEmptyOrSpaces((String)text) ? (list.hasDefaultName() ? "" : list.getName()) : text;
        this.myCommitMessage.setText(text);
        panel.add((Component)this.myCommitMessage, gb);
        this.myCommitMessage.setSeparatorText("Commit Comment Prefix");
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions((ExtensionPointName)EditChangelistSupport.EP_NAME, (AreaInstance)project)) {
            support.installSearch(this.myCommitMessage.getEditorField(), this.myCommitMessage.getEditorField());
        }
        this.myTrunk.setSelected(true);
        return panel;
    }

    public static enum ShareTarget {
        useSelected,
        useProjectName,
        trunkUnderProjectName;

    }
}

