/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class WCInfo {
    private final boolean myIsWcRoot;
    @NotNull
    private final Depth myStickyDepth;
    @NotNull
    private final RootUrlInfo myRootInfo;

    public WCInfo(@NotNull RootUrlInfo rootInfo, boolean isWcRoot, @NotNull Depth stickyDepth) {
        this.myRootInfo = rootInfo;
        this.myIsWcRoot = isWcRoot;
        this.myStickyDepth = stickyDepth;
    }

    @NotNull
    public Depth getStickyDepth() {
        return this.myStickyDepth;
    }

    @NotNull
    public String getPath() {
        return this.myRootInfo.getPath();
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        return null;
    }

    @NotNull
    public SVNURL getUrl() {
        return this.myRootInfo.getAbsoluteUrlAsUrl();
    }

    @NotNull
    public String getRootUrl() {
        return this.getUrl().toString();
    }

    @NotNull
    public String getRepoUrl() {
        return this.getRepositoryRoot();
    }

    @NotNull
    public RootUrlInfo getRootInfo() {
        return this.myRootInfo;
    }

    public boolean hasError() {
        return this.getRootInfo().getNode().hasError();
    }

    @NotNull
    public String getErrorMessage() {
        SvnBindException error = this.getRootInfo().getNode().getError();
        return error != null ? error.getMessage() : "";
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        return this.myRootInfo.getFormat();
    }

    @NotNull
    public String getRepositoryRoot() {
        return this.myRootInfo.getRepositoryUrl();
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        return this.getPath().equals(wcInfo.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myRootInfo.getType();
    }
}

