/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.difftool.SvnDiffSettingsHolder;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffViewer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnDiffViewer
implements FrameDiffTool.DiffViewer {
    private static final Logger LOG = Logger.getInstance(SvnDiffViewer.class);
    public static final Key<MyPropertyContext> PROPERTY_CONTEXT_KEY = Key.create((String)"MyPropertyContext");
    public static final Key<Boolean> FOCUSED_VIEWER_KEY = Key.create((String)"SvnFocusedViewer");
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffRequest myPropertyRequest;
    @NotNull
    private final SvnDiffSettingsHolder.SvnDiffSettings mySettings;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final Wrapper myNotificationPanel;
    @NotNull
    private final FrameDiffTool.DiffViewer myContentViewer;
    @NotNull
    private final FrameDiffTool.DiffViewer myPropertiesViewer;
    @NotNull
    private final FocusListener myContentFocusListener = new MyFocusListener(false);
    @NotNull
    private final FocusListener myPropertiesFocusListener = new MyFocusListener(true);
    private boolean myPropertiesViewerFocused;
    private boolean myDumbContentViewer;

    public SvnDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest propertyRequest, @NotNull FrameDiffTool.DiffViewer wrappingViewer) {
        this.myProject = context.getProject();
        this.myContext = context;
        this.myPropertyRequest = propertyRequest;
        this.myContentViewer = wrappingViewer;
        this.myPropertyRequest.onAssigned(true);
        this.mySettings = SvnDiffViewer.initSettings(context);
        this.mySplitter = new MySplitter("Property Changes");
        this.mySplitter.setProportion(this.mySettings.getSplitterProportion());
        this.mySplitter.setFirstComponent(this.myContentViewer.getComponent());
        this.myNotificationPanel = new Wrapper();
        MyPropertyContext propertyContext = this.initPropertyContext(context);
        this.myPropertiesViewer = SvnDiffViewer.createPropertiesViewer(propertyRequest, propertyContext);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.mySplitter, "Center");
        this.myPanel.add((Component)this.myNotificationPanel, "South");
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                DataProvider propertiesDataProvider = DataManagerImpl.getDataProviderEx((Object)SvnDiffViewer.this.myPropertiesViewer.getComponent());
                DataProvider contentDataProvider = DataManagerImpl.getDataProviderEx((Object)SvnDiffViewer.this.myContentViewer.getComponent());
                DataProvider defaultDP = SvnDiffViewer.this.myPropertiesViewerFocused ? propertiesDataProvider : contentDataProvider;
                DataProvider fallbackDP = SvnDiffViewer.this.myPropertiesViewerFocused ? contentDataProvider : propertiesDataProvider;
                return DiffUtil.getData((DataProvider)defaultDP, (DataProvider)fallbackDP, (String)dataId);
            }
        });
        this.updatePropertiesPanel();
    }

    @NotNull
    private static FrameDiffTool.DiffViewer createPropertiesViewer(@NotNull DiffRequest propertyRequest, @NotNull MyPropertyContext propertyContext) {
        if (propertyRequest instanceof SvnPropertiesDiffRequest) {
            return SvnPropertiesDiffViewer.create(propertyContext, (SvnPropertiesDiffRequest)propertyRequest, true);
        }
        return ErrorDiffTool.INSTANCE.createComponent((DiffContext)propertyContext, propertyRequest);
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.installListeners();
        this.processContextHints();
        FrameDiffTool.ToolbarComponents properties = this.myPropertiesViewer.init();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbar(properties.toolbarActions);
        return components;
    }

    public void dispose() {
        this.destroyListeners();
        this.updateContextHints();
        Disposer.dispose((Disposable)this.myPropertiesViewer);
        this.myPropertyRequest.onAssigned(false);
    }

    private void processContextHints() {
        if (this.myContext.getUserData(FOCUSED_VIEWER_KEY) == Boolean.TRUE) {
            this.myPropertiesViewerFocused = true;
        }
        this.myDumbContentViewer = this.myContentViewer.getPreferredFocusedComponent() == null;
    }

    private void updateContextHints() {
        if (!this.myDumbContentViewer && !this.mySettings.isHideProperties()) {
            this.myContext.putUserData(FOCUSED_VIEWER_KEY, (Object)this.myPropertiesViewerFocused);
        }
        this.mySettings.setSplitterProportion(this.mySplitter.getProportion());
    }

    @Nullable
    private JComponent createNotification() {
        if (this.myPropertyRequest instanceof ErrorDiffRequest) {
            return SvnDiffViewer.createNotification(((ErrorDiffRequest)this.myPropertyRequest).getMessage());
        }
        List<DiffContent> contents = ((SvnPropertiesDiffRequest)this.myPropertyRequest).getContents();
        Map<String, PropertyValue> before = SvnDiffViewer.getProperties(contents.get(0));
        Map<String, PropertyValue> after = SvnDiffViewer.getProperties(contents.get(1));
        if (before.isEmpty() && after.isEmpty()) {
            return null;
        }
        if (!before.keySet().equals(after.keySet())) {
            return SvnDiffViewer.createNotification("SVN Properties changed");
        }
        for (String key : before.keySet()) {
            if (Comparing.equal((Object)before.get(key), (Object)after.get(key))) continue;
            return SvnDiffViewer.createNotification("SVN Properties changed");
        }
        return null;
    }

    @NotNull
    private static Map<String, PropertyValue> getProperties(@NotNull DiffContent content) {
        if (content instanceof EmptyContent) {
            return Collections.emptyMap();
        }
        List<PropertyData> properties = ((SvnPropertiesDiffRequest.PropertyContent)content).getProperties();
        HashMap map = new HashMap();
        for (PropertyData data : properties) {
            if (map.containsKey(data.getName())) {
                LOG.warn("Duplicated property: " + data.getName());
            }
            map.put(data.getName(), data.getValue());
        }
        return map;
    }

    @NotNull
    private static JPanel createNotification(@NotNull String text) {
        return new EditorNotificationPanel().text(text);
    }

    private void updatePropertiesPanel() {
        boolean wasFocused = this.myContext.isFocused();
        if (!this.mySettings.isHideProperties()) {
            this.mySplitter.setSecondComponent(this.myPropertiesViewer.getComponent());
            this.myNotificationPanel.setContent(null);
        } else {
            this.mySplitter.setSecondComponent(null);
            this.myNotificationPanel.setContent(this.createNotification());
        }
        if (wasFocused) {
            this.myContext.requestFocus();
        }
    }

    @NotNull
    private List<AnAction> createToolbar(@Nullable List<AnAction> propertiesActions) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        if (propertiesActions != null) {
            result.addAll(propertiesActions);
        }
        result.add((AnAction)new ToggleHidePropertiesAction());
        return result;
    }

    @NotNull
    private static SvnDiffSettingsHolder.SvnDiffSettings initSettings(@NotNull DiffContext context) {
        SvnDiffSettingsHolder.SvnDiffSettings settings = (SvnDiffSettingsHolder.SvnDiffSettings)context.getUserData(SvnDiffSettingsHolder.SvnDiffSettings.KEY);
        if (settings == null) {
            settings = SvnDiffSettingsHolder.SvnDiffSettings.getSettings();
            context.putUserData(SvnDiffSettingsHolder.SvnDiffSettings.KEY, (Object)settings);
        }
        return settings;
    }

    @NotNull
    private MyPropertyContext initPropertyContext(@NotNull DiffContext context) {
        MyPropertyContext propertyContext = (MyPropertyContext)((Object)context.getUserData(PROPERTY_CONTEXT_KEY));
        if (propertyContext == null) {
            propertyContext = new MyPropertyContext();
            context.putUserData(PROPERTY_CONTEXT_KEY, (Object)propertyContext);
        }
        return propertyContext;
    }

    private void installListeners() {
        this.myContentViewer.getComponent().addFocusListener(this.myContentFocusListener);
        this.myPropertiesViewer.getComponent().addFocusListener(this.myPropertiesFocusListener);
    }

    private void destroyListeners() {
        this.myContentViewer.getComponent().removeFocusListener(this.myContentFocusListener);
        this.myPropertiesViewer.getComponent().removeFocusListener(this.myPropertiesFocusListener);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myPropertiesViewerFocused) {
            JComponent component = this.getPropertiesPreferredFocusedComponent();
            if (component != null) {
                return component;
            }
            return this.myContentViewer.getPreferredFocusedComponent();
        }
        JComponent component = this.myContentViewer.getPreferredFocusedComponent();
        if (component != null) {
            return component;
        }
        return this.getPropertiesPreferredFocusedComponent();
    }

    @Nullable
    private JComponent getPropertiesPreferredFocusedComponent() {
        if (this.mySettings.isHideProperties()) {
            return null;
        }
        return this.myPropertiesViewer.getPreferredFocusedComponent();
    }

    private static class MySplitter
    extends Splitter {
        @NotNull
        private final String myLabelText;

        public MySplitter(@NotNull String text) {
            super(true);
            this.myLabelText = text;
        }

        protected Divider createDivider() {
            return new Splitter.DividerImpl(){

                public void setOrientation(boolean isVerticalSplit) {
                    if (!this.isVertical()) {
                        LOG.warn("unsupported state: splitter should be vertical");
                    }
                    this.removeAll();
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    JLabel label = new JLabel(myLabelText);
                    label.setFont(UIUtil.getOptionPaneMessageFont());
                    label.setForeground(UIUtil.getLabelForeground());
                    this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insets((int)2), 0, 0));
                    this.setDividerWidth(label.getPreferredSize().height + JBUI.scale((int)4));
                    this.revalidate();
                    this.repaint();
                }

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(JBColor.border());
                    UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)this.getWidth(), (int)0);
                }
            };
        }
    }

    private class MyFocusListener
    extends FocusAdapter {
        private final boolean myValue;

        public MyFocusListener(boolean value) {
            this.myValue = value;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SvnDiffViewer.this.myPropertiesViewerFocused = this.myValue;
        }
    }

    private class MyPropertyContext
    extends DiffContext {
        private MyPropertyContext() {
        }

        @Nullable
        public Project getProject() {
            return SvnDiffViewer.this.myContext.getProject();
        }

        public boolean isWindowFocused() {
            return SvnDiffViewer.this.myContext.isWindowFocused();
        }

        public boolean isFocused() {
            return DiffUtil.isFocusedComponent((Project)this.getProject(), (Component)SvnDiffViewer.this.myPropertiesViewer.getComponent());
        }

        public void requestFocus() {
            DiffUtil.requestFocus((Project)this.getProject(), (Component)SvnDiffViewer.this.myPropertiesViewer.getPreferredFocusedComponent());
        }
    }

    private class ToggleHidePropertiesAction
    extends ToggleAction
    implements DumbAware {
        public ToggleHidePropertiesAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Subversion.TogglePropertiesDiff");
        }

        public boolean isSelected(AnActionEvent e) {
            return !SvnDiffViewer.this.mySettings.isHideProperties();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            SvnDiffViewer.this.mySettings.setHideProperties(!state);
            SvnDiffViewer.this.updatePropertiesPanel();
        }
    }
}

