/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ThreeState;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;

public class SvnTreeConflictDiffRequestProvider
implements ChangeDiffRequestProvider {
    @NotNull
    public ThreeState isEquals(@NotNull Change change1, @NotNull Change change2) {
        if (change1 instanceof ConflictedSvnChange && change2 instanceof ConflictedSvnChange) {
            TreeConflictDescription description2;
            if (!change1.isTreeConflict() && !change2.isTreeConflict()) {
                return ThreeState.UNSURE;
            }
            if (!change1.isTreeConflict() || !change2.isTreeConflict()) {
                return ThreeState.NO;
            }
            TreeConflictDescription description1 = ((ConflictedSvnChange)change1).getBeforeDescription();
            return TreeConflictRefreshablePanel.descriptionsEqual(description1, description2 = ((ConflictedSvnChange)change2).getBeforeDescription()) ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    public boolean canCreate(@Nullable Project project, @NotNull Change change) {
        return change instanceof ConflictedSvnChange && ((ConflictedSvnChange)change).getConflictState().isTree();
    }

    @NotNull
    public DiffRequest process(@NotNull ChangeDiffRequestProducer presentable, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        return new SvnTreeConflictDiffRequest((ConflictedSvnChange)presentable.getChange());
    }

    private static class SvnTreeConflictDiffViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final SvnTreeConflictDiffRequest myRequest;
        @NotNull
        private final Wrapper myPanel = new Wrapper();
        @NotNull
        private final BackgroundTaskQueue myQueue;
        @NotNull
        private final TreeConflictRefreshablePanel myDelegate;

        public SvnTreeConflictDiffViewer(@NotNull DiffContext context, @NotNull SvnTreeConflictDiffRequest request) {
            this.myContext = context;
            this.myRequest = request;
            this.myQueue = new BackgroundTaskQueue(this.myContext.getProject(), "Loading change details");
            this.myDelegate = new TreeConflictRefreshablePanel(this.myContext.getProject(), "Loading tree conflict details", this.myQueue, this.myRequest.getChange());
            this.myDelegate.refresh();
            this.myPanel.setContent((JComponent)this.myDelegate.getPanel());
        }

        @NotNull
        public JComponent getComponent() {
            return this.myPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPanel;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            return new FrameDiffTool.ToolbarComponents();
        }

        public void dispose() {
            this.myQueue.clear();
            Disposer.dispose((Disposable)this.myDelegate);
        }
    }

    public static class SvnTreeConflictDiffTool
    implements FrameDiffTool {
        @NotNull
        public String getName() {
            return "SVN tree conflict viewer";
        }

        public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
            return request instanceof SvnTreeConflictDiffRequest;
        }

        @NotNull
        public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
            return new SvnTreeConflictDiffViewer(context, (SvnTreeConflictDiffRequest)request);
        }
    }

    public static class SvnTreeConflictDiffRequest
    extends DiffRequest {
        @NotNull
        private final ConflictedSvnChange myChange;

        public SvnTreeConflictDiffRequest(@NotNull ConflictedSvnChange change) {
            this.myChange = change;
        }

        @NotNull
        public ConflictedSvnChange getChange() {
            return this.myChange;
        }

        @Nullable
        public String getTitle() {
            return ChangeDiffRequestProducer.getRequestTitle((Change)this.myChange);
        }
    }
}

