/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoUpdatesListener {
    private static final int DELAY = 300;
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private List<RootsAndBranches> myMergeInfoRefreshActions;
    private final ZipperUpdater myUpdater;

    public MergeInfoUpdatesListener(@NotNull Project project, MessageBusConnection connection) {
        this.myConnection = connection;
        this.myProject = project;
        this.myUpdater = new ZipperUpdater(300, (Disposable)project);
    }

    public void addPanel(RootsAndBranches action) {
        if (this.myMergeInfoRefreshActions == null) {
            this.myMergeInfoRefreshActions = new ArrayList<RootsAndBranches>();
            this.myMergeInfoRefreshActions.add(action);
            this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED, (Object)new VcsConfigurationChangeListener.Notification(){

                public void execute(Project project, VirtualFile vcsRoot) {
                    MergeInfoUpdatesListener.this.callReloadMergeInfo();
                }
            });
            Consumer<Boolean> reloadConsumer = new Consumer<Boolean>(){

                public void consume(Boolean aBoolean) {
                    if (Boolean.TRUE.equals(aBoolean)) {
                        MergeInfoUpdatesListener.this.callReloadMergeInfo();
                    }
                }
            };
            final Runnable reloadRunnable = new Runnable(){

                @Override
                public void run() {
                    MergeInfoUpdatesListener.this.callReloadMergeInfo();
                }
            };
            this.myConnection.subscribe(SvnVcs.WC_CONVERTED, (Object)reloadRunnable);
            this.myConnection.subscribe(RootsAndBranches.REFRESH_REQUEST, (Object)reloadRunnable);
            this.myConnection.subscribe(SvnVcs.ROOTS_RELOADED, (Object)reloadConsumer);
            this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

                public void directoryMappingChanged() {
                    MergeInfoUpdatesListener.this.callReloadMergeInfo();
                }
            });
            this.myConnection.subscribe(CommittedChangesTreeBrowser.ITEMS_RELOADED, (Object)new CommittedChangesTreeBrowser.CommittedChangesReloadListener(){

                public void itemsReloaded() {
                    reloadRunnable.run();
                }

                public void emptyRefresh() {
                }
            });
            this.myConnection.subscribe(SvnMergeInfoCache.SVN_MERGE_INFO_CACHE, (Object)new SvnMergeInfoCache.SvnMergeInfoCacheListener(){

                @Override
                public void copyRevisionUpdated() {
                    MergeInfoUpdatesListener.this.doForEachInitialized((Consumer<RootsAndBranches>)((Consumer)new Consumer<RootsAndBranches>(){

                        public void consume(RootsAndBranches rootsAndBranches) {
                            rootsAndBranches.fireRepaint();
                        }
                    }));
                }
            });
            this.myConnection.subscribe(Merger.COMMITTED_CHANGES_MERGED_STATE, (Object)new Merger.CommittedChangesMergedStateChanged(){

                @Override
                public void event(final List<CommittedChangeList> list) {
                    MergeInfoUpdatesListener.this.doForEachInitialized((Consumer<RootsAndBranches>)((Consumer)new Consumer<RootsAndBranches>(){

                        public void consume(RootsAndBranches rootsAndBranches) {
                            rootsAndBranches.refreshByLists(list);
                        }
                    }));
                }
            });
        } else {
            this.myMergeInfoRefreshActions.add(action);
        }
    }

    private void doForEachInitialized(final Consumer<RootsAndBranches> consumer) {
        this.myUpdater.queue(new Runnable(){

            @Override
            public void run() {
                for (final RootsAndBranches action : MergeInfoUpdatesListener.this.myMergeInfoRefreshActions) {
                    if (!action.strategyInitialized()) continue;
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        consumer.consume((Object)action);
                        continue;
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            consumer.consume((Object)action);
                        }
                    });
                }
            }
        });
    }

    private void callReloadMergeInfo() {
        this.doForEachInitialized(new Consumer<RootsAndBranches>(){

            public void consume(RootsAndBranches rootsAndBranches) {
                rootsAndBranches.reloadPanels();
                rootsAndBranches.refresh();
            }
        });
    }

    public void removePanel(RootsAndBranches action) {
        if (this.myMergeInfoRefreshActions != null) {
            this.myMergeInfoRefreshActions.remove(action);
        }
    }
}

