/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.branchConfig.ConfigureBranchesAction;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.MergeInfoUpdatesListener;
import org.jetbrains.idea.svn.history.MergeSourceHierarchyBuilder;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.ShowHideMergePanelAction;
import org.jetbrains.idea.svn.history.SingleCommittedListProvider;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedListsZipper;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnVersionFilterComponent;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnCommittedChangesProvider
implements CachingCommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(SvnCommittedChangesProvider.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final MessageBusConnection myConnection;
    private MergeInfoUpdatesListener myMergeInfoUpdatesListener;
    @NotNull
    private final SvnCommittedListsZipper myZipper;
    public static final int VERSION_WITH_COPY_PATHS_ADDED = 2;
    public static final int VERSION_WITH_REPLACED_PATHS = 3;

    public SvnCommittedChangesProvider(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        this.myZipper = new SvnCommittedListsZipper(this.myVcs);
        this.myConnection = this.myVcs.getProject().getMessageBus().connect();
        this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE, (project, vcsRoot, cachedList) -> ApplicationManager.getApplication().invokeLater(() -> cachedList.stream().filter(SvnChangeList.class::isInstance).map(SvnChangeList.class::cast).filter(list -> vcsRoot == null || vcsRoot.equals(list.getVcsRoot())).forEach(SvnChangeList::forceReloadCachedInfo), project.getDisposed()));
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        return new ChangeBrowserSettings();
    }

    @NotNull
    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new SvnVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root) {
        String url = SvnUtil.getExactLocation(this.myVcs, root.getIOFile());
        return url == null ? null : new SvnRepositoryLocation(url, root);
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root, @Nullable String repositoryPath) {
        return repositoryPath == null ? this.getLocationFor(root) : new SvnRepositoryLocation(repositoryPath);
    }

    @NotNull
    public VcsCommittedListsZipper getZipper() {
        return this.myZipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            String repositoryRoot = this.getRepositoryRoot(svnLocation);
            ChangeBrowserSettings.Filter filter = settings.createFilter();
            Consumer resultConsumer = logEntry -> {
                SvnChangeList list = new SvnChangeList(this.myVcs, svnLocation, (LogEntry)logEntry, repositoryRoot);
                if (filter.accepts((CommittedChangeList)list)) {
                    consumer.consume((Object)list);
                }
            };
            SvnTarget target = SvnTarget.fromURL((SVNURL)svnLocation.toSvnUrl(), (SVNRevision)SvnCommittedChangesProvider.createBeforeRevision(settings));
            this.getCommittedChangesImpl(settings, target, maxCount, (Consumer<LogEntry>)resultConsumer, false, true);
        }
        finally {
            consumer.finished();
        }
    }

    @NotNull
    public List<SvnChangeList> getCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount) throws VcsException {
        SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        ArrayList result = ContainerUtil.newArrayList();
        String repositoryRoot = this.getRepositoryRoot(svnLocation);
        Consumer resultConsumer = logEntry -> result.add(new SvnChangeList(this.myVcs, svnLocation, (LogEntry)logEntry, repositoryRoot));
        SvnTarget target = SvnTarget.fromURL((SVNURL)svnLocation.toSvnUrl(), (SVNRevision)SvnCommittedChangesProvider.createBeforeRevision(settings));
        this.getCommittedChangesImpl(settings, target, maxCount, (Consumer<LogEntry>)resultConsumer, false, true);
        settings.filterChanges((List)result);
        return result;
    }

    public void getCommittedChangesWithMergedRevisons(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull PairConsumer<SvnChangeList, LogHierarchyNode> finalConsumer) throws VcsException {
        SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        String repositoryRoot = this.getRepositoryRoot(svnLocation);
        MergeSourceHierarchyBuilder builder = new MergeSourceHierarchyBuilder((Consumer<LogHierarchyNode>)((Consumer)node -> finalConsumer.consume((Object)new SvnChangeList(this.myVcs, svnLocation, node.getMe(), repositoryRoot), node)));
        SvnMergeSourceTracker mergeSourceTracker = new SvnMergeSourceTracker(builder);
        this.getCommittedChangesImpl(settings, SvnTarget.fromURL((SVNURL)svnLocation.toSvnUrl()), maxCount, (Consumer<LogEntry>)((Consumer)logEntry -> {
            try {
                mergeSourceTracker.consume((LogEntry)logEntry);
            }
            catch (SVNException e) {
                throw new RuntimeException(e);
            }
        }), true, false);
        builder.finish();
    }

    @NotNull
    private String getRepositoryRoot(@NotNull SvnRepositoryLocation svnLocation) throws VcsException {
        SVNURL rootUrl = SvnUtil.getRepositoryRoot(this.myVcs, svnLocation.toSvnUrl());
        if (rootUrl == null) {
            throw new SvnBindException("Could not resolve repository root url for " + svnLocation);
        }
        return rootUrl.toDecodedString();
    }

    private void getCommittedChangesImpl(@NotNull ChangeBrowserSettings settings, @NotNull SvnTarget target, int maxCount, @NotNull Consumer<LogEntry> resultConsumer, boolean includeMergedRevisions, boolean filterOutByDate) throws VcsException {
        ProgressManager.progress((String)SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]), (String)SvnBundle.message("progress.text2.changes.establishing.connection", target.getPathOrUrlString()));
        String author = settings.getUserFilter();
        SVNRevision revisionBefore = SvnCommittedChangesProvider.createBeforeRevision(settings);
        SVNRevision revisionAfter = SvnCommittedChangesProvider.createAfterRevision(settings);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, revisionBefore, revisionAfter, settings.STOP_ON_COPY, true, includeMergedRevisions, maxCount, null, this.createLogHandler(resultConsumer, filterOutByDate, author));
    }

    @NotNull
    private static SVNRevision createBeforeRevision(@NotNull ChangeBrowserSettings settings) {
        return SvnCommittedChangesProvider.createRevision(settings.getDateBeforeFilter(), settings.getChangeBeforeFilter(), SVNRevision.HEAD);
    }

    @NotNull
    private static SVNRevision createAfterRevision(@NotNull ChangeBrowserSettings settings) {
        return SvnCommittedChangesProvider.createRevision(settings.getDateAfterFilter(), settings.getChangeAfterFilter(), SVNRevision.create((long)1L));
    }

    @NotNull
    private static SVNRevision createRevision(@Nullable Date date, @Nullable Long change, @NotNull SVNRevision defaultValue) {
        SVNRevision result = date != null ? SVNRevision.create((Date)date) : (change != null ? SVNRevision.create((long)change) : defaultValue);
        return result;
    }

    @NotNull
    private LogEntryConsumer createLogHandler(@NotNull Consumer<LogEntry> resultConsumer, boolean filterOutByDate, @Nullable String author) {
        return logEntry -> {
            if (this.myVcs.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (logEntry != LogEntry.EMPTY) {
                ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
            }
            if (filterOutByDate && logEntry.getDate() == null) {
                return;
            }
            if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                resultConsumer.consume(logEntry);
            }
        };
    }

    @NotNull
    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(SvnBundle.message("revision.title", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
    }

    private void refreshMergeInfo(@NotNull RootsAndBranches action) {
        if (this.myMergeInfoUpdatesListener == null) {
            this.myMergeInfoUpdatesListener = new MergeInfoUpdatesListener(this.myVcs.getProject(), this.myConnection);
        }
        this.myMergeInfoUpdatesListener.addPanel(action);
    }

    @NotNull
    public VcsCommittedViewAuxiliary createActions(@NotNull DecoratorManager manager, @Nullable RepositoryLocation location) {
        RootsAndBranches rootsAndBranches = new RootsAndBranches(this.myVcs, manager, location);
        this.refreshMergeInfo(rootsAndBranches);
        DefaultActionGroup popup = new DefaultActionGroup(this.myVcs.getDisplayName(), true);
        popup.add((AnAction)rootsAndBranches.getIntegrateAction());
        popup.add((AnAction)rootsAndBranches.getUndoIntegrateAction());
        popup.add((AnAction)new ConfigureBranchesAction());
        ShowHideMergePanelAction action = new ShowHideMergePanelAction(manager, rootsAndBranches.getStrategy());
        return new VcsCommittedViewAuxiliary(Collections.singletonList(popup), () -> {
            if (this.myMergeInfoUpdatesListener != null) {
                this.myMergeInfoUpdatesListener.removePanel(rootsAndBranches);
                rootsAndBranches.dispose();
            }
        }, Collections.singletonList(action));
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public Pair<SvnChangeList, FilePath> getOneList(@NotNull VirtualFile file, @NotNull VcsRevisionNumber number) throws VcsException {
        return new SingleCommittedListProvider(this.myVcs, file, number).run();
    }

    @NotNull
    public RepositoryLocation getForNonLocal(@NotNull VirtualFile file) {
        return new SvnRepositoryLocation(FileUtil.toSystemIndependentName((String)file.getPresentableUrl()));
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(@NotNull DataOutput dataStream, @NotNull SvnChangeList list) throws IOException {
        list.writeToStream(dataStream);
    }

    @NotNull
    public SvnChangeList readChangeList(@NotNull RepositoryLocation location, @NotNull DataInput stream) throws IOException {
        int version = this.getFormatVersion();
        return new SvnChangeList(this.myVcs, (SvnRepositoryLocation)location, stream, 2 <= version, 3 <= version);
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    @Nullable
    public Collection<FilePath> getIncomingFiles(@NotNull RepositoryLocation location) throws VcsException {
        FilePath root = null;
        if (Registry.is((String)"svn.use.incoming.optimization") && (root = ((SvnRepositoryLocation)location).getRoot()) == null) {
            LOG.info("Working copy root is not provided for repository location " + location);
        }
        return root != null ? this.getIncomingFiles(root) : null;
    }

    @NotNull
    private Collection<FilePath> getIncomingFiles(@NotNull FilePath root) throws SvnBindException {
        final HashSet result = ContainerUtil.newHashSet();
        File rootFile = root.getIOFile();
        this.myVcs.getFactory(rootFile).createStatusClient().doStatus(rootFile, SVNRevision.UNDEFINED, Depth.INFINITY, true, false, false, false, new StatusConsumer(){

            public void consume(Status status) throws SVNException {
                boolean changedOnServer;
                File file = status.getFile();
                boolean bl = changedOnServer = SvnCommittedChangesProvider.isNotNone(status.getRemoteContentsStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemoteNodeStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemotePropertiesStatus());
                if (file != null && changedOnServer) {
                    result.add(VcsUtil.getFilePath((File)file));
                }
            }
        }, null);
        return result;
    }

    private static boolean isNotNone(@Nullable StatusType status) {
        return status != null && !StatusType.STATUS_NONE.equals((Object)status);
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return SvnBundle.message("changes.browser.revision.term", new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, SvnChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    public void deactivate() {
        this.myConnection.disconnect();
    }
}

