/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnFileRevision
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.SvnFileRevision");
    private final Date myDate;
    private String myCommitMessage;
    private final String myAuthor;
    private final SvnRevisionNumber myRevisionNumber;
    private final SvnVcs myVCS;
    private final String myURL;
    private final SVNRevision myPegRevision;
    private final SVNRevision myRevision;
    private final String myCopyFromPath;
    private final List<SvnFileRevision> myMergeSources;

    public SvnFileRevision(SvnVcs vcs, SVNRevision pegRevision, SVNRevision revision, String url, String author, Date date, String commitMessage, String copyFromPath) {
        this.myRevisionNumber = new SvnRevisionNumber(revision);
        this.myPegRevision = pegRevision;
        this.myRevision = revision;
        this.myAuthor = author;
        this.myDate = date;
        this.myCommitMessage = commitMessage;
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
        this.myMergeSources = new ArrayList<SvnFileRevision>();
    }

    public SvnFileRevision(SvnVcs vcs, SVNRevision pegRevision, LogEntry logEntry, String url, String copyFromPath) {
        SVNRevision revision = SVNRevision.create((long)logEntry.getRevision());
        this.myRevisionNumber = new SvnRevisionNumber(revision);
        this.myPegRevision = pegRevision;
        this.myRevision = revision;
        this.myAuthor = logEntry.getAuthor();
        this.myDate = logEntry.getDate();
        this.myCommitMessage = logEntry.getMessage();
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
        this.myMergeSources = new ArrayList<SvnFileRevision>();
    }

    @NotNull
    public CommitInfo getCommitInfo() {
        return new CommitInfo.Builder(this.myRevisionNumber.getRevision().getNumber(), this.myDate, this.myAuthor).build();
    }

    public String getURL() {
        return this.myURL;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public String getBranchName() {
        return null;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return new SvnRepositoryLocation(this.myURL);
    }

    public Date getRevisionDate() {
        return this.myDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public void addMergeSource(SvnFileRevision source) {
        this.myMergeSources.add(source);
    }

    public List<SvnFileRevision> getMergeSources() {
        return this.myMergeSources;
    }

    public byte[] loadContent() throws IOException, VcsException {
        ContentLoader loader = new ContentLoader(this.myURL, this.myRevision, this.myPegRevision);
        if (ApplicationManager.getApplication().isDispatchThread() && !this.myRevision.isLocal()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, this.myVCS.getProject());
        } else {
            loader.run();
        }
        VcsException exception = loader.getException();
        if (exception == null) {
            byte[] contents = loader.getContents();
            ContentRevisionCache.checkContentsSize((String)this.myURL, (long)contents.length);
            return contents;
        }
        LOG.info("Failed to load file '" + this.myURL + "' content at revision: " + this.myRevision + "\n" + exception.getMessage(), (Throwable)exception);
        throw exception;
    }

    public byte[] getContent() throws IOException, VcsException {
        byte[] result = SVNRevision.HEAD.equals((Object)this.myRevision) ? this.loadContent() : ContentRevisionCache.getOrLoadAsBytes((Project)this.myVCS.getProject(), (FilePath)VcsUtil.getFilePathOnNonLocal((String)this.myURL, (boolean)false), (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVCS.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REMOTE_CONTENT, (Throwable2Computable)new Throwable2Computable<byte[], VcsException, IOException>(){

            public byte[] compute() throws VcsException, IOException {
                return SvnFileRevision.this.loadContent();
            }
        });
        return result;
    }

    public String getCopyFromPath() {
        return this.myCopyFromPath;
    }

    public void setCommitMessage(String message) {
        this.myCommitMessage = message;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    private class ContentLoader
    implements Runnable {
        private final SVNRevision myRevision;
        private final SVNRevision myPegRevision;
        private final String myURL;
        private VcsException myException;
        private byte[] myContents;

        public ContentLoader(String url, SVNRevision revision, SVNRevision pegRevision) {
            this.myURL = url;
            this.myRevision = revision;
            this.myPegRevision = pegRevision;
        }

        public VcsException getException() {
            return this.myException;
        }

        private byte[] getContents() {
            return this.myContents;
        }

        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myURL));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                this.myContents = SvnUtil.getFileContents(SvnFileRevision.this.myVCS, SvnTarget.fromURL((SVNURL)SvnUtil.parseUrl(this.myURL)), this.myRevision, this.myPegRevision);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }
    }
}

