/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnPropertyService {
    private SvnPropertyService() {
    }

    public static void doAddToIgnoreProperty(@NotNull SvnVcs vcs, boolean useCommonExtension, VirtualFile[] file, IgnoreInfoGetter getter) throws VcsException {
        IgnorePropertyAdder adder = new IgnorePropertyAdder(vcs, useCommonExtension);
        adder.execute(file, getter);
    }

    public static void doRemoveFromIgnoreProperty(@NotNull SvnVcs vcs, boolean useCommonExtension, VirtualFile[] file, IgnoreInfoGetter getter) throws VcsException {
        IgnorePropertyRemover remover = new IgnorePropertyRemover(vcs, useCommonExtension);
        remover.execute(file, getter);
    }

    public static void doCheckIgnoreProperty(@NotNull SvnVcs vcs, VirtualFile[] file, IgnoreInfoGetter getter, String extensionPattern, Ref<Boolean> filesOk, Ref<Boolean> extensionOk) {
        IgnorePropertyChecker checker = new IgnorePropertyChecker(vcs, extensionPattern);
        try {
            checker.execute(file, getter);
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        filesOk.set((Object)checker.filesOk());
        extensionOk.set((Object)checker.extensionOk());
    }

    private static String getNewPropertyValueForRemove(Collection<String> data, @NotNull String propertyValue) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(propertyValue, "\r\n ");
        while (st.hasMoreElements()) {
            String ignorePattern = (String)st.nextElement();
            if (data.contains(ignorePattern)) continue;
            sb.append(ignorePattern).append('\n');
        }
        return sb.toString();
    }

    private static class IgnorePropertyAdder
    extends IgnorePropertyAddRemoveTemplate {
        private IgnorePropertyAdder(@NotNull SvnVcs vcs, boolean useCommonExtension) {
            super(vcs, useCommonExtension);
        }

        @Override
        protected String getNewPropertyValue(Set<String> data, PropertyValue propertyValue) {
            String ignoreString;
            if (data.size() == 1) {
                ignoreString = data.iterator().next();
            } else {
                StringBuilder sb = new StringBuilder();
                for (String name : data) {
                    sb.append(name).append('\n');
                }
                ignoreString = sb.toString();
            }
            return propertyValue == null ? ignoreString : PropertyValue.toString(propertyValue) + '\n' + ignoreString;
        }
    }

    private static class IgnorePropertyRemover
    extends IgnorePropertyAddRemoveTemplate {
        private IgnorePropertyRemover(@NotNull SvnVcs vcs, boolean useCommonExtension) {
            super(vcs, useCommonExtension);
        }

        @Override
        protected String getNewPropertyValue(Set<String> data, PropertyValue propertyValue) {
            if (propertyValue != null) {
                return SvnPropertyService.getNewPropertyValueForRemove(data, PropertyValue.toString(propertyValue));
            }
            return "";
        }
    }

    private static abstract class IgnorePropertyAddRemoveTemplate
    extends IgnorePropertyWorkTemplate {
        private final Collection<String> exceptions = new ArrayList<String>();
        private final VcsDirtyScopeManager dirtyScopeManager;

        private IgnorePropertyAddRemoveTemplate(@NotNull SvnVcs vcs, boolean useCommonExtension) {
            super(vcs, useCommonExtension, false);
            this.dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)vcs.getProject());
        }

        @Override
        protected boolean stopIteration() {
            return false;
        }

        protected abstract String getNewPropertyValue(Set<String> var1, PropertyValue var2);

        @Override
        protected void processFolder(VirtualFile folder, File folderDir, Set<String> data, PropertyValue propertyValue) throws VcsException {
            String newValue = this.getNewPropertyValue(data, propertyValue);
            newValue = newValue.trim().isEmpty() ? null : newValue;
            this.myVcs.getFactory(folderDir).createPropertyClient().setProperty(folderDir, "svn:ignore", PropertyValue.create(newValue), Depth.EMPTY, false);
            if (this.myUseCommonExtension) {
                this.dirtyScopeManager.dirDirtyRecursively(folder);
            }
        }

        @Override
        protected void onAfterProcessing(VirtualFile[] file) throws VcsException {
            if (!this.myUseCommonExtension) {
                for (VirtualFile virtualFile : file) {
                    this.dirtyScopeManager.fileDirty(virtualFile);
                }
            }
            if (!this.exceptions.isEmpty()) {
                throw new VcsException(this.exceptions);
            }
        }

        @Override
        protected void onSVNException(Exception e) {
            this.exceptions.add(e.getMessage());
        }
    }

    private static class IgnorePropertyChecker
    extends IgnorePropertyWorkTemplate {
        private final String myExtensionPattern;
        private boolean myFilesOk;
        private boolean myExtensionOk;

        private IgnorePropertyChecker(@NotNull SvnVcs vcs, String extensionPattern) {
            super(vcs, false, true);
            this.myExtensionPattern = extensionPattern;
            this.myExtensionOk = true;
            this.myFilesOk = true;
        }

        @Override
        protected boolean stopIteration() {
            return !this.myFilesOk && !this.myExtensionOk;
        }

        @Override
        protected void processFolder(VirtualFile folder, File folderDir, Set<String> data, PropertyValue propertyValue) throws VcsException {
            if (propertyValue == null) {
                this.myFilesOk = false;
                this.myExtensionOk = false;
                return;
            }
            HashSet<String> ignorePatterns = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(PropertyValue.toString(propertyValue), "\r\n ");
            while (st.hasMoreElements()) {
                String ignorePattern = (String)st.nextElement();
                ignorePatterns.add(ignorePattern);
            }
            this.myExtensionOk &= ignorePatterns.contains(this.myExtensionPattern);
            for (String fileName : data) {
                if (ignorePatterns.contains(fileName)) continue;
                this.myFilesOk = false;
            }
        }

        @Override
        protected void onAfterProcessing(VirtualFile[] file) throws VcsException {
        }

        @Override
        protected void onSVNException(Exception e) {
            this.myFilesOk = false;
            this.myExtensionOk = false;
        }

        public boolean filesOk() {
            return this.myFilesOk;
        }

        public boolean extensionOk() {
            return this.myExtensionOk;
        }
    }

    private static abstract class IgnorePropertyWorkTemplate {
        @NotNull
        protected final SvnVcs myVcs;
        protected final boolean myUseCommonExtension;
        protected final boolean myCanUseCachedProperty;

        protected abstract void processFolder(VirtualFile var1, File var2, Set<String> var3, PropertyValue var4) throws VcsException;

        protected abstract void onAfterProcessing(VirtualFile[] var1) throws VcsException;

        protected abstract void onSVNException(Exception var1);

        protected abstract boolean stopIteration();

        private IgnorePropertyWorkTemplate(@NotNull SvnVcs vcs, boolean useCommonExtension, boolean canUseCachedProperty) {
            this.myVcs = vcs;
            this.myCanUseCachedProperty = canUseCachedProperty;
            this.myUseCommonExtension = useCommonExtension;
        }

        public void execute(VirtualFile[] file, IgnoreInfoGetter getter) throws VcsException {
            Map<VirtualFile, Set<String>> foldersInfo = getter.getInfo(this.myUseCommonExtension);
            for (Map.Entry<VirtualFile, Set<String>> entry : foldersInfo.entrySet()) {
                if (this.stopIteration()) break;
                File dir = new File(entry.getKey().getPath());
                try {
                    PropertyValue value = this.myCanUseCachedProperty ? this.myVcs.getPropertyWithCaching(entry.getKey(), "svn:ignore") : this.myVcs.getFactory(dir).createPropertyClient().getProperty(SvnTarget.fromFile((File)dir), "svn:ignore", false, SVNRevision.WORKING);
                    this.processFolder(entry.getKey(), dir, entry.getValue(), value);
                }
                catch (VcsException e) {
                    this.onSVNException((Exception)((Object)e));
                }
            }
            this.onAfterProcessing(file);
        }
    }
}

