/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QuantitySelection<T> {
    @NotNull
    private final Group<T> mySelected = new Group();
    @NotNull
    private final Group<T> myUnselected = new Group();

    public QuantitySelection(boolean startFromSelectAll) {
        if (startFromSelectAll) {
            this.mySelected.setAll();
        } else {
            this.myUnselected.setAll();
        }
    }

    public void add(T t) {
        if (this.mySelected.hasAll()) {
            this.myUnselected.remove(t);
        } else {
            this.mySelected.add(t);
        }
    }

    public void remove(T t) {
        if (this.mySelected.hasAll()) {
            this.myUnselected.add(t);
        } else {
            this.mySelected.remove(t);
        }
    }

    public void clearAll() {
        this.mySelected.clearAll();
        this.myUnselected.setAll();
    }

    public void setAll() {
        this.myUnselected.clearAll();
        this.mySelected.setAll();
    }

    @NotNull
    public Set<T> getSelected() {
        return this.mySelected.getItems();
    }

    @NotNull
    public Set<T> getUnselected() {
        return this.myUnselected.getItems();
    }

    public boolean isSelected(T t) {
        return this.mySelected.hasAll() && !this.myUnselected.has(t) || this.myUnselected.hasAll() && this.mySelected.has(t);
    }

    public boolean areAllSelected() {
        return this.mySelected.hasAll();
    }

    private static class Group<T> {
        private boolean myAll;
        @NotNull
        private final Set<T> myItems = ContainerUtil.newHashSet();

        private Group() {
        }

        public void add(T t) {
            this.myItems.add(t);
        }

        public void remove(T t) {
            this.myAll = false;
            this.myItems.remove(t);
        }

        public void clearAll() {
            this.myAll = false;
            this.myItems.clear();
        }

        public void setAll() {
            this.myAll = true;
            this.myItems.clear();
        }

        @NotNull
        public Set<T> getItems() {
            return this.myItems;
        }

        public boolean hasAll() {
            return this.myAll;
        }

        public boolean has(T t) {
            return this.myItems.contains(t);
        }
    }
}

