/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.Topic;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.tmatesoft.svn.core.SVNURL;

public class SvnMergeInfoCache {
    private static final Logger LOG = Logger.getInstance(SvnMergeInfoCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, MyCurrentUrlData> myCurrentUrlMapping;
    public static Topic<SvnMergeInfoCacheListener> SVN_MERGE_INFO_CACHE = new Topic("SVN_MERGE_INFO_CACHE", SvnMergeInfoCacheListener.class);

    private SvnMergeInfoCache(@NotNull Project project) {
        this.myProject = project;
        this.myCurrentUrlMapping = ContainerUtil.newHashMap();
    }

    public static SvnMergeInfoCache getInstance(@NotNull Project project) {
        return (SvnMergeInfoCache)PeriodicalTasksCloser.getInstance().safeGetService(project, SvnMergeInfoCache.class);
    }

    public void clear(@NotNull WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo = this.getBranchInfo(info, branchPath);
        if (branchInfo != null) {
            branchInfo.clear();
        }
    }

    @Nullable
    public MergeInfoCached getCachedState(@NotNull WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo = this.getBranchInfo(info, branchPath);
        return branchInfo != null ? branchInfo.getCached() : null;
    }

    public MergeCheckResult getState(@NotNull WCInfoWithBranches info, @NotNull SvnChangeList list, @NotNull WCInfoWithBranches.Branch selectedBranch, String branchPath) {
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info.getRootUrl());
        BranchInfo mergeChecker = null;
        if (rootMapping == null) {
            rootMapping = new MyCurrentUrlData();
            this.myCurrentUrlMapping.put(info.getRootUrl(), rootMapping);
        } else {
            mergeChecker = rootMapping.getBranchInfo(branchPath);
        }
        if (mergeChecker == null) {
            mergeChecker = new BranchInfo(SvnVcs.getInstance(this.myProject), info, selectedBranch);
            rootMapping.addBranchInfo(branchPath, mergeChecker);
        }
        return mergeChecker.checkList(list, branchPath);
    }

    public boolean isMixedRevisions(@NotNull WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo = this.getBranchInfo(info, branchPath);
        return branchInfo != null && branchInfo.isMixedRevisionsFound();
    }

    @Nullable
    private BranchInfo getBranchInfo(@NotNull WCInfoWithBranches info, String branchPath) {
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info.getRootUrl());
        return rootMapping != null ? rootMapping.getBranchInfo(branchPath) : null;
    }

    public static interface SvnMergeInfoCacheListener {
        public void copyRevisionUpdated();
    }

    private static class MyCurrentUrlData {
        @NotNull
        private final Map<String, BranchInfo> myBranchInfo = new SoftHashMap();

        private MyCurrentUrlData() {
        }

        public BranchInfo getBranchInfo(String branchUrl) {
            return this.myBranchInfo.get(branchUrl);
        }

        public void addBranchInfo(@NotNull String branchUrl, @NotNull BranchInfo mergeChecker) {
            this.myBranchInfo.put(branchUrl, mergeChecker);
        }
    }

    static class CopyRevison {
        private final String myPath;
        private volatile long myRevision;

        CopyRevison(final SvnVcs vcs, String path, final @NotNull SVNURL repositoryRoot, final String branchUrl, final String trunkUrl) {
            this.myPath = path;
            this.myRevision = -1L;
            Task.Backgroundable task = new Task.Backgroundable(vcs.getProject(), "", false){
                private CopyData myData;

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        this.myData = new FirstInBranch(vcs, repositoryRoot, branchUrl, trunkUrl).run();
                    }
                    catch (VcsException e) {
                        this.logAndShow(e);
                    }
                }

                public void onSuccess() {
                    if (!vcs.getProject().isDisposed() && this.myData != null && this.myData.getCopySourceRevision() != -1L) {
                        ((SvnMergeInfoCacheListener)vcs.getProject().getMessageBus().syncPublisher(SVN_MERGE_INFO_CACHE)).copyRevisionUpdated();
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    this.logAndShow(error);
                }

                private void logAndShow(@NotNull Throwable error) {
                    LOG.info(error);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)error.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new EmptyProgressIndicator());
        }

        public String getPath() {
            return this.myPath;
        }

        public long getRevision() {
            return this.myRevision;
        }
    }

    public static enum MergeCheckResult {
        COMMON,
        MERGED,
        NOT_MERGED,
        NOT_EXISTS;


        @NotNull
        public static MergeCheckResult getInstance(boolean merged) {
            return merged ? MERGED : NOT_MERGED;
        }
    }
}

