/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.FilePathByPathComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.update.MultipleRootEditorWithSplitter;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.tmatesoft.svn.core.SVNURL;

public abstract class AbstractSvnUpdatePanel {
    protected final SvnVcs myVCS;
    private final Map<FilePath, SvnPanel> myRootToPanel = new LinkedHashMap<FilePath, SvnPanel>();

    public AbstractSvnUpdatePanel(SvnVcs vcs) {
        this.myVCS = vcs;
    }

    protected void init(Collection<FilePath> roots) {
        JPanel configureRootsPanel = this.getRootsPanel();
        configureRootsPanel.setLayout(new BorderLayout());
        ArrayList<FilePath> rootsCopy = new ArrayList<FilePath>(roots);
        Collections.sort(rootsCopy, FilePathByPathComparator.getInstance());
        for (FilePath root : rootsCopy) {
            SVNURL url = this.getUrlFor(root);
            if (url != null) {
                this.myRootToPanel.put(root, this.createRootPanel(root, this.myVCS, roots));
            }
            Container parent = configureRootsPanel.getParent();
            parent.remove(configureRootsPanel);
            parent.setLayout(new BorderLayout());
            JPanel additionalPanel = this.getAdditionalPanel();
            if (additionalPanel != null) {
                parent.remove(additionalPanel);
            }
            if (this.myRootToPanel.size() == 1) {
                configureRootsPanel.add((Component)this.myRootToPanel.values().iterator().next().getPanel(), "Center");
                parent.add((Component)configureRootsPanel, "North");
                if (additionalPanel == null) continue;
                parent.add((Component)additionalPanel, "Center");
                continue;
            }
            MultipleRootEditorWithSplitter multipleRootsEditor = new MultipleRootEditorWithSplitter(this.myRootToPanel, this.myVCS.getProject());
            configureRootsPanel.add((Component)multipleRootsEditor, "Center");
            parent.add((Component)configureRootsPanel, "Center");
            if (additionalPanel == null) continue;
            parent.add((Component)additionalPanel, "South");
        }
    }

    protected abstract SvnPanel createRootPanel(FilePath var1, SvnVcs var2, Collection<FilePath> var3);

    protected abstract JPanel getRootsPanel();

    protected JPanel getAdditionalPanel() {
        return null;
    }

    public void reset(SvnConfiguration configuration) {
        this.getDepthBox().setSelectedItem((Object)configuration.getUpdateDepth());
        for (FilePath filePath : this.myRootToPanel.keySet()) {
            this.myRootToPanel.get(filePath).reset(configuration);
        }
    }

    public void apply(SvnConfiguration configuration) throws ConfigurationException {
        configuration.setUpdateDepth(this.getDepthBox().getDepth());
        for (FilePath filePath : this.myRootToPanel.keySet()) {
            SvnPanel svnPanel = this.myRootToPanel.get(filePath);
            if (!svnPanel.canApply()) continue;
            svnPanel.apply(configuration);
        }
    }

    @Nullable
    private SVNURL getUrlFor(@NotNull FilePath root) {
        Info info = this.myVCS.getInfo(root.getIOFile());
        return info != null ? info.getURL() : null;
    }

    protected abstract JComponent getPanel();

    protected abstract DepthCombo getDepthBox();
}

