/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnKitUpdateClient
extends BaseSvnClient
implements UpdateClient {
    @Nullable
    protected ProgressTracker myDispatcher;
    protected boolean myIgnoreExternals;
    protected boolean myLocksOnDemand;

    @Override
    public long doUpdate(File path, SVNRevision revision, Depth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SvnBindException {
        try {
            return this.getClient().doUpdate(path, revision, SvnKitUpdateClient.toDepth(depth), allowUnversionedObstructions, depthIsSticky);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, Depth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SvnBindException {
        try {
            return this.getClient().doSwitch(path, url, pegRevision, revision, SvnKitUpdateClient.toDepth(depth), allowUnversionedObstructions, depthIsSticky);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setUpdateLocksOnDemand(boolean locksOnDemand) {
        this.myLocksOnDemand = locksOnDemand;
    }

    @Override
    public void setEventHandler(ProgressTracker dispatcher) {
        this.myDispatcher = dispatcher;
    }

    @Override
    public void setIgnoreExternals(boolean ignoreExternals) {
        this.myIgnoreExternals = ignoreExternals;
    }

    @NotNull
    private SVNUpdateClient getClient() {
        SVNUpdateClient client = this.myVcs.getSvnKitManager().createUpdateClient();
        client.setEventHandler(SvnKitUpdateClient.toEventHandler(this.myDispatcher));
        client.setIgnoreExternals(this.myIgnoreExternals);
        client.setUpdateLocksOnDemand(this.myLocksOnDemand);
        return client;
    }
}

