/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.update.SvnSelectRevisionUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRevisionPanel
extends JPanel {
    private JRadioButton mySpecified;
    private JRadioButton myHead;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myRevisionField;
    private Project myProject;
    private UrlProvider myUrlProvider;
    private final List<ChangeListener> myChangeListeners;
    private VirtualFile myRoot;

    public SvnRevisionPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.add(this.myPanel);
        this.myHead.setSelected(true);
        this.myRevisionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnRevisionPanel.this.chooseRevision();
            }
        });
        this.myRevisionField.setEnabled(false);
        this.mySpecified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SvnRevisionPanel.this.mySpecified.isSelected()) {
                    if (SvnRevisionPanel.this.myRevisionField.getText().trim().length() == 0) {
                        SvnRevisionPanel.this.myRevisionField.setText("HEAD");
                    }
                    SvnRevisionPanel.this.myRevisionField.setEnabled(true);
                } else {
                    SvnRevisionPanel.this.myRevisionField.setEnabled(false);
                }
                SvnRevisionPanel.this.notifyChangeListeners();
            }
        });
        this.myHead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnRevisionPanel.this.myRevisionField.setEnabled(false);
                SvnRevisionPanel.this.notifyChangeListeners();
            }
        });
        this.myRevisionField.getTextField().setColumns(10);
        this.myRevisionField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SvnRevisionPanel.this.notifyChangeListeners();
            }
        });
    }

    private void chooseRevision() {
        SvnRepositoryLocation location;
        SvnChangeList version;
        if (this.myProject != null && this.myUrlProvider != null && (version = SvnSelectRevisionUtil.chooseCommittedChangeList(this.myProject, location = new SvnRepositoryLocation(this.myUrlProvider.getUrl()), this.myRoot)) != null) {
            this.myRevisionField.setText(String.valueOf(version.getNumber()));
        }
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setRoot(VirtualFile root) {
        this.myRoot = root;
    }

    public void setUrlProvider(UrlProvider urlProvider) {
        this.myUrlProvider = urlProvider;
    }

    public String getRevisionText() {
        return this.myHead.isSelected() ? SVNRevision.HEAD.toString() : this.myRevisionField.getText();
    }

    @NotNull
    public SVNRevision getRevision() throws ConfigurationException {
        if (this.myHead.isSelected()) {
            return SVNRevision.HEAD;
        }
        SVNRevision result = SVNRevision.parse((String)this.myRevisionField.getText());
        if (!result.isValid()) {
            throw new ConfigurationException(SvnBundle.message("invalid.svn.revision.error.message", this.myRevisionField.getText()));
        }
        return result;
    }

    public void setRevisionText(String text) {
        this.myRevisionField.setText(text);
    }

    public void setRevision(SVNRevision revision) {
        if (revision == SVNRevision.HEAD) {
            this.myHead.setSelected(true);
            this.myRevisionField.setEnabled(false);
        } else {
            this.myRevisionField.setText(String.valueOf(revision.getNumber()));
            this.mySpecified.setSelected(true);
            this.myRevisionField.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.myHead.setEnabled(false);
            this.mySpecified.setEnabled(false);
            this.myRevisionField.setEnabled(false);
        } else {
            this.myHead.setEnabled(true);
            this.mySpecified.setEnabled(true);
            this.myRevisionField.setEnabled(this.mySpecified.isSelected());
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myChangeListeners.remove(listener);
    }

    private void notifyChangeListeners() {
        for (ChangeListener listener : this.myChangeListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHead = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.revision.head.radio"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySpecified = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.revision.specified.radio"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRevisionField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface UrlProvider {
        public String getUrl();
    }
}

