/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesReferenceProvider;
import com.intellij.lang.properties.ResourceBundleReferenceProvider;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final Logger LOG = Logger.getInstance(PropertiesReferenceContributor.class);
    private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider(){

        public boolean isSoft() {
            return true;
        }
    };

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression(), (PsiReferenceProvider)new PropertiesReferenceProvider(true));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().withParent((ElementPattern)PsiJavaPatterns.psiNameValuePair().withName("resourceBundle")), (PsiReferenceProvider)new ResourceBundleReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression(), new PsiReferenceProvider(){
            private final PsiReferenceProvider myUnderlying = new ResourceBundleReferenceProvider();

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiField)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiField field = (PsiField)parent;
                if (field.getInitializer() != element || !field.hasModifierProperty("final") || !field.getType().equalsToText("java.lang.String")) {
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList references = new ArrayList();
                PsiClass propertyKeyAnnotation = JavaPsiFacade.getInstance((Project)element.getProject()).findClass("org.jetbrains.annotations.PropertyKey", element.getResolveScope());
                if (propertyKeyAnnotation != null) {
                    AnnotatedElementsSearch.searchPsiParameters((PsiClass)propertyKeyAnnotation, (SearchScope)new LocalSearchScope((PsiElement)element.getContainingFile())).forEach(parameter -> {
                        PsiModifierList list = parameter.getModifierList();
                        LOG.assertTrue(list != null);
                        PsiAnnotation annotation = list.findAnnotation("org.jetbrains.annotations.PropertyKey");
                        LOG.assertTrue(annotation != null);
                        for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                            PsiAnnotationMemberValue value;
                            if (!"resourceBundle".equals(pair.getName()) || !((value = pair.getValue()) instanceof PsiReferenceExpression) || ((PsiReferenceExpression)value).resolve() != field) continue;
                            Collections.addAll(references, this.myUnderlying.getReferencesByElement(element, context));
                            return false;
                        }
                        return true;
                    });
                }
                return references.toArray(new PsiReference[references.size()]);
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiElement(PropertyValueImpl.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String text = element.getText();
                String[] words = text.split("\\s");
                if (words.length != 1) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return CLASS_REFERENCE_PROVIDER.getReferencesByString(words[0], element, 0);
            }
        });
    }
}

