/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.progress;

import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class RangeProgressViewer
implements IProgressViewer {
    private final IProgressViewer parentProgressViewer;
    private final double lowerBound;
    private final double upperBound;

    public static IProgressViewer createInstance(IProgressViewer parentProgressViewer, long currentIndex, long indexCount) {
        BugLog.getInstance().assertNotNull(parentProgressViewer);
        BugLog.getInstance().assertTrue(currentIndex >= 0L, "");
        BugLog.getInstance().assertTrue(currentIndex < indexCount, "");
        if (currentIndex == 0L && indexCount == 1L) {
            return parentProgressViewer;
        }
        double lowerBound = 1.0 * (double)currentIndex / (double)indexCount;
        double upperBound = 1.0 * (double)(currentIndex + 1L) / (double)indexCount;
        return new RangeProgressViewer(parentProgressViewer, lowerBound, upperBound);
    }

    public RangeProgressViewer(IProgressViewer parentProgressViewer, double lowerBound, double upperBound) {
        BugLog.getInstance().assertNotNull(parentProgressViewer);
        this.parentProgressViewer = parentProgressViewer;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public void setProgress(double value) {
        double boundedValue = (1.0 - value) * this.lowerBound + value * this.upperBound;
        this.parentProgressViewer.setProgress(boundedValue);
    }
}

