/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.internal.incremental.InstantRunApiLevelMode;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.utils.FileCache;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.Channel;
import com.android.sdklib.AndroidVersion;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;

public class AndroidGradleOptions {
    private static final boolean DEFAULT_ENABLE_AAPT2 = false;
    private static final boolean DEFAULT_ENABLE_BUILD_CACHE = true;
    public static final String PROPERTY_TEST_RUNNER_ARGS = "android.testInstrumentationRunnerArguments.";
    public static final String PROPERTY_THREAD_POOL_SIZE = "android.threadPoolSize";
    public static final String PROPERTY_THREAD_POOL_SIZE_OLD = "com.android.build.threadPoolSize";
    public static final String USE_DEPRECATED_NDK = "android.useDeprecatedNdk";
    public static final String PROPERTY_DISABLE_RESOURCE_VALIDATION = "android.disableResourceValidation";
    public static final String PROPERTY_INCREMENTAL_JAVA_COMPILE = "android.incrementalJavaCompile";
    public static final String PROPERTY_KEEP_TIMESTAMPS_IN_APK = "android.keepTimestampsInApk";
    public static final String PROPERTY_ENABLE_AAPT2 = "android.enableAapt2";
    public static final String ANDROID_ADDITIONAL_PLUGINS = "android.additional.plugins";
    public static final String ANDROID_SDK_CHANNEL = "android.sdk.channel";
    public static final String PROPERTY_BUILD_ONLY_TARGET_ABI = "android.buildOnlyTargetAbi";
    public static final String PROPERTY_SHARD_TESTS_BETWEEN_DEVICES = "android.androidTest.shardBetweenDevices";
    public static final String PROPERTY_SHARD_COUNT = "android.androidTest.numShards";
    public static final String PROPERTY_USE_SDK_DOWNLOAD = "android.builder.sdkDownload";
    public static final String PROPERTY_ENABLE_BUILD_CACHE = "android.enableBuildCache";
    public static final String PROPERTY_BUILD_CACHE_DIR = "android.buildCacheDir";
    public static final String PROPERTY_ENABLE_IMPROVED_DEPENDENCY_RESOLUTION = "android.enableImprovedDependenciesResolution";
    public static final String GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "android.overrideVersionCheck";
    public static final String OLD_GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "com.android.build.gradle.overrideVersionCheck";
    public static final String OVERRIDE_PATH_CHECK_PROPERTY = "android.overridePathCheck";
    public static final String OLD_OVERRIDE_PATH_CHECK_PROPERTY = "com.android.build.gradle.overridePathCheck";
    public static final String INSTANT_RUN_API_LEVEL_PROPERTY = "android.instantRun.apiLevel";

    public static void validate(Project project) {
        if (AndroidGradleOptions.isImprovedDependencyResolutionEnabled(project) && !AndroidGradleOptions.isBuildCacheEnabled(project)) {
            throw new InvalidUserDataException("Build cache must be enable to use improved dependency resolution.  Set -Pandroid.enableBuildCache=true to continue.");
        }
    }

    public static boolean getUseSdkDownload(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_USE_SDK_DOWNLOAD, true) && !AndroidGradleOptions.invokedFromIde(project);
    }

    public static Map<String, String> getExtraInstrumentationTestRunnerArgs(Project project) {
        HashMap argsMap = Maps.newHashMap();
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROPERTY_TEST_RUNNER_ARGS)) continue;
            String argName = ((String)entry.getKey()).substring(PROPERTY_TEST_RUNNER_ARGS.length());
            String argValue = entry.getValue().toString();
            argsMap.put(argName, argValue);
        }
        return argsMap;
    }

    public static boolean getShardAndroidTestsBetweenDevices(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_SHARD_TESTS_BETWEEN_DEVICES, false);
    }

    public static Integer getInstrumentationShardCount(Project project) {
        return AndroidGradleOptions.getInteger(project, PROPERTY_SHARD_COUNT);
    }

    public static boolean invokedFromIde(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.invoked.from.ide");
    }

    public static boolean buildModelOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only");
    }

    public static boolean refreshExternalNativeModel(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.refresh.external.native.model");
    }

    public static boolean buildModelOnlyAdvanced(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced");
    }

    public static boolean generateSourcesOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.generateSourcesOnly");
    }

    public static boolean keepTimestampsInApk(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_KEEP_TIMESTAMPS_IN_APK);
    }

    public static boolean isAapt2Enabled(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_ENABLE_AAPT2, false);
    }

    public static boolean getTestOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.testOnly");
    }

    public static Integer buildModelOnlyVersion(Project project) {
        String revision = AndroidGradleOptions.getString(project, "android.injected.build.model.only.versioned");
        if (revision != null) {
            return Integer.parseInt(revision);
        }
        if (AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced")) {
            return 1;
        }
        if (AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only")) {
            return 0;
        }
        return null;
    }

    public static boolean buildModelWithFullDependencies(Project project) {
        String value = AndroidGradleOptions.getString(project, "android.injected.build.model.feature.full.dependencies");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static File getApkLocation(Project project) {
        String locString = AndroidGradleOptions.getString(project, "android.injected.apk.location");
        if (locString == null) {
            return null;
        }
        return project.file((Object)locString);
    }

    public static String getBuildTargetDensity(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.density");
    }

    public static boolean isBuildOnlyTargetAbiEnabled(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_BUILD_ONLY_TARGET_ABI);
    }

    public static String getBuildTargetAbi(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.abi");
    }

    public static int getTargetFeatureLevel(Project project) {
        String featureLevelString = AndroidGradleOptions.getString(project, "android.injected.build.api");
        if (featureLevelString == null) {
            return AndroidVersion.DEFAULT.getFeatureLevel();
        }
        try {
            return Integer.parseInt(featureLevelString);
        }
        catch (NumberFormatException ignore) {
            project.getLogger().warn("Wrong build target version passed ", (Throwable)ignore);
            return AndroidVersion.DEFAULT.getFeatureLevel();
        }
    }

    public static String getColdswapMode(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.coldswap.mode");
    }

    public static boolean useDeprecatedNdk(Project project) {
        return AndroidGradleOptions.getBoolean(project, USE_DEPRECATED_NDK);
    }

    public static Integer getThreadPoolSize(Project project) {
        Integer size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE);
        if (size == null) {
            size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE_OLD);
        }
        return size;
    }

    public static SigningOptions getSigningOptions(Project project) {
        String signingStoreFile = AndroidGradleOptions.getString(project, "android.injected.signing.store.file");
        String signingStorePassword = AndroidGradleOptions.getString(project, "android.injected.signing.store.password");
        String signingKeyAlias = AndroidGradleOptions.getString(project, "android.injected.signing.key.alias");
        String signingKeyPassword = AndroidGradleOptions.getString(project, "android.injected.signing.key.password");
        if (signingStoreFile != null && signingStorePassword != null && signingKeyAlias != null && signingKeyPassword != null) {
            String signingStoreType = AndroidGradleOptions.getString(project, "android.injected.signing.store.type");
            return new SigningOptions(signingStoreFile, signingStorePassword, signingKeyAlias, signingKeyPassword, signingStoreType, AndroidGradleOptions.getOptionalBoolean(project, "android.injected.signing.v1-enabled"), AndroidGradleOptions.getOptionalBoolean(project, "android.injected.signing.v2-enabled"));
        }
        return null;
    }

    public static EnumSet<OptionalCompilationStep> getOptionalCompilationSteps(Project project) {
        String values = AndroidGradleOptions.getString(project, "android.optional.compilation");
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf((String)st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    public static boolean isResourceValidationEnabled(Project project) {
        return !AndroidGradleOptions.getBoolean(project, PROPERTY_DISABLE_RESOURCE_VALIDATION);
    }

    public static Integer getVersionCodeOverride(Project project) {
        return AndroidGradleOptions.getInteger(project, "android.injected.version.code");
    }

    public static String getVersionNameOverride(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.version.name");
    }

    public static InstantRunApiLevelMode getInstantRunApiLevelMode(Project project) {
        String valueName = AndroidGradleOptions.getString(project, INSTANT_RUN_API_LEVEL_PROPERTY);
        if (valueName != null) {
            try {
                return InstantRunApiLevelMode.valueOf(valueName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return InstantRunApiLevelMode.COMPILE_SDK;
    }

    public static boolean isImprovedDependencyResolutionEnabled(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_ENABLE_IMPROVED_DEPENDENCY_RESOLUTION);
    }

    private static String getString(Project project, String propertyName) {
        return project.hasProperty(propertyName) ? project.property(propertyName).toString() : null;
    }

    private static Integer getInteger(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            try {
                return Integer.parseInt(project.property(propertyName).toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Property " + propertyName + " needs to be an integer.");
            }
        }
        return null;
    }

    private static boolean getBoolean(Project project, String propertyName) {
        return AndroidGradleOptions.getBoolean(project, propertyName, false);
    }

    private static Boolean getOptionalBoolean(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            return AndroidGradleOptions.getBoolean(project, propertyName);
        }
        return null;
    }

    private static boolean getBoolean(Project project, String propertyName, boolean defaultValue) {
        if (project.hasProperty(propertyName)) {
            Object value = project.property(propertyName);
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return defaultValue;
    }

    public static boolean isJavaCompileIncrementalPropertySet(Project project) {
        return project.hasProperty(PROPERTY_INCREMENTAL_JAVA_COMPILE);
    }

    public static String[] getAdditionalPlugins(Project project) {
        String string = AndroidGradleOptions.getString(project, ANDROID_ADDITIONAL_PLUGINS);
        return string == null ? new String[]{} : string.split(",");
    }

    public static String getRestrictVariantProject(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.restrict.variant.project");
    }

    public static String getRestrictVariantName(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.restrict.variant.name");
    }

    public static boolean isBuildCacheEnabled(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_ENABLE_BUILD_CACHE, true);
    }

    public static File getBuildCacheDir(Project project) {
        String buildCacheDir = AndroidGradleOptions.getString(project, PROPERTY_BUILD_CACHE_DIR);
        if (buildCacheDir != null) {
            return project.getRootProject().file((Object)buildCacheDir);
        }
        try {
            return new File(AndroidLocation.getFolder(), "build-cache");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<FileCache> getBuildCache(Project project) {
        if (AndroidGradleOptions.isBuildCacheEnabled(project)) {
            File buildCacheDir = AndroidGradleOptions.getBuildCacheDir(project);
            try {
                return Optional.of(FileCache.getInstanceWithInterProcessLocking((File)buildCacheDir));
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Unable to create the build cache at '%1$s'.\n%2$s", buildCacheDir.getAbsolutePath(), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html."), exception);
            }
        }
        return Optional.empty();
    }

    public static Channel getSdkChannel(Project project) {
        Integer channel = AndroidGradleOptions.getInteger(project, ANDROID_SDK_CHANNEL);
        if (channel != null) {
            return Channel.create((int)channel);
        }
        return Channel.DEFAULT;
    }

    public static boolean overrideGradleVersionCheck(Project project) {
        if (project.hasProperty(GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
        }
        return Boolean.getBoolean(OLD_GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
    }

    public static boolean overridePathCheck(Project project) {
        if (project.hasProperty(OVERRIDE_PATH_CHECK_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, OVERRIDE_PATH_CHECK_PROPERTY);
        }
        if (project.hasProperty(OLD_OVERRIDE_PATH_CHECK_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, OLD_OVERRIDE_PATH_CHECK_PROPERTY);
        }
        return Boolean.getBoolean(OLD_OVERRIDE_PATH_CHECK_PROPERTY);
    }

    public static class SigningOptions {
        public final String storeFile;
        public final String storePassword;
        public final String keyAlias;
        public final String keyPassword;
        public final String storeType;
        public final Boolean v1Enabled;
        public final Boolean v2Enabled;

        SigningOptions(String storeFile, String storePassword, String keyAlias, String keyPassword, String storeType, Boolean v1Enabled, Boolean v2Enabled) {
            this.storeFile = storeFile;
            this.storeType = storeType;
            this.storePassword = storePassword;
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
            this.v1Enabled = v1Enabled;
            this.v2Enabled = v2Enabled;
        }
    }
}

