/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.DefaultGradlePackagingScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.InstantRunDependenciesApkBuilder;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.tasks.AndroidJarTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        assert (variantData instanceof ApplicationVariantData);
        VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.handleMicroApp(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAppManifestsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createApkProcessResTask(tasks, variantScope);
            this.createProcessJavaResTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(tasks, variantScope));
        if (!this.isComponentModelPlugin) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(tasks, variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, (Object)this.getNdkBuildable(variantData));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            CoreJackOptions jackOptions = variantData.getVariantConfiguration().getJackOptions();
            this.createDataBindingMergeArtifactsTaskIfNecessary(tasks, variantScope);
            AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
            if (jackOptions.isEnabled().booleanValue()) {
                AndroidTask<TransformTask> jackTask = this.createJackTask(tasks, variantScope, true);
                ApplicationTaskManager.setJavaCompilerTask(jackTask, tasks, variantScope);
            } else {
                if (variantScope.getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                    if (this.project.getPlugins().hasPlugin("me.tatarka.retrolambda") || this.project.getPlugins().hasPlugin("dexguard")) {
                        this.getLogger().warn("Jack is disabled, but one of the plugins you are using supports Java 8 language features.");
                    } else {
                        this.androidBuilder.getErrorReporter().handleSyncError(variantScope.getVariantConfiguration().getFullName(), 18, "Jack is required to support java 8 language features. Either enable Jack or remove sourceCompatibility JavaVersion.VERSION_1_8.");
                    }
                }
                ApplicationTaskManager.addJavacClassesStream(variantScope);
                ApplicationTaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
                this.getAndroidTasks().create(tasks, new AndroidJarTask.JarClassesConfigAction(variantScope));
                this.createPostCompilationTasks(tasks, variantScope);
            }
        });
        this.createDataBindingTasksIfNecessary(tasks, variantScope);
        ApplicationTaskManager.createStripNativeLibraryTask(tasks, variantScope);
        if (variantData.getSplitHandlingPolicy().equals((Object)SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY)) {
            if (this.getExtension().getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SPLIT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createSplitTasks(tasks, variantScope));
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PACKAGING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            AndroidTask<BuildInfoWriterTask> fullBuildInfoGeneratorTask = this.createInstantRunPackagingTasks(tasks, variantScope);
            this.createPackagingTask(tasks, variantScope, true, fullBuildInfoGeneratorTask);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_LINT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createLintTasks(tasks, variantScope));
    }

    protected AndroidTask<BuildInfoWriterTask> createInstantRunPackagingTasks(TaskFactory tasks, VariantScope variantScope) {
        if (this.getIncrementalMode(variantScope.getVariantConfiguration()) == TaskManager.IncrementalMode.NONE) {
            return null;
        }
        AndroidTask<BuildInfoWriterTask> buildInfoGeneratorTask = variantScope.getInstantRunTaskManager().createBuildInfoWriterTask(new AndroidTask[0]);
        InstantRunPatchingPolicy patchingPolicy = variantScope.getInstantRunBuildContext().getPatchingPolicy();
        if (patchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
            BaseVariantOutputData outputData = variantScope.getVariantData().getMainOutput();
            DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(outputData.getScope());
            InstantRunDependenciesApkBuilder dependenciesApkBuilder = new InstantRunDependenciesApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), packagingScope, packagingScope.getSigningConfig(), packagingScope.getAaptOptions(), new File(packagingScope.getInstantRunSplitApkOutputFolder(), "dep"), packagingScope.getInstantRunSupportDir());
            Optional<AndroidTask<TransformTask>> dependenciesApkBuilderTask = variantScope.getTransformManager().addTransform(tasks, variantScope, dependenciesApkBuilder);
            dependenciesApkBuilderTask.ifPresent(task -> task.dependsOn(tasks, this.getValidateSigningTask(tasks, packagingScope)));
            InstantRunSliceSplitApkBuilder slicesApkBuilder = new InstantRunSliceSplitApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), packagingScope, packagingScope.getSigningConfig(), packagingScope.getAaptOptions(), new File(packagingScope.getInstantRunSplitApkOutputFolder(), "slices"), packagingScope.getInstantRunSupportDir());
            Optional<AndroidTask<TransformTask>> transformTaskAndroidTask = variantScope.getTransformManager().addTransform(tasks, variantScope, slicesApkBuilder);
            if (transformTaskAndroidTask.isPresent()) {
                AndroidTask<TransformTask> splitApk = transformTaskAndroidTask.get();
                variantScope.getAssembleTask().dependsOn(tasks, splitApk);
                buildInfoGeneratorTask.configure(tasks, (Action<BuildInfoWriterTask>)((Action)task -> task.mustRunAfter(new Object[]{splitApk.getName()})));
            }
            variantScope.getAssembleTask().dependsOn(tasks, buildInfoGeneratorTask);
        }
        return buildInfoGeneratorTask;
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
        if (Boolean.TRUE.equals(unbundledWearApp)) {
            if (this.hasWearAppDependency(variantData)) {
                this.androidBuilder.getErrorReporter().handleSyncError(scope.getFullVariantName(), 20, String.format("Wear app unbundling is turned on but a dependency on a wear App has been found for variant %s", scope.getFullVariantName()));
            } else {
                this.createGenerateMicroApkDataTask(tasks, scope, null);
            }
        } else if (((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
            List<String> wearConfigNames = variantData.getWearConfigNames();
            for (String configName : wearConfigNames) {
                Configuration config = (Configuration)this.project.getConfigurations().findByName(configName);
                if (config == null) continue;
                Set file = config.getFiles();
                int count = file.size();
                if (count == 1) {
                    this.createGenerateMicroApkDataTask(tasks, scope, config);
                    return;
                }
                if (count <= 1) continue;
                this.androidBuilder.getErrorReporter().handleSyncError(configName, 19, String.format("Configuration '%1$s' resolves to more than one apk.", configName));
            }
        }
    }

    private boolean hasWearAppDependency(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        List<String> wearConfigNames = variantData.getWearConfigNames();
        for (String configName : wearConfigNames) {
            Configuration config = (Configuration)this.project.getConfigurations().findByName(configName);
            if (config == null || config.getFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

