/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.AtomVariantData;
import com.android.build.gradle.internal.variant.AtomVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.tasks.AndroidJarTask;
import com.android.build.gradle.tasks.BundleAtom;
import com.android.build.gradle.tasks.GenerateAtomMetadata;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class AtomTaskManager
extends TaskManager {
    private Task assembleDefault;

    public AtomTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry, Recorder threadRecorder) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry, threadRecorder);
    }

    @Override
    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        assert (variantData instanceof AtomVariantData);
        VariantScope variantScope = variantData.getScope();
        File variantBundleDir = variantScope.getBaseBundleDir();
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeLibManifestsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            if (variantScope.getVariantConfiguration().getPackageDependencies().getBaseAtom() == null) {
                this.createApkProcessResTask(tasks, variantScope);
            } else {
                this.createProcessResTask(tasks, variantScope, variantBundleDir, false);
            }
            this.createProcessJavaResTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(tasks, variantScope));
        if (!this.isComponentModelPlugin) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(tasks, variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, (Object)this.getNdkBuildable(variantData));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createDataBindingMergeArtifactsTaskIfNecessary(tasks, variantScope);
            AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
            AtomTaskManager.addJavacClassesStream(variantScope);
            AtomTaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
            this.getAndroidTasks().create(tasks, new AndroidJarTask.JarClassesConfigAction(variantScope));
            CoreJackOptions jackOptions = variantData.getVariantConfiguration().getJackOptions();
            if (jackOptions.isEnabled().booleanValue()) {
                AndroidTask<TransformTask> jackTask = this.createJackTask(tasks, variantScope, true);
                AtomTaskManager.setJavaCompilerTask(jackTask, tasks, variantScope);
            } else {
                if (variantScope.getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                    if (this.project.getPlugins().hasPlugin("me.tatarka.retrolambda") || this.project.getPlugins().hasPlugin("dexguard")) {
                        this.getLogger().warn("Jack is disabled, but one of the plugins you are using supports Java 8 language features.");
                    } else {
                        this.androidBuilder.getErrorReporter().handleSyncError(variantScope.getVariantConfiguration().getFullName(), 18, "Jack is required to support java 8 language features. Either enable Jack or remove sourceCompatibility JavaVersion.VERSION_1_8.");
                    }
                }
                this.createPostCompilationTasks(tasks, variantScope);
            }
        });
        this.createDataBindingTasksIfNecessary(tasks, variantScope);
        AtomTaskManager.createStripNativeLibraryTask(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_BUNDLING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAtomBundlingTasks(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.ATOM_TASK_MANAGER_CREATE_LINT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createLintTasks(tasks, variantScope));
    }

    private void createAtomBundlingTasks(TaskFactory tasks, VariantScope variantScope) {
        AtomVariantData variantData = (AtomVariantData)variantScope.getVariantData();
        TransformManager transformManager = variantScope.getTransformManager();
        VariantOutputScope variantOutputScope = ((AtomVariantOutputData)variantData.getMainOutput()).getScope();
        variantOutputScope.setAssembleTask(variantScope.getAssembleTask());
        AndroidTask<GenerateAtomMetadata> generateAtomMetadata = this.getAndroidTasks().create(tasks, new GenerateAtomMetadata.ConfigAction(variantOutputScope));
        AndroidTask<BundleAtom> bundleAtom = this.getAndroidTasks().create(tasks, new BundleAtom.ConfigAction(variantScope));
        variantOutputScope.getVariantOutputData().bundleAtomTask = bundleAtom.get(tasks);
        bundleAtom.dependsOn(tasks, generateAtomMetadata);
        bundleAtom.dependsOn(tasks, variantScope.getMergeAssetsTask());
        bundleAtom.dependsOn(tasks, variantOutputScope.getProcessResourcesTask());
        bundleAtom.dependsOn(tasks, (Object)variantData.binaryFileProviderTask);
        bundleAtom.optionalDependsOn(tasks, variantOutputScope.getShrinkResourcesTask(), variantOutputScope.getVariantScope().getJavaCompilerTask(), variantData.javaCompilerTask);
        transformManager.getStreams(StreamFilter.RESOURCES).forEach(stream -> bundleAtom.dependsOn(tasks, (Object)stream.getDependencies()));
        transformManager.getStreams(StreamFilter.DEX).forEach(stream -> bundleAtom.dependsOn(tasks, (Object)stream.getDependencies()));
        transformManager.getStreams(StreamFilter.NATIVE_LIBS).forEach(stream -> bundleAtom.dependsOn(tasks, (Object)stream.getDependencies()));
        variantScope.getAssembleTask().dependsOn(tasks, bundleAtom);
        GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        if (this.getExtension().getDefaultPublishConfig().equals(variantConfig.getFullName())) {
            VariantHelper.setupDefaultConfig(this.project, variantData.getVariantDependency().getPackageConfiguration());
            bundleAtom.configure(tasks, (Action<BundleAtom>)((Action)packageTask -> this.project.getArtifacts().add("default", (Object)AndroidArtifacts.buildAtomArtifact(this.getGlobalScope().getProjectBaseName(), null, packageTask))));
            this.getAssembleDefault().dependsOn(new Object[]{variantScope.getAssembleTask().getName()});
        }
        if (this.getExtension().getPublishNonDefault()) {
            String classifier = variantData.getVariantDependency().getPublishConfiguration().getName();
            bundleAtom.configure(tasks, (Action<BundleAtom>)((Action)packageTask -> this.project.getArtifacts().add(classifier, (Object)AndroidArtifacts.buildAtomArtifact(this.getGlobalScope().getProjectBaseName(), classifier, packageTask))));
        }
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private Task getAssembleDefault() {
        if (this.assembleDefault == null) {
            this.assembleDefault = (Task)this.project.getTasks().findByName("assembleDefaultAtom");
        }
        return this.assembleDefault;
    }
}

