/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.SupplierTask;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.transforms.InstantRunDex;
import com.android.build.gradle.internal.transforms.InstantRunSlicer;
import com.android.build.gradle.internal.transforms.InstantRunTransform;
import com.android.build.gradle.internal.transforms.InstantRunVerifierTransform;
import com.android.build.gradle.internal.transforms.NoChangesVerifierTransform;
import com.android.build.gradle.tasks.CheckManifestInInstantRunMode;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.fd.FastDeployRuntimeExtractorTask;
import com.android.build.gradle.tasks.fd.GenerateInstantRunAppInfoTask;
import com.android.builder.core.DexByteCodeConverter;
import com.android.builder.core.DexOptions;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.profile.Recorder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskState;

public class InstantRunTaskManager {
    private AndroidTask<TransformTask> verifierTask;
    private AndroidTask<TransformTask> reloadDexTask;
    private AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask;
    private final Logger logger;
    private final InstantRunVariantScope variantScope;
    private final TransformManager transformManager;
    private final AndroidTaskRegistry androidTasks;
    private final TaskFactory tasks;
    private final Recorder recorder;

    public InstantRunTaskManager(Logger logger, InstantRunVariantScope instantRunVariantScope, TransformManager transformManager, AndroidTaskRegistry androidTasks, TaskFactory tasks, Recorder recorder) {
        this.logger = logger;
        this.variantScope = instantRunVariantScope;
        this.transformManager = transformManager;
        this.androidTasks = androidTasks;
        this.tasks = tasks;
        this.recorder = recorder;
    }

    public AndroidTask<BuildInfoLoaderTask> createInstantRunAllTasks(DexOptions dexOptions, Supplier<DexByteCodeConverter> dexByteCodeConverter, AndroidTask<?> preTask, AndroidTask<?> anchorTask, Set<QualifiedContent.Scope> resMergingScopes, SupplierTask<File> instantRunMergedManifest, SupplierTask<File> processedResourcesOutputFile, boolean addDependencyChangeChecker) {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        this.buildInfoLoaderTask = this.androidTasks.create(this.tasks, new BuildInfoLoaderTask.ConfigAction(this.variantScope, this.logger));
        InstantRunVerifierTransform verifierTransform = new InstantRunVerifierTransform(this.variantScope, this.recorder);
        Optional<AndroidTask<TransformTask>> verifierTaskOptional = this.transformManager.addTransform(this.tasks, transformVariantScope, verifierTransform);
        this.verifierTask = verifierTaskOptional.orElse(null);
        verifierTaskOptional.ifPresent(t -> t.optionalDependsOn(this.tasks, preTask));
        NoChangesVerifierTransform javaResourcesVerifierTransform = new NoChangesVerifierTransform("javaResourcesVerifier", this.variantScope.getInstantRunBuildContext(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS)), resMergingScopes, InstantRunVerifierStatus.JAVA_RESOURCES_CHANGED);
        Optional<AndroidTask<TransformTask>> javaResourcesVerifierTask = this.transformManager.addTransform(this.tasks, transformVariantScope, javaResourcesVerifierTransform);
        javaResourcesVerifierTask.ifPresent(t -> t.optionalDependsOn(this.tasks, this.verifierTask));
        InstantRunTransform instantRunTransform = new InstantRunTransform(this.variantScope);
        Optional<AndroidTask<TransformTask>> instantRunTask = this.transformManager.addTransform(this.tasks, transformVariantScope, instantRunTransform);
        AndroidTask<CheckManifestInInstantRunMode> checkManifestTask = this.androidTasks.create(this.tasks, new CheckManifestInInstantRunMode.ConfigAction(transformVariantScope, this.variantScope, instantRunMergedManifest, processedResourcesOutputFile));
        checkManifestTask.optionalDependsOn(this.tasks, instantRunMergedManifest.getBuilderTask(), processedResourcesOutputFile.getBuilderTask());
        instantRunTask.ifPresent(t -> t.dependsOn(this.tasks, this.buildInfoLoaderTask, this.verifierTask, javaResourcesVerifierTask.orElse(null), checkManifestTask));
        if (addDependencyChangeChecker) {
            NoChangesVerifierTransform dependenciesVerifierTransform = new NoChangesVerifierTransform("dependencyChecker", this.variantScope.getInstantRunBuildContext(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT_LOCAL_DEPS, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.EXTERNAL_LIBRARIES}), InstantRunVerifierStatus.DEPENDENCY_CHANGED);
            Optional<AndroidTask<TransformTask>> dependenciesVerifierTask = this.transformManager.addTransform(this.tasks, transformVariantScope, dependenciesVerifierTransform);
            dependenciesVerifierTask.ifPresent(t -> t.optionalDependsOn(this.tasks, this.verifierTask));
            instantRunTask.ifPresent(t -> t.optionalDependsOn(this.tasks, new Object[]{dependenciesVerifierTask.orElse(null)}));
        }
        AndroidTask<FastDeployRuntimeExtractorTask> extractorTask = this.androidTasks.create(this.tasks, new FastDeployRuntimeExtractorTask.ConfigAction(this.variantScope));
        extractorTask.dependsOn(this.tasks, this.buildInfoLoaderTask);
        this.transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.MAIN_SPLIT).setJar(this.variantScope.getIncrementalRuntimeSupportJar()).setDependency((Object)extractorTask.get(this.tasks)).build());
        AndroidTask<GenerateInstantRunAppInfoTask> generateAppInfoAndroidTask = this.androidTasks.create(this.tasks, new GenerateInstantRunAppInfoTask.ConfigAction(transformVariantScope, this.variantScope, instantRunMergedManifest));
        GenerateInstantRunAppInfoTask generateInstantRunAppInfoTask = generateAppInfoAndroidTask.get(this.tasks);
        this.transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.MAIN_SPLIT).setJar(generateInstantRunAppInfoTask.getOutputFile()).setDependency((Object)generateInstantRunAppInfoTask).build());
        generateAppInfoAndroidTask.optionalDependsOn(this.tasks, instantRunMergedManifest.getBuilderTask());
        anchorTask.optionalDependsOn(this.tasks, new Object[]{instantRunTask.orElse(null)});
        InstantRunDex reloadDexTransform = new InstantRunDex(this.variantScope, dexByteCodeConverter, dexOptions, this.logger);
        this.reloadDexTask = this.transformManager.addTransform(this.tasks, transformVariantScope, reloadDexTransform).orElse(null);
        anchorTask.optionalDependsOn(this.tasks, this.reloadDexTask);
        return this.buildInfoLoaderTask;
    }

    public AndroidTask<PreColdSwapTask> createPreColdswapTask(Project project) {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunBuildContext context = this.variantScope.getInstantRunBuildContext();
        context.setApiLevel(AndroidGradleOptions.getTargetFeatureLevel(project), AndroidGradleOptions.getColdswapMode(project), AndroidGradleOptions.getBuildTargetAbi(project));
        context.setDensity(AndroidGradleOptions.getBuildTargetDensity(project));
        if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.FULL_APK)) {
            context.setVerifierStatus(InstantRunVerifierStatus.FULL_BUILD_REQUESTED);
        } else if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY)) {
            context.setVerifierStatus(InstantRunVerifierStatus.COLD_SWAP_REQUESTED);
        }
        AndroidTask<PreColdSwapTask> preColdSwapTask = this.androidTasks.create(this.tasks, new PreColdSwapTask.ConfigAction("preColdswap", transformVariantScope, this.variantScope));
        preColdSwapTask.optionalDependsOn(this.tasks, this.verifierTask);
        return preColdSwapTask;
    }

    public void createSlicerTask() {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunSlicer slicer = new InstantRunSlicer(this.logger, this.variantScope);
        Optional<AndroidTask<TransformTask>> slicing = this.transformManager.addTransform(this.tasks, transformVariantScope, slicer);
        slicing.ifPresent(this.variantScope::addColdSwapBuildTask);
    }

    public AndroidTask<BuildInfoWriterTask> createBuildInfoWriterTask(AndroidTask<?> ... dependencies) {
        AndroidTask<BuildInfoWriterTask> buildInfoWriterTask = this.androidTasks.create(this.tasks, new BuildInfoWriterTask.ConfigAction(this.variantScope, this.logger));
        Preconditions.checkNotNull(this.buildInfoLoaderTask, (Object)"createInstantRunAllTasks() should have been called first ");
        this.buildInfoLoaderTask.configure(this.tasks, (Action<BuildInfoLoaderTask>)((Action)readerTask -> readerTask.finalizedBy(new Object[]{buildInfoWriterTask.getName()})));
        buildInfoWriterTask.configure(this.tasks, (Action<BuildInfoWriterTask>)((Action)writerTask -> {
            writerTask.mustRunAfter(new Object[]{this.reloadDexTask.getName()});
            if (dependencies != null) {
                for (AndroidTask dependency : dependencies) {
                    writerTask.mustRunAfter(new Object[]{dependency.getName()});
                }
            }
        }));
        this.variantScope.getGlobalScope().getProject().getGradle().getTaskGraph().addTaskExecutionListener((TaskExecutionListener)new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                if (state.getFailure() != null) {
                    InstantRunTaskManager.this.variantScope.getInstantRunBuildContext().setBuildHasFailed();
                }
            }
        });
        return buildInfoWriterTask;
    }
}

