/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.manifmerger.ManifestMerger2;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class TestApplicationTaskManager
extends ApplicationTaskManager {
    private static final String TEST_CONFIGURATION_PREFIX = "testTarget";
    private Configuration mTestTargetMapping = null;
    private Configuration mTargetManifestConfiguration = null;

    public TestApplicationTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        super.createTasksForVariantData(tasks, variantData);
        Configuration testTarget = this.getTestTargetConfiguration("");
        Configuration testTargetMetadata = this.getTestTargetConfiguration("-metadata");
        TestApplicationTestData testData = new TestApplicationTestData(variantData, testTarget, testTargetMetadata, this.androidBuilder);
        this.configureTestData(testData);
        AndroidTask<DeviceProviderInstrumentTestTask> instrumentTestTask = this.getAndroidTasks().create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(variantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.getLogger())), testData){

            @Override
            public String getName() {
                return super.getName() + VariantType.ANDROID_TEST.getSuffix();
            }
        });
        AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask = variantData.getMainOutput().getScope().getManifestProcessorTask();
        manifestProcessorTask.dependsOn(tasks, (Object)this.getTargetManifestConfiguration());
        variantData.assembleVariantTask.dependsOn(new Object[]{testTarget, testTargetMetadata});
        instrumentTestTask.dependsOn(tasks, (Object)variantData.assembleVariantTask);
        Task connectedAndroidTest = tasks.named("connected" + VariantType.ANDROID_TEST.getSuffix());
        if (connectedAndroidTest != null) {
            connectedAndroidTest.dependsOn(new Object[]{instrumentTestTask.getName()});
        }
    }

    @Override
    protected boolean isTestedAppMinified(VariantScope variantScope) {
        return this.getTestTargetMapping(variantScope) != null;
    }

    @Override
    protected void createMinifyTransform(TaskFactory taskFactory, VariantScope variantScope, boolean createJarFile) {
        if (this.getTestTargetMapping(variantScope) != null) {
            this.doCreateMinifyTransform(taskFactory, variantScope, this.getTestTargetMapping(variantScope), false);
        }
    }

    private Configuration getTestTargetMapping(VariantScope variantScope) {
        if (this.mTestTargetMapping == null) {
            this.mTestTargetMapping = this.getTestTargetConfiguration("-mapping");
        }
        if (this.mTestTargetMapping.getFiles().isEmpty()) {
            return null;
        }
        return this.mTestTargetMapping;
    }

    private Configuration getTargetManifestConfiguration() {
        if (this.mTargetManifestConfiguration == null) {
            this.mTargetManifestConfiguration = this.getTestTargetConfiguration("-manifest");
        }
        return this.mTargetManifestConfiguration;
    }

    @Override
    protected TaskConfigAction<? extends ManifestProcessorTask> getMergeManifestConfig(VariantOutputScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures) {
        return new ProcessTestManifest.ConfigAction(scope.getVariantScope(), this.getTargetManifestConfiguration());
    }

    private Configuration getTestTargetConfiguration(String targetConfigurationName) {
        String testTargetConfigurationName = TEST_CONFIGURATION_PREFIX;
        if (!targetConfigurationName.isEmpty()) {
            testTargetConfigurationName = testTargetConfigurationName + StringHelper.capitalize((String)targetConfigurationName);
        }
        Configuration testTargetConfiguration = (Configuration)this.project.getConfigurations().create(testTargetConfigurationName);
        DependencyHandler dependencyHandler = this.project.getDependencies();
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        dependencyHandler.add(testTargetConfigurationName, (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)(testExtension.getTargetVariant() + targetConfigurationName))));
        return testTargetConfiguration;
    }
}

