/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.ConfigurationProviderImpl;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.internal.reflect.Instantiator;

public class VariantManager
implements VariantModel {
    private static final String MULTIDEX_VERSION = "1.0.1";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.1";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.1";
    private final Project project;
    private final AndroidBuilder androidBuilder;
    private final AndroidConfig extension;
    private final VariantFactory variantFactory;
    private final TaskManager taskManager;
    private final Instantiator instantiator;
    private final Recorder recorder;
    private ProductFlavorData<CoreProductFlavor> defaultConfigData;
    private final Map<String, BuildTypeData> buildTypes = Maps.newHashMap();
    private final Map<String, ProductFlavorData<CoreProductFlavor>> productFlavors = Maps.newHashMap();
    private final Map<String, com.android.builder.model.SigningConfig> signingConfigs = Maps.newHashMap();
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();
    private final VariantFilter variantFilter = new VariantFilter(this.readOnlyObjectProvider);
    private final List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList = Lists.newArrayList();
    private CoreSigningConfig signingOverride;

    public VariantManager(Project project, AndroidBuilder androidBuilder, AndroidConfig extension, VariantFactory variantFactory, TaskManager taskManager, Instantiator instantiator, Recorder recorder) {
        this.extension = extension;
        this.androidBuilder = androidBuilder;
        this.project = project;
        this.variantFactory = variantFactory;
        this.taskManager = taskManager;
        this.instantiator = instantiator;
        this.recorder = recorder;
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(extension.getDefaultConfig().getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(VariantType.ANDROID_TEST.getPrefix());
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName(VariantType.UNIT_TEST.getPrefix());
        }
        this.defaultConfigData = new ProductFlavorData<CoreProductFlavor>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet, project);
        this.signingOverride = this.createSigningOverride();
    }

    @Override
    public ProductFlavorData<CoreProductFlavor> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    public Map<String, ProductFlavorData<CoreProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    public Map<String, com.android.builder.model.SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(com.android.builder.model.SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(CoreBuildType buildType) {
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(name);
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            unitTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(VariantManager.computeSourceSetName(buildType.getName(), VariantType.UNIT_TEST));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, this.project, mainSourceSet, unitTestSourceSet);
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(CoreProductFlavor productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(VariantManager.computeSourceSetName(productFlavor.getName(), VariantType.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSets().maybeCreate(VariantManager.computeSourceSetName(productFlavor.getName(), VariantType.UNIT_TEST));
        }
        ProductFlavorData<CoreProductFlavor> productFlavorData = new ProductFlavorData<CoreProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet, this.project);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    public List<BaseVariantData<? extends BaseVariantOutputData>> getVariantDataList() {
        return this.variantDataList;
    }

    public void createAndroidTasks() {
        this.variantFactory.validateModel(this);
        this.variantFactory.preVariantWork(this.project);
        TaskContainerAdaptor tasks = new TaskContainerAdaptor(this.project.getTasks());
        if (this.variantDataList.isEmpty()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_VARIANTS, this.project.getPath(), null, this::populateVariantDataList);
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_TESTS_TASKS, this.project.getPath(), null, () -> this.taskManager.createTopLevelTestTasks(tasks, !this.productFlavors.isEmpty()));
        for (BaseVariantData<? extends BaseVariantOutputData> variantData : this.variantDataList) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_TASKS_FOR_VARIANT, this.project.getPath(), variantData.getName(), () -> this.createTasksForVariantData(tasks, variantData));
        }
        this.taskManager.createReportTasks(tasks, this.variantDataList);
    }

    private void createAssembleTaskForVariantData(TaskFactory tasks, final BaseVariantData<?> variantData) {
        final VariantScope variantScope = variantData.getScope();
        if (variantData.getType().isForTesting()) {
            variantScope.setAssembleTask(this.taskManager.createAssembleTask(tasks, variantData));
        } else {
            BuildTypeData buildTypeData = this.buildTypes.get(((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).getName());
            Preconditions.checkNotNull(buildTypeData.getAssembleTask());
            if (this.productFlavors.isEmpty()) {
                variantScope.setAssembleTask(buildTypeData.getAssembleTask());
                buildTypeData.getAssembleTask().configure(tasks, (Action<DefaultTask>)new Action<Task>(){

                    public void execute(Task task) {
                        variantData.assembleVariantTask = task;
                    }
                });
            } else {
                variantScope.setAssembleTask(this.taskManager.createAssembleTask(tasks, variantData));
                buildTypeData.getAssembleTask().dependsOn(tasks, variantScope.getAssembleTask());
                GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
                for (CoreProductFlavor flavor : variantConfig.getProductFlavors()) {
                    ProductFlavorData<CoreProductFlavor> productFlavorData = this.productFlavors.get(flavor.getName());
                    AndroidTask<DefaultTask> flavorAssembleTask = productFlavorData.getAssembleTask();
                    if (flavorAssembleTask == null) {
                        flavorAssembleTask = this.taskManager.createAssembleTask(tasks, productFlavorData);
                        productFlavorData.setAssembleTask(flavorAssembleTask);
                    }
                    flavorAssembleTask.dependsOn(tasks, variantScope.getAssembleTask());
                }
                if (variantConfig.getProductFlavors().size() > 1) {
                    final String name = StringHelper.capitalize((String)variantConfig.getFlavorName());
                    final String variantAssembleTaskName = "assemble" + name;
                    if (!tasks.containsKey(variantAssembleTaskName)) {
                        tasks.create(variantAssembleTaskName, (Action<? super Task>)new Action<Task>(){

                            public void execute(Task task) {
                                task.setDescription("Assembles all builds for flavor combination: " + name);
                                task.setGroup("Build");
                                task.dependsOn(new Object[]{variantScope.getAssembleTask().getName()});
                            }
                        });
                    }
                    tasks.named("assemble", (Action<? super Task>)new Action<Task>(){

                        public void execute(Task task) {
                            task.dependsOn(new Object[]{variantAssembleTaskName});
                        }
                    });
                }
            }
        }
    }

    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        final BuildTypeData buildTypeData = this.buildTypes.get(((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).getName());
        if (buildTypeData.getAssembleTask() == null) {
            buildTypeData.setAssembleTask(this.taskManager.createAssembleTask(tasks, buildTypeData));
        }
        tasks.named("assemble", (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                assert (buildTypeData.getAssembleTask() != null);
                task.dependsOn(new Object[]{buildTypeData.getAssembleTask().getName()});
            }
        });
        VariantType variantType = variantData.getType();
        this.createAssembleTaskForVariantData(tasks, variantData);
        if (variantType.isForTesting()) {
            GradleVariantConfiguration testVariantConfig = variantData.getVariantConfiguration();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            VariantType testedVariantType = testedVariantData.getVariantConfiguration().getType();
            ArrayList testVariantProviders = Lists.newArrayListWithExpectedSize((int)(2 + testVariantConfig.getProductFlavors().size()));
            ConfigurationProvider buildTypeConfigurationProvider = this.buildTypes.get(((CoreBuildType)testVariantConfig.getBuildType()).getName()).getTestConfigurationProvider(variantType);
            if (buildTypeConfigurationProvider != null) {
                testVariantProviders.add(buildTypeConfigurationProvider);
            }
            for (CoreProductFlavor productFlavor : testVariantConfig.getProductFlavors()) {
                ProductFlavorData<CoreProductFlavor> data = this.productFlavors.get(productFlavor.getName());
                testVariantProviders.add(data.getTestConfigurationProvider(variantType));
            }
            testVariantProviders.add(this.defaultConfigData.getTestConfigurationProvider(variantType));
            VariantDependencies.Builder builder = VariantDependencies.builder(this.project, this.androidBuilder.getErrorReporter(), testVariantConfig.getFullName(), variantType).setPublishVariant(false).setTestedVariantType(testedVariantType).addProviders(testVariantProviders).addTestedVariant(testedVariantData.getVariantConfiguration(), testedVariantData.getVariantDependency());
            VariantDependencies variantDep = builder.build();
            variantData.setVariantDependency(variantDep);
            if (variantType == VariantType.ANDROID_TEST && testVariantConfig.isLegacyMultiDexMode()) {
                this.project.getDependencies().add(variantDep.getCompileConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION);
                this.project.getDependencies().add(variantDep.getPackageConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION);
            }
            if (!AndroidGradleOptions.isImprovedDependencyResolutionEnabled(this.project)) {
                this.recorder.record(GradleBuildProfileSpan.ExecutionType.RESOLVE_DEPENDENCIES, this.project.getPath(), testVariantConfig.getFullName(), () -> this.taskManager.resolveDependencies(variantDep, null));
                testVariantConfig.setResolvedDependencies(variantDep.getCompileDependencies(), variantDep.getPackageDependencies());
            }
            switch (variantType) {
                case ANDROID_TEST: {
                    this.taskManager.createAndroidTestVariantTasks(tasks, (TestVariantData)variantData);
                    break;
                }
                case UNIT_TEST: {
                    this.taskManager.createUnitTestVariantTasks(tasks, (TestVariantData)variantData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown test type " + variantType);
                }
            }
        } else {
            this.taskManager.createTasksForVariantData(tasks, variantData);
        }
    }

    public void populateVariantDataList() {
        if (this.productFlavors.isEmpty()) {
            this.createVariantDataForProductFlavors(Collections.emptyList());
        } else {
            List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
            Iterable flavorDsl = Iterables.transform(this.productFlavors.values(), ProductFlavorData::getProductFlavor);
            List flavorComboList = ProductFlavorCombo.createCombinations(flavorDimensionList, flavorDsl);
            for (ProductFlavorCombo flavorCombo : flavorComboList) {
                this.createVariantDataForProductFlavors(flavorCombo.getFlavorList());
            }
        }
    }

    public BaseVariantData<? extends BaseVariantOutputData> createVariantData(BuildType buildType, List<? extends ProductFlavor> productFlavorList) {
        String testedProjectPath;
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration variantConfig = GradleVariantConfiguration.getBuilderForExtension(this.extension).create(this.project, this.defaultConfigData.getProductFlavor(), this.defaultConfigData.getSourceSet(), buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.variantFactory.getVariantConfigurationType(), this.signingOverride);
        if (variantConfig.getType() == VariantType.LIBRARY && variantConfig.getJackOptions().isEnabled().booleanValue()) {
            this.project.getLogger().warn("{}, {}: Jack compiler is not supported in library projects, falling back to javac.", (Object)this.project.getPath(), (Object)variantConfig.getFullName());
        }
        NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSets();
        for (ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> productFlavorData = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            variantConfig.addProductFlavor(productFlavorData.getProductFlavor(), (SourceProvider)productFlavorData.getSourceSet(), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, variantConfig, sourceSetsContainer);
        ArrayList variantProviders = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            variantProviders.add(new ConfigurationProviderImpl(this.project, (DefaultAndroidSourceSet)variantConfig.getVariantSourceProvider()));
        }
        variantProviders.add(buildTypeData.getMainProvider());
        if (productFlavorList.size() > 1) {
            variantProviders.add(new ConfigurationProviderImpl(this.project, (DefaultAndroidSourceSet)variantConfig.getMultiFlavorSourceProvider()));
        }
        for (ProductFlavor productFlavor : productFlavorList) {
            variantProviders.add(this.productFlavors.get(productFlavor.getName()).getMainProvider());
        }
        variantProviders.add(this.defaultConfigData.getMainProvider());
        BaseVariantData baseVariantData = this.variantFactory.createVariantData(variantConfig, this.taskManager, this.recorder);
        VariantDependencies.Builder builder = VariantDependencies.builder(this.project, this.androidBuilder.getErrorReporter(), variantConfig.getFullName(), baseVariantData.getType()).setPublishVariant(this.isVariantPublished()).addProviders(variantProviders);
        VariantDependencies variantDep = builder.build();
        baseVariantData.setVariantDependency(variantDep);
        if (variantConfig.isLegacyMultiDexMode()) {
            this.project.getDependencies().add(variantDep.getCompileConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
            this.project.getDependencies().add(variantDep.getPackageConfiguration().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
        }
        String string = testedProjectPath = this.extension instanceof TestAndroidConfig ? ((TestAndroidConfig)this.extension).getTargetProjectPath() : null;
        if (!AndroidGradleOptions.isImprovedDependencyResolutionEnabled(this.project)) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.RESOLVE_DEPENDENCIES, this.project.getPath(), variantConfig.getFullName(), () -> this.taskManager.resolveDependencies(variantDep, testedProjectPath));
            variantConfig.setResolvedDependencies(variantDep.getCompileDependencies(), variantDep.getPackageDependencies());
        }
        return baseVariantData;
    }

    private static void createCompoundSourceSets(List<? extends ProductFlavor> productFlavorList, GradleVariantConfiguration variantConfig, NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer) {
        if (!productFlavorList.isEmpty() && !variantConfig.getType().isSingleBuildType()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(VariantManager.computeSourceSetName(variantConfig.getFullName(), variantConfig.getType()));
            variantConfig.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(VariantManager.computeSourceSetName(variantConfig.getFlavorName(), variantConfig.getType()));
            variantConfig.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    private static String computeSourceSetName(String name, VariantType variantType) {
        if (name.endsWith(variantType.getSuffix())) {
            name = name.substring(0, name.length() - variantType.getSuffix().length());
        }
        if (!variantType.getPrefix().isEmpty()) {
            name = variantType.getPrefix() + StringHelper.capitalize((String)name);
        }
        return name;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, VariantType type) {
        CoreBuildType buildType = (CoreBuildType)testedVariantData.getVariantConfiguration().getBuildType();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
        List productFlavorList = testedConfig.getProductFlavors();
        GradleVariantConfiguration testVariantConfig = testedConfig.getMyTestConfig(this.defaultConfigData.getTestSourceSet(type), buildTypeData.getTestSourceSet(type), type);
        for (CoreProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            testVariantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getTestSourceSet(type), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, testVariantConfig, this.extension.getSourceSets());
        TestVariantData testVariantData = new TestVariantData(this.extension, this.taskManager, testVariantConfig, (TestedVariantData)((Object)testedVariantData), this.androidBuilder.getErrorReporter(), this.recorder);
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(List<ProductFlavor> productFlavorList) {
        String restrictedVariantName;
        boolean projectMatch;
        boolean restrictVariants;
        TestedAndroidConfig testedExtension;
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig && (testBuildTypeData = this.buildTypes.get((testedExtension = (TestedAndroidConfig)this.extension).getTestBuildType())) == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
        }
        BaseVariantData<? extends BaseVariantOutputData> variantForAndroidTest = null;
        CoreProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        Action<com.android.build.api.variant.VariantFilter> variantFilterAction = this.extension.getVariantFilter();
        String restrictedProject = AndroidGradleOptions.getRestrictVariantProject(this.project);
        boolean bl = restrictVariants = restrictedProject != null;
        if (restrictVariants) {
            projectMatch = this.variantFactory.getVariantConfigurationType() != VariantType.LIBRARY && this.project.getPath().equals(restrictedProject);
            restrictedVariantName = AndroidGradleOptions.getRestrictVariantName(this.project);
        } else {
            projectMatch = false;
            restrictedVariantName = null;
        }
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            boolean ignore = false;
            if (restrictVariants || variantFilterAction != null) {
                this.variantFilter.reset(defaultConfig, buildTypeData.getBuildType(), this.variantFactory.getVariantConfigurationType(), productFlavorList);
                if (restrictVariants) {
                    if (this.variantFactory.getVariantConfigurationType() == VariantType.LIBRARY) {
                        ignore = !this.extension.getPublishNonDefault() && !this.variantFilter.getName().equals(this.extension.getDefaultPublishConfig());
                    } else if (projectMatch) {
                        ignore = !this.variantFilter.getName().equals(restrictedVariantName);
                    }
                } else {
                    variantFilterAction.execute((Object)this.variantFilter);
                    ignore = this.variantFilter.isIgnore();
                }
            }
            if (ignore) continue;
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.createVariantData(buildTypeData.getBuildType(), productFlavorList);
            this.variantDataList.add(variantData);
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            ProcessProfileWriter.addVariant((String)this.project.getPath(), (String)variantData.getName()).setIsDebug(((CoreBuildType)variantConfig.getBuildType()).isDebuggable()).setUseJack(variantConfig.getJackOptions().isEnabled().booleanValue()).setMinifyEnabled(variantConfig.isMinifyEnabled()).setUseMultidex(variantConfig.isMultiDexEnabled()).setUseLegacyMultidex(variantConfig.isLegacyMultiDexMode()).setVariantType(variantData.getType().getAnalyticsVariantType());
            if (!this.variantFactory.hasTestScope()) continue;
            TestVariantData unitTestVariantData = this.createTestVariantData(variantData, VariantType.UNIT_TEST);
            this.variantDataList.add(unitTestVariantData);
            if (buildTypeData != testBuildTypeData) continue;
            if (variantConfig.isMinifyEnabled() && variantConfig.getJackOptions().isEnabled().booleanValue()) {
                this.androidBuilder.getErrorReporter().handleSyncError(variantConfig.getFullName(), 11, "Minifying the variant used for tests is not supported when using Jack.");
            }
            variantForAndroidTest = variantData;
        }
        if (variantForAndroidTest != null) {
            TestVariantData androidTestVariantData = this.createTestVariantData(variantForAndroidTest, VariantType.ANDROID_TEST);
            this.variantDataList.add(androidTestVariantData);
        }
    }

    private boolean isVariantPublished() {
        return this.extension.getPublishNonDefault();
    }

    private static void checkName(String name, String displayName) {
        VariantManager.checkPrefix(name, displayName, VariantType.ANDROID_TEST.getPrefix());
        VariantManager.checkPrefix(name, displayName, VariantType.UNIT_TEST.getPrefix());
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name, String displayName, String prefix) {
        if (name.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }

    private CoreSigningConfig createSigningOverride() {
        AndroidGradleOptions.SigningOptions signingOptions = AndroidGradleOptions.getSigningOptions(this.project);
        if (signingOptions != null) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            signingConfigDsl.setStoreFile(new File(signingOptions.storeFile));
            signingConfigDsl.setStorePassword(signingOptions.storePassword);
            signingConfigDsl.setKeyAlias(signingOptions.keyAlias);
            signingConfigDsl.setKeyPassword(signingOptions.keyPassword);
            if (signingOptions.storeType != null) {
                signingConfigDsl.setStoreType(signingOptions.storeType);
            }
            if (signingOptions.v1Enabled != null) {
                signingConfigDsl.setV1SigningEnabled(signingOptions.v1Enabled);
            }
            if (signingOptions.v2Enabled != null) {
                signingConfigDsl.setV2SigningEnabled(signingOptions.v2Enabled);
            }
            return signingConfigDsl;
        }
        return null;
    }
}

