/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;

public class ConfigurationDependencyGraphs
implements DependencyGraphs {
    private final Configuration configuration;
    private List<GraphItem> graphItems;
    private List<Dependency> dependencies;

    public ConfigurationDependencyGraphs(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<Dependency> getDependencyObjects() {
        this.init();
        return this.dependencies;
    }

    public List<GraphItem> getCompileDependencies() {
        this.init();
        return this.graphItems;
    }

    public List<GraphItem> getPackageDependencies() {
        this.init();
        return this.graphItems;
    }

    public List<String> getProvidedLibraries() {
        return Collections.emptyList();
    }

    public List<String> getSkippedLibraries() {
        return Collections.emptyList();
    }

    private void init() {
        if (this.graphItems != null) {
            return;
        }
        Set files = this.configuration.getFiles();
        if (files.isEmpty()) {
            this.graphItems = Collections.emptyList();
            this.dependencies = Collections.emptyList();
            return;
        }
        this.graphItems = Lists.newArrayListWithCapacity((int)files.size());
        this.dependencies = Lists.newArrayListWithCapacity((int)files.size());
        for (File file : files) {
            JavaDependency dependency = new JavaDependency(file);
            this.dependencies.add((Dependency)dependency);
            this.graphItems.add(new GraphItemImpl(dependency.getAddress().toString(), (List<GraphItem>)ImmutableList.of()));
        }
    }
}

