/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.LoggingUtil;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreJavaCompileOptions;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreShaderOptions;
import com.android.build.gradle.internal.dsl.ExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.JackOptions;
import com.android.build.gradle.internal.dsl.JavaCompileOptions;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.dsl.ShaderOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.builder.core.DefaultBuildType;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.internal.reflect.Instantiator;

public class BuildType
extends DefaultBuildType
implements CoreBuildType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Project project;
    private final Logger logger;
    private final NdkOptions ndkConfig;
    private final ExternalNativeBuildOptions externalNativeBuildOptions;
    private final JackOptions jackOptions;
    private final JavaCompileOptions javaCompileOptions;
    private final ShaderOptions shaderOptions;
    private boolean shrinkResources = false;
    private boolean useProguard = true;

    public BuildType(String name, Project project, Instantiator instantiator, Logger logger) {
        super(name);
        this.project = project;
        this.logger = logger;
        this.jackOptions = (JackOptions)instantiator.newInstance(JackOptions.class, new Object[0]);
        this.javaCompileOptions = (JavaCompileOptions)instantiator.newInstance(JavaCompileOptions.class, new Object[]{instantiator});
        this.shaderOptions = (ShaderOptions)instantiator.newInstance(ShaderOptions.class, new Object[0]);
        this.ndkConfig = (NdkOptions)instantiator.newInstance(NdkOptions.class, new Object[0]);
        this.externalNativeBuildOptions = (ExternalNativeBuildOptions)instantiator.newInstance(ExternalNativeBuildOptions.class, new Object[]{instantiator});
    }

    BuildType(String name, Project project, Logger logger) {
        super(name);
        this.project = project;
        this.logger = logger;
        this.jackOptions = new JackOptions();
        this.javaCompileOptions = new JavaCompileOptions();
        this.shaderOptions = new ShaderOptions();
        this.ndkConfig = new NdkOptions();
        this.externalNativeBuildOptions = new ExternalNativeBuildOptions();
    }

    @Override
    public CoreNdkOptions getNdkConfig() {
        return this.ndkConfig;
    }

    @Override
    public ExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.externalNativeBuildOptions;
    }

    @Override
    public JackOptions getJackOptions() {
        return this.jackOptions;
    }

    @Override
    public CoreJavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }

    @Override
    public CoreShaderOptions getShaders() {
        return this.shaderOptions;
    }

    public void init(SigningConfig debugSigningConfig) {
        if ("debug".equals(this.getName())) {
            this.setDebuggable(true);
            this.setEmbedMicroApp(false);
            assert (debugSigningConfig != null);
            this.setSigningConfig(debugSigningConfig);
        }
    }

    public SigningConfig getSigningConfig() {
        return (SigningConfig)super.getSigningConfig();
    }

    protected void _initWith(BaseConfig that) {
        super._initWith(that);
        BuildType thatBuildType = (BuildType)that;
        this.ndkConfig._initWith(thatBuildType.getNdkConfig());
        this.jackOptions._initWith(thatBuildType.getJackOptions());
        this.javaCompileOptions.getAnnotationProcessorOptions()._initWith(thatBuildType.getJavaCompileOptions().getAnnotationProcessorOptions());
        this.shrinkResources = thatBuildType.isShrinkResources();
        this.shaderOptions._initWith(thatBuildType.getShaders());
        this.externalNativeBuildOptions._initWith(thatBuildType.getExternalNativeBuildOptions());
        this.useProguard = thatBuildType.isUseProguard();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getJackOptions().hashCode();
        result = 31 * result + this.javaCompileOptions.hashCode();
        result = 31 * result + (this.shrinkResources ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildType other = (BuildType)o;
        if (!this.ndkConfig.equals(other.ndkConfig)) {
            return false;
        }
        if (!this.jackOptions.equals(other.jackOptions)) {
            return false;
        }
        if (!this.javaCompileOptions.equals(other.javaCompileOptions)) {
            return false;
        }
        return this.shrinkResources == other.isShrinkResources();
    }

    public void buildConfigField(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getBuildConfigFields().get(name);
        if (alreadyPresent != null) {
            this.logger.info("BuildType({}): buildConfigField '{}' value is being replaced: {} -> {}", new Object[]{this.getName(), name, alreadyPresent.getValue(), value});
        }
        this.addBuildConfigField((ClassField)new ClassFieldImpl(type, name, value));
    }

    public void resValue(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getResValues().get(name);
        if (alreadyPresent != null) {
            this.logger.info("BuildType({}): resValue '{}' value is being replaced: {} -> {}", new Object[]{this.getName(), name, alreadyPresent.getValue(), value});
        }
        this.addResValue((ClassField)new ClassFieldImpl(type, name, value));
    }

    public BuildType proguardFile(Object proguardFile) {
        this.getProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType proguardFiles(Object ... files) {
        for (Object file : files) {
            this.proguardFile(file);
        }
        return this;
    }

    public BuildType setProguardFiles(Iterable<?> proguardFileIterable) {
        this.getProguardFiles().clear();
        this.proguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
        return this;
    }

    public BuildType testProguardFile(Object proguardFile) {
        this.getTestProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType testProguardFiles(Object ... proguardFiles) {
        for (Object proguardFile : proguardFiles) {
            this.testProguardFile(proguardFile);
        }
        return this;
    }

    public BuildType setTestProguardFiles(Iterable<?> files) {
        this.getTestProguardFiles().clear();
        this.testProguardFiles(Iterables.toArray(files, Object.class));
        return this;
    }

    public BuildType consumerProguardFile(Object proguardFile) {
        this.getConsumerProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType consumerProguardFiles(Object ... proguardFiles) {
        for (Object proguardFile : proguardFiles) {
            this.consumerProguardFile(proguardFile);
        }
        return this;
    }

    public BuildType setConsumerProguardFiles(Iterable<?> proguardFileIterable) {
        this.getConsumerProguardFiles().clear();
        this.consumerProguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
        return this;
    }

    public void ndk(Action<NdkOptions> action) {
        action.execute((Object)this.ndkConfig);
    }

    public ExternalNativeBuildOptions externalNativeBuild(Action<ExternalNativeBuildOptions> action) {
        action.execute((Object)this.externalNativeBuildOptions);
        return this.externalNativeBuildOptions;
    }

    public void jackOptions(Action<JackOptions> action) {
        action.execute((Object)this.jackOptions);
    }

    @Deprecated
    public Boolean getUseJack() {
        LoggingUtil.displayDeprecationWarning(this.logger, this.project, "useJack is deprecated.  Use jackOptions.enabled instead.");
        return this.jackOptions.isEnabled();
    }

    @Deprecated
    public void setUseJack(Boolean useJack) {
        LoggingUtil.displayDeprecationWarning(this.logger, this.project, "useJack is deprecated.  Use jackOptions.enabled instead.");
        this.jackOptions.setEnabled(useJack);
    }

    public void shaders(Action<ShaderOptions> action) {
        action.execute((Object)this.shaderOptions);
    }

    @Override
    public boolean isShrinkResources() {
        return this.shrinkResources;
    }

    public void setShrinkResources(boolean shrinkResources) {
        this.shrinkResources = shrinkResources;
    }

    @Override
    public boolean isUseProguard() {
        return this.useProguard;
    }

    public void setUseProguard(boolean useProguard) {
        this.useProguard = useProguard;
    }

    public void jarJarRuleFile(Object file) {
        this.getJarJarRuleFiles().add(this.project.file(file));
    }

    public void jarJarRuleFiles(Object ... files) {
        this.getJarJarRuleFiles().clear();
        for (Object file : files) {
            this.getJarJarRuleFiles().add(this.project.file(file));
        }
    }
}

