/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.externalBuild.ExternalBuildContext;
import com.android.build.gradle.internal.externalBuild.ExternalBuildVariantScope;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.VariantType;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ApiVersion;
import com.android.utils.StringHelper;
import com.google.devtools.build.lib.rules.android.apkmanifest.ExternalBuildApkManifest;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;

public class ExternalBuildPackagingScope
implements PackagingScope {
    private final Project mProject;
    private final ExternalBuildContext mExternalBuildContext;
    private final ExternalBuildApkManifest.ApkManifest mBuildManifest;
    private final ExternalBuildVariantScope mVariantScope;
    private final TransformManager mTransformManager;
    private InstantRunBuildContext mInstantRunBuildContext;
    private final SigningConfig mSigningConfig;

    public ExternalBuildPackagingScope(Project project, ExternalBuildContext externalBuildContext, ExternalBuildVariantScope variantScope, TransformManager transformManager, SigningConfig signingConfig) {
        this.mProject = project;
        this.mExternalBuildContext = externalBuildContext;
        this.mBuildManifest = externalBuildContext.getBuildManifest();
        this.mVariantScope = variantScope;
        this.mTransformManager = transformManager;
        this.mSigningConfig = signingConfig;
        this.mInstantRunBuildContext = this.mVariantScope.getInstantRunBuildContext();
    }

    @Override
    public AndroidBuilder getAndroidBuilder() {
        return this.mExternalBuildContext.getAndroidBuilder();
    }

    @Override
    public File getFinalResourcesFile() {
        return new File(this.mExternalBuildContext.getExecutionRoot(), this.mBuildManifest.getResourceApk().getExecRootPath());
    }

    @Override
    public String getFullVariantName() {
        return this.mVariantScope.getFullVariantName();
    }

    @Override
    public ApiVersion getMinSdkVersion() {
        return new DefaultApiVersion(this.mInstantRunBuildContext.getFeatureLevel());
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.mInstantRunBuildContext;
    }

    @Override
    public File getInstantRunSupportDir() {
        return this.mVariantScope.getInstantRunSupportDir();
    }

    @Override
    public File getIncrementalDir(String name) {
        return this.mVariantScope.getIncrementalDir(name);
    }

    @Override
    public Set<File> getDexFolders() {
        return this.mTransformManager.getPipelineOutput(StreamFilter.DEX).keySet();
    }

    @Override
    public Set<File> getJavaResources() {
        return Collections.emptySet();
    }

    @Override
    public Set<File> getJniFolders() {
        return Collections.emptySet();
    }

    @Override
    public SplitHandlingPolicy getSplitHandlingPolicy() {
        return SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY;
    }

    @Override
    public Set<String> getAbiFilters() {
        return Collections.emptySet();
    }

    @Override
    public ApkOutputFile getMainOutputFile() {
        return this.mVariantScope.getMainOutputFile();
    }

    @Override
    public Set<String> getSupportedAbis() {
        return null;
    }

    @Override
    public boolean isDebuggable() {
        return true;
    }

    @Override
    public boolean isJniDebuggable() {
        return false;
    }

    @Override
    public CoreSigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @Override
    public PackagingOptions getPackagingOptions() {
        return new PackagingOptions();
    }

    @Override
    public String getTaskName(String name) {
        return name + StringHelper.capitalize((String)this.getFullVariantName());
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return prefix + this.getFullVariantName() + suffix;
    }

    @Override
    public Project getProject() {
        return this.mProject;
    }

    @Override
    public File getOutputPackage() {
        return this.getMainOutputFile().getOutputFile();
    }

    @Override
    public File getIntermediateApk() {
        return this.mVariantScope.getIntermediateApk();
    }

    @Override
    public File getAssetsDir() {
        return this.mVariantScope.getAssetsDir();
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return this.mVariantScope.getInstantRunSplitApkOutputFolder();
    }

    @Override
    public File getAtomMetadataBaseFolder() {
        return null;
    }

    @Override
    public String getApplicationId() {
        return this.mVariantScope.getApplicationId();
    }

    @Override
    public int getVersionCode() {
        return this.mVariantScope.getVersionCode();
    }

    @Override
    public String getVersionName() {
        return this.mVariantScope.getVersionName();
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.mVariantScope.getAaptOptions();
    }

    @Override
    public VariantType getVariantType() {
        return VariantType.DEFAULT;
    }

    @Override
    public File getManifestFile() {
        return new File(this.mExternalBuildContext.getExecutionRoot(), this.mBuildManifest.getAndroidManifest().getExecRootPath());
    }
}

