/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifactOutput;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

final class AndroidArtifactOutputImpl
implements AndroidArtifactOutput,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File generatedManifest;
    private final String assembleTaskName;
    private final int versionCode;
    private final Collection<OutputFile> outputFiles;
    private final OutputFile mainOutputFile;

    AndroidArtifactOutputImpl(Collection<OutputFile> outputFiles, String assembleTaskName, File generatedManifest, int versionCode) {
        this.generatedManifest = generatedManifest;
        this.assembleTaskName = assembleTaskName;
        this.versionCode = versionCode;
        this.outputFiles = outputFiles;
        for (OutputFile outputFile : outputFiles) {
            if (!outputFile.getOutputType().equals(OutputFile.MAIN) && !outputFile.getOutputType().equals(OutputFile.FULL_SPLIT)) continue;
            this.mainOutputFile = outputFile;
            return;
        }
        throw new IllegalStateException("No main output file for variant");
    }

    public OutputFile getMainOutputFile() {
        return this.mainOutputFile;
    }

    public Collection<OutputFile> getOutputs() {
        return this.outputFiles;
    }

    public String getAssembleTaskName() {
        return this.assembleTaskName;
    }

    public File getGeneratedManifest() {
        return this.generatedManifest;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public File getSplitFolder() {
        return this.getMainOutputFile().getOutputFile().getParentFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidArtifactOutputImpl that = (AndroidArtifactOutputImpl)o;
        return this.versionCode == that.versionCode && Objects.equals(this.generatedManifest, that.generatedManifest) && Objects.equals(this.assembleTaskName, that.assembleTaskName) && Objects.equals(this.outputFiles, that.outputFiles) && Objects.equals(this.mainOutputFile, that.mainOutputFile);
    }

    public int hashCode() {
        return Objects.hash(this.generatedManifest, this.assembleTaskName, this.versionCode, this.outputFiles, this.mainOutputFile);
    }
}

