/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.ApiVersionImpl;
import com.android.build.gradle.internal.ide.BaseConfigImpl;
import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.VectorDrawablesOptions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class ProductFlavorImpl
extends BaseConfigImpl
implements ProductFlavor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String mDimension;
    private final ApiVersion mMinSdkVersion;
    private final ApiVersion mTargetSdkVersion;
    private final Integer mMaxSdkVersion;
    private final Integer mRenderscriptTargetApi;
    private final Boolean mRenderscriptSupportMode;
    private final Boolean mRenderscriptSupportModeBlas;
    private final Boolean mRenderscriptNdkMode;
    private final Integer mVersionCode;
    private final String mVersionName;
    private final String mApplicationId;
    private final String mTestApplicationId;
    private final String mTestInstrumentationRunner;
    private final Map<String, String> mTestInstrumentationRunnerArguments;
    private final Boolean mTestHandleProfiling;
    private final Boolean mTestFunctionalTest;
    private final Set<String> mResourceConfigurations;
    private final DefaultVectorDrawablesOptions mVectorDrawablesOptions;
    private final Boolean mWearAppUnbundled;

    public ProductFlavorImpl(ProductFlavor productFlavor, ApiVersion minSdkVersionOverride, ApiVersion targetSdkVersionOverride) {
        super((BaseConfig)productFlavor);
        this.name = productFlavor.getName();
        this.mDimension = productFlavor.getDimension();
        this.mMinSdkVersion = minSdkVersionOverride != null ? minSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getMinSdkVersion());
        this.mTargetSdkVersion = targetSdkVersionOverride != null ? targetSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getTargetSdkVersion());
        this.mMaxSdkVersion = targetSdkVersionOverride != null ? null : productFlavor.getMaxSdkVersion();
        this.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        this.mRenderscriptSupportMode = productFlavor.getRenderscriptSupportModeEnabled();
        this.mRenderscriptSupportModeBlas = productFlavor.getRenderscriptSupportModeBlasEnabled();
        this.mRenderscriptNdkMode = productFlavor.getRenderscriptNdkModeEnabled();
        this.mVersionCode = productFlavor.getVersionCode();
        this.mVersionName = productFlavor.getVersionName();
        this.mApplicationId = productFlavor.getApplicationId();
        this.mTestApplicationId = productFlavor.getTestApplicationId();
        this.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        this.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        this.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        this.mResourceConfigurations = ImmutableSet.copyOf((Collection)productFlavor.getResourceConfigurations());
        this.mTestInstrumentationRunnerArguments = Maps.newHashMap((Map)productFlavor.getTestInstrumentationRunnerArguments());
        this.mVectorDrawablesOptions = DefaultVectorDrawablesOptions.copyOf((VectorDrawablesOptions)productFlavor.getVectorDrawables());
        this.mWearAppUnbundled = productFlavor.getWearAppUnbundled();
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationId() {
        return this.mApplicationId;
    }

    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportMode;
    }

    public Boolean getRenderscriptSupportModeBlasEnabled() {
        return this.mRenderscriptSupportModeBlas;
    }

    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkMode;
    }

    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.mTestInstrumentationRunnerArguments;
    }

    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    public Collection<String> getResourceConfigurations() {
        return this.mResourceConfigurations;
    }

    public SigningConfig getSigningConfig() {
        return null;
    }

    public VectorDrawablesOptions getVectorDrawables() {
        return this.mVectorDrawablesOptions;
    }

    public Boolean getWearAppUnbundled() {
        return this.mWearAppUnbundled;
    }

    public String getDimension() {
        return this.mDimension;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductFlavorImpl that = (ProductFlavorImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.mDimension, that.mDimension) && Objects.equals(this.mMinSdkVersion, that.mMinSdkVersion) && Objects.equals(this.mTargetSdkVersion, that.mTargetSdkVersion) && Objects.equals(this.mMaxSdkVersion, that.mMaxSdkVersion) && Objects.equals(this.mRenderscriptTargetApi, that.mRenderscriptTargetApi) && Objects.equals(this.mRenderscriptSupportMode, that.mRenderscriptSupportMode) && Objects.equals(this.mRenderscriptSupportModeBlas, that.mRenderscriptSupportModeBlas) && Objects.equals(this.mRenderscriptNdkMode, that.mRenderscriptNdkMode) && Objects.equals(this.mVersionCode, that.mVersionCode) && Objects.equals(this.mVersionName, that.mVersionName) && Objects.equals(this.mApplicationId, that.mApplicationId) && Objects.equals(this.mTestApplicationId, that.mTestApplicationId) && Objects.equals(this.mTestInstrumentationRunner, that.mTestInstrumentationRunner) && Objects.equals(this.mTestInstrumentationRunnerArguments, that.mTestInstrumentationRunnerArguments) && Objects.equals(this.mTestHandleProfiling, that.mTestHandleProfiling) && Objects.equals(this.mTestFunctionalTest, that.mTestFunctionalTest) && Objects.equals(this.mResourceConfigurations, that.mResourceConfigurations) && Objects.equals(this.mVectorDrawablesOptions, that.mVectorDrawablesOptions) && Objects.equals(this.mWearAppUnbundled, that.mWearAppUnbundled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.mDimension, this.mMinSdkVersion, this.mTargetSdkVersion, this.mMaxSdkVersion, this.mRenderscriptTargetApi, this.mRenderscriptSupportMode, this.mRenderscriptSupportModeBlas, this.mRenderscriptNdkMode, this.mVersionCode, this.mVersionName, this.mApplicationId, this.mTestApplicationId, this.mTestInstrumentationRunner, this.mTestInstrumentationRunnerArguments, this.mTestHandleProfiling, this.mTestFunctionalTest, this.mResourceConfigurations, this.mVectorDrawablesOptions, this.mWearAppUnbundled);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("mDimension", (Object)this.mDimension).add("mMinSdkVersion", (Object)this.mMinSdkVersion).add("mTargetSdkVersion", (Object)this.mTargetSdkVersion).add("mMaxSdkVersion", (Object)this.mMaxSdkVersion).add("mRenderscriptTargetApi", (Object)this.mRenderscriptTargetApi).add("mRenderscriptSupportMode", (Object)this.mRenderscriptSupportMode).add("mRenderscriptSupportModeBlas", (Object)this.mRenderscriptSupportModeBlas).add("mRenderscriptNdkMode", (Object)this.mRenderscriptNdkMode).add("mVersionCode", (Object)this.mVersionCode).add("mVersionName", (Object)this.mVersionName).add("mApplicationId", (Object)this.mApplicationId).add("mTestApplicationId", (Object)this.mTestApplicationId).add("mTestInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("mTestInstrumentationRunnerArguments", this.mTestInstrumentationRunnerArguments).add("mTestHandleProfiling", (Object)this.mTestHandleProfiling).add("mTestFunctionalTest", (Object)this.mTestFunctionalTest).add("mResourceConfigurations", this.mResourceConfigurations).add("mVectorDrawablesOptions", (Object)this.mVectorDrawablesOptions).add("mWearAppUnbundled", (Object)this.mWearAppUnbundled).toString();
    }
}

