/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ColdswapMode;
import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Strings;
import java.util.Locale;

public enum InstantRunPatchingPolicy {
    PRE_LOLLIPOP(DexPackagingPolicy.STANDARD, false),
    MULTI_DEX(DexPackagingPolicy.INSTANT_RUN_SHARDS_IN_SINGLE_APK, true),
    MULTI_APK(DexPackagingPolicy.INSTANT_RUN_MULTI_APK, true);

    private final DexPackagingPolicy dexPatchingPolicy;
    private final boolean useMultiDex;

    private InstantRunPatchingPolicy(DexPackagingPolicy dexPatchingPolicy, boolean useMultiDex) {
        this.dexPatchingPolicy = dexPatchingPolicy;
        this.useMultiDex = useMultiDex;
    }

    public boolean useMultiDex() {
        return this.useMultiDex;
    }

    public DexPackagingPolicy getDexPatchingPolicy() {
        return this.dexPatchingPolicy;
    }

    public static InstantRunPatchingPolicy getPatchingPolicy(int featureLevel, String coldswapMode) {
        InstantRunPatchingPolicy defaultModeForArchitecture;
        if (featureLevel < AndroidVersion.ART_RUNTIME.getFeatureLevel()) {
            return PRE_LOLLIPOP;
        }
        InstantRunPatchingPolicy instantRunPatchingPolicy = defaultModeForArchitecture = featureLevel < 24 ? MULTI_DEX : MULTI_APK;
        if (Strings.isNullOrEmpty((String)coldswapMode)) {
            return defaultModeForArchitecture;
        }
        ColdswapMode coldswap = ColdswapMode.valueOf(coldswapMode.toUpperCase(Locale.US));
        switch (coldswap) {
            case MULTIAPK: {
                return MULTI_APK;
            }
            case MULTIDEX: {
                return MULTI_DEX;
            }
            case AUTO: {
                return defaultModeForArchitecture;
            }
            case DEFAULT: {
                return defaultModeForArchitecture;
            }
        }
        throw new RuntimeException("Cold-swap case not handled " + (Object)((Object)coldswap));
    }
}

