/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.ndk.DefaultStlNativeToolSpecification;
import com.android.build.gradle.internal.ndk.DefaultStlSpecificationFactory;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.build.gradle.internal.ndk.StlSpecification;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.Pair;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logging;

public class DefaultNdkInfo
implements NdkInfo {
    private final File root;
    private final Map<Pair<Toolchain, Abi>, String> defaultToolchainVersions = Maps.newHashMap();

    public DefaultNdkInfo(File root) {
        this.root = root;
    }

    @Override
    public File getRootDirectory() {
        return this.root;
    }

    @Override
    public String getSysrootPath(Abi abi, String platformVersion) {
        return this.root + "/platforms/" + platformVersion + "/arch-" + abi.getArchitecture();
    }

    private File getSysrootDirectory(Abi abi, String platformVersion) {
        return new File(this.getSysrootPath(abi, platformVersion));
    }

    @Override
    public String findLatestPlatformVersion(String targetPlatformString) {
        int targetVersion;
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)targetPlatformString);
        if (androidVersion == null) {
            Logging.getLogger(this.getClass()).warn("Unable to parse NDK platform version.  Try to find the latest instead.");
            targetVersion = Integer.MAX_VALUE;
        } else {
            targetVersion = androidVersion.getFeatureLevel();
        }
        targetVersion = this.findTargetPlatformVersionOrLower(targetVersion);
        if (targetVersion == 0) {
            return null;
        }
        return "android-" + targetVersion;
    }

    @Override
    public int findSuitablePlatformVersion(String abiName, int minSdkVersion) {
        Abi abi = Abi.getByName(abiName);
        if (abi == null) {
            return 0;
        }
        File platformDir = FileUtils.join((File)this.root, (String[])new String[]{"platforms"});
        Preconditions.checkState((boolean)platformDir.isDirectory());
        if (this.getSysrootDirectory(abi, "android-" + minSdkVersion).isDirectory()) {
            return minSdkVersion;
        }
        File[] platformSubDirs = platformDir.listFiles(File::isDirectory);
        int highestVersionBelowMinSdk = 0;
        int lowestVersionOverall = 0;
        for (File platform : platformSubDirs) {
            if (!platform.getName().startsWith("android-") || !FileUtils.join((File)platform, (String[])new String[]{"arch-" + abi.getArchitecture()}).isDirectory()) continue;
            try {
                int version = Integer.parseInt(platform.getName().substring("android-".length()));
                if (version > highestVersionBelowMinSdk && version < minSdkVersion) {
                    highestVersionBelowMinSdk = version;
                }
                if (lowestVersionOverall != 0 && version >= lowestVersionOverall) continue;
                lowestVersionOverall = version;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (highestVersionBelowMinSdk > 0) {
            return highestVersionBelowMinSdk;
        }
        Preconditions.checkState((lowestVersionOverall > 0 ? 1 : 0) != 0, (Object)String.format("Expected caller to ensure valid ABI: %s", new Object[]{abi}));
        return lowestVersionOverall;
    }

    private int findTargetPlatformVersionOrLower(int targetVersion) {
        File platformDir = new File(this.root, "/platforms");
        if (new File(platformDir, "android-" + targetVersion).exists()) {
            return targetVersion;
        }
        File[] platformSubDirs = platformDir.listFiles(File::isDirectory);
        int highestVersion = 0;
        for (File platform : platformSubDirs) {
            if (!platform.getName().startsWith("android-")) continue;
            try {
                int version = Integer.parseInt(platform.getName().substring("android-".length()));
                if (version <= highestVersion || version >= targetVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return highestVersion;
    }

    private static String getToolchainPrefix(Toolchain toolchain, Abi abi) {
        if (toolchain == Toolchain.GCC) {
            return abi.getGccToolchainPrefix();
        }
        return "llvm";
    }

    @Override
    public File getToolchainPath(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String version = toolchainVersion.isEmpty() ? this.getDefaultToolchainVersion(toolchain, abi) : toolchainVersion;
        version = version.isEmpty() ? "" : "-" + version;
        File prebuiltFolder = new File(this.getRootDirectory(), "toolchains/" + DefaultNdkInfo.getToolchainPrefix(toolchain, abi) + version + "/prebuilt");
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String hostOs = osName.contains("windows") ? "windows" : (osName.contains("mac") ? "darwin" : "linux");
        File[] toolchainPaths = prebuiltFolder.listFiles(File::isDirectory);
        if (toolchainPaths == null) {
            throw new InvalidUserDataException("Unable to find toolchain: " + prebuiltFolder);
        }
        if (toolchainPaths.length == 1) {
            return toolchainPaths[0];
        }
        File toolchainPath = new File(prebuiltFolder, hostOs + "-x86_64");
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        String osString = osName.equals("windows") ? hostOs : hostOs + "-x86";
        toolchainPath = new File(prebuiltFolder, osString);
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        throw new InvalidUserDataException("Unable to find toolchain prebuilt folder in: " + prebuiltFolder);
    }

    protected Abi getToolchainAbi(Abi abi) {
        return abi;
    }

    @Override
    public File getCCompiler(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String compiler = toolchain == Toolchain.CLANG ? "clang" : abi.getGccExecutablePrefix() + "-gcc";
        return new File(this.getToolchainPath(toolchain, toolchainVersion, abi), "bin/" + compiler);
    }

    @Override
    public File getCppCompiler(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String compiler = toolchain == Toolchain.CLANG ? "clang++" : abi.getGccExecutablePrefix() + "-g++";
        return new File(this.getToolchainPath(toolchain, toolchainVersion, abi), "bin/" + compiler);
    }

    @Override
    public File getLinker(Toolchain toolchain, String toolchainVersion, Abi abi) {
        return this.getCppCompiler(toolchain, toolchainVersion, abi);
    }

    @Override
    public File getAssembler(Toolchain toolchain, String toolchainVersion, Abi abi) {
        return this.getCCompiler(toolchain, toolchainVersion, abi);
    }

    @Override
    public File getAr(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String ar = abi.getGccExecutablePrefix() + (toolchain == Toolchain.CLANG ? "-ar" : "-gcc-ar");
        return new File(this.getToolchainPath(Toolchain.GCC, this.getDefaultToolchainVersion(Toolchain.GCC, abi), abi), "bin/" + ar);
    }

    @Override
    public File getStripExecutable(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        return FileUtils.join((File)this.getToolchainPath(Toolchain.GCC, toolchain == Toolchain.GCC ? toolchainVersion : this.getDefaultToolchainVersion(Toolchain.GCC, abi), abi), (String[])new String[]{"bin", abi.getGccExecutablePrefix() + "-strip"});
    }

    @Override
    public String getDefaultToolchainVersion(Toolchain toolchain, Abi abi) {
        String defaultVersion = this.defaultToolchainVersions.get(Pair.of((Object)((Object)toolchain), (Object)((Object)(abi = this.getToolchainAbi(abi)))));
        if (defaultVersion != null) {
            return defaultVersion;
        }
        String toolchainPrefix = DefaultNdkInfo.getToolchainPrefix(toolchain, abi);
        File toolchains = new File(this.getRootDirectory(), "toolchains");
        File[] toolchainsForAbi = toolchains.listFiles((dir, filename) -> filename.startsWith(toolchainPrefix));
        if (toolchainsForAbi == null || toolchainsForAbi.length == 0) {
            throw new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        for (File toolchainFolder : toolchainsForAbi) {
            String folderName = toolchainFolder.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    versionString = folderName.substring(toolchainPrefix.length() + 1);
                    revision = Revision.parseRevision((String)versionString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        this.defaultToolchainVersions.put((Pair<Toolchain, Abi>)Pair.of((Object)((Object)toolchain), (Object)((Object)abi)), bestVersionString);
        if (bestRevision == null) {
            throw new RuntimeException("Unable to find a valid toolchain in " + toolchains);
        }
        return bestVersionString;
    }

    @Override
    public StlNativeToolSpecification getStlNativeToolSpecification(Stl stl, String stlVersion, Abi abi) {
        StlSpecification spec = new DefaultStlSpecificationFactory().create(stl, (String)Objects.firstNonNull((Object)stlVersion, (Object)this.getDefaultToolchainVersion(Toolchain.GCC, abi)), abi);
        return new DefaultStlNativeToolSpecification(this, spec, stl);
    }
}

