/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.IntermediateFolderUtils;
import com.android.build.gradle.internal.pipeline.TransformOutputProviderImpl;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class IntermediateStream
extends TransformStream {
    private final Supplier<File> rootLocation;

    static Builder builder() {
        return new Builder();
    }

    private IntermediateStream(Set<QualifiedContent.ContentType> contentTypes, Set<? super QualifiedContent.Scope> scopes, Supplier<File> rootLocation, List<? extends Object> dependencies) {
        super(contentTypes, scopes, dependencies);
        this.rootLocation = rootLocation;
    }

    Supplier<File> getRootLocation() {
        return this.rootLocation;
    }

    TransformOutputProvider asOutput() {
        return new TransformOutputProviderImpl((File)this.rootLocation.get());
    }

    @Override
    List<File> getInputFiles() {
        return ImmutableList.of((Object)this.rootLocation.get());
    }

    @Override
    TransformInput asNonIncrementalInput() {
        return IntermediateFolderUtils.computeNonIncrementalInputFromFolder((File)this.rootLocation.get(), this.getContentTypes(), this.getScopes());
    }

    @Override
    IncrementalTransformInput asIncrementalInput() {
        return IntermediateFolderUtils.computeIncrementalInputFromFolder((File)this.rootLocation.get(), this.getContentTypes(), this.getScopes());
    }

    @Override
    TransformStream makeRestrictedCopy(Set<QualifiedContent.ContentType> types, Set<? super QualifiedContent.Scope> scopes) {
        return new IntermediateStream(types, scopes, this.rootLocation, this.getDependencies());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rootLocation", this.rootLocation.get()).add("scopes", this.getScopes()).add("contentTypes", this.getContentTypes()).add("dependencies", this.getDependencies()).toString();
    }

    static final class Builder {
        private Set<QualifiedContent.ContentType> contentTypes = Sets.newHashSet();
        private Set<QualifiedContent.ScopeType> scopes = Sets.newHashSet();
        private Supplier<File> rootLocation;
        private List<? extends Object> dependencies;

        Builder() {
        }

        public IntermediateStream build() {
            Preconditions.checkNotNull(this.rootLocation);
            Preconditions.checkState((!this.contentTypes.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((!this.scopes.isEmpty() ? 1 : 0) != 0);
            return new IntermediateStream((Set)ImmutableSet.copyOf(this.contentTypes), (Set)ImmutableSet.copyOf(this.scopes), this.rootLocation, this.dependencies != null ? this.dependencies : ImmutableList.of());
        }

        Builder addContentTypes(Set<QualifiedContent.ContentType> types) {
            this.contentTypes.addAll(types);
            return this;
        }

        Builder addContentTypes(QualifiedContent.ContentType ... types) {
            this.contentTypes.addAll(Arrays.asList(types));
            return this;
        }

        Builder addScopes(Set<? super QualifiedContent.Scope> scopes) {
            for (QualifiedContent.Scope scope : scopes) {
                this.scopes.add((QualifiedContent.ScopeType)scope);
            }
            return this;
        }

        Builder addScopes(QualifiedContent.Scope ... scopes) {
            this.scopes.addAll(Arrays.asList(scopes));
            return this;
        }

        Builder setRootLocation(File rootLocation) {
            this.rootLocation = Suppliers.ofInstance((Object)rootLocation);
            return this;
        }

        Builder setDependency(Object dependency) {
            this.dependencies = ImmutableList.of((Object)dependency);
            return this;
        }
    }
}

